import sys
sys.path.append("..")
import math
import itertools

from threading import Thread

from coord import Coord
from world import World
from players import Players
from connector import GameConnector
# from mapwindow import MapWindow

import logging
logger = logging.getLogger(__name__)

from operator import is_not
from functools import partial

NET_INPUT_UP = 1 << 0
NET_INPUT_DOWN = 1 << 1
NET_INPUT_LEFT = 1 << 2
NET_INPUT_RIGHT = 1 << 3
NET_INPUT_SPACE = 1 << 4
NET_INPUT_RETURN = 1 << 5


class Bot(object):
    debug = False
    gc = None
    wait = True
    target = Coord(x=3, y=3)
    name = "bsbot"
    dead = False
    factor = 7
    pathlist = []
    start_pos = Coord(x=0, y=0)
    me = None

    def __init__(self, hostname, port):
        self.players = Players(None, 0)

        self.mapData = World(Coord(x=0, y=0), [], Coord(x=0, y=0), [], self)

        self.gc = GameConnector(self.name)
        self.gc.connect(hostname, port)

        self.gc.handler_mapdata = self.mapUpdate
        self.gc.handler_ownposition = self.ownPosition
        self.gc.handler_enemylist = self.enemyList
        self.gc.handler_commandrequest = self.makeChoice
        self.gc.handler_bomblist = self.bombList
        self.gc.handler_endround = self.endOfRound
        self.gc.handler_dead = self.dead
        self.gc.handler_updateself = self.updateSelf
        self.gc.start_pos = self.start_pos
        self.gc.factor = self.factor
        self.gc.pathlist = self.pathlist

        #self.mapWindow = Thread(target=MapWindow,
        #                        args=(Coord(x=0, y=0), [],
        #                              Coord(x=0, y=0), [],
        #                              self.mapData, self.players, self)
        #                        )

        #self.mapWindow.daemon = True
        #self.mapWindow.start()

    def enemyList(self, enemies):
        pass

    def makeChoice(self):
        targetTile = self.mapData.updateTarget(self.me['pos'])

        targetCoord = self.mapData.getCorneringPointForTile(targetTile)
        self.mapData.setTCoord(targetCoord)
        self.mapData.setTTile(targetTile)

        currentAngle = ((math.atan2(self.me['direction'].y,
                        self.me['direction'].x) * 180 / math.pi) + 180)

        # targetCoord = Coord(x=800, y=900)
        # targetVector = (targetCoord - self.me['pos']).normalize()
        targetVector = (targetCoord - self.me['pos'])

        targetAngle = ((math.atan2(targetVector.y,
                        targetVector.x) * 180 / math.pi) + 180)

        deltaAngle = targetAngle - currentAngle

        if self.debug is True:
            print "TargetTile: " + str(targetTile)
            print "TargtCoord: " + str(targetCoord)
            print "CurrentAngle: " + str(currentAngle)
            print "TargetVector: " + str(targetVector)
            print "TargetAngle: " + str(targetAngle)
            print "DeltaAngle: " + str(deltaAngle)

        if deltaAngle > 180:
            deltaAngle -= 360
        elif deltaAngle < -180:
            deltaAngle += 360

        buttonsPressed = 0

        if math.fabs(deltaAngle) < 95:
            buttonsPressed |= NET_INPUT_UP
        if math.fabs(deltaAngle) > 41:
            pass
        if deltaAngle < -5:
            buttonsPressed |= NET_INPUT_LEFT
        elif deltaAngle > 5:
            buttonsPressed |= NET_INPUT_RIGHT

        return buttonsPressed

    def bombList(self):
        pass

    def endOfRound(self):
        pass

    def updateSelf(self, me, own_id):
        if not me:
            return

        self.me = me
        self.players.own_id = own_id
        self.players.update([me], own_id)

    def run(self):
        self.gc.parsingLoop()

    def ownPosition(self, ownPosition):
        if self.debug:
            print "I am at {0}".format(ownPosition)
        self.ownPosition = ownPosition

    def mapUpdate(self, mapSize, mapTiles, r_mapSize=None, r_mapTiles=None):
        if self.debug:
            print "Map is {0}".format(mapSize)

        self.mapData.update(mapSize, mapTiles, r_mapSize, r_mapTiles)

        # Fix theese values, what do they even mean?
        # Starting tiles on default map are x=3, y=1 * (scaling factor)
        merge_path = []
        for i in range(0, len(self.pathlist)):
            if i == len(self.pathlist)-1:
                p_coord = self.pathlist[i] * self.factor + self.factor/2
                p_target = self.pathlist[0] * self.factor + self.factor/2
                path = self.mapData.search(p_coord, p_target)
                merge_path.append(path[:-1])  # don't repeat last itme twice
                break

            p_coord = self.pathlist[i] * self.factor + ((self.factor/2))
            p_target = self.pathlist[i+1] * self.factor + ((self.factor/2))
            path = self.mapData.search(p_coord, p_target)
            merge_path.append(path[:-1]) # don't repeat last item

        m = filter(partial(is_not, None), merge_path)
        merged = list(itertools.chain.from_iterable(m))
        self.mapData.path = merged
        print self.mapData.path

if __name__ == "__main__":
    bot = Bot('localhost', 31337)
    # bot = Bot('151.216.166.196', 31337) #chiller
    #bot = Bot('192.168.1.41', 31337) # nitelite
    bot.run()
