;----------------------
; escape room 6f
; aka melonik interko
; by wackee/arise
;----------------------
;
;--------------
; memory map
;--------------
;
; 0800 - 0f00 kod
; 0f00 - 1000 sprajty 1
; 1000 - 1300 (wolne)
; 1300 - 1b00 muzyka
; 1b00 - 2000 (wolne)
; 2000 - 2800 charset x1
; 2800 - 4000 ekrany 1-6
; 4000 - 4800 charset x2
; 4800 - 6c00 ekrany 7-15
; 6c00 - 7000 kolory 1
; 7000 - 7100 sprajty 1
; 7100 - 7200 fonty (1/8)

;--------------
; basic line
;--------------


		* = $0801

		.byte      $0b, $08, $01, $00, $9e, $32, $30
		.byte $36, $34, $00, $00


;--------------
; main
;--------------

			* = $0810
			
			sei
				
			lda #$35	
			sta $01	
				
			ldy #$01	
			jsr wait	
				
			lda #$00	
			sta $d020	
			sta $d021	
							
			lda #$0b				
			sta $d011				
										
			; set up irq		
					
			lda #$7f		
			sta $dc0d		
			sta $dd0d		
					
			lda $dc0d	; clean the pending cia 		
			lda $dd0d		
					
			lda #$01		
			sta $d01a		
					
			lda #$40		
			sta $d012		
					
			lda #$0b	; turn the screen off		
			sta $d011		
							
			lda #<irq1		
			sta $fffe		
			lda #>irq1		
			sta $ffff		
					
			; reset scroll
			
			lda #<scroll
			sta ad_scroll + 1
			lda #>scroll
			sta ad_scroll + 2

			; init msx

			lda #$00
			jsr $1300

;----------------------------------
					
			; main		
					
			ldx #$00

			; copy colors
			; icludes nibble swap ;)
			
copy_kol	lda kolory,x
			ror
			ror
			ror
			ror
			sta $d800,x
			
			lda kolory + $100,x
			ror
			ror
			ror
			ror
			sta $d900,x
			
			lda kolory + $200,x
			ror
			ror
			ror
			ror
			sta $da00,x
			
			lda kolory + $300,x
			ror
			ror
			ror
			ror
			sta $db00,x
			
			inx
			bne copy_kol 
			
			; sprites setup
									
			ldx #$00
			lda #$00
spr_fill	sta $0f00,x
			sta $7000,x
			inx
			bne spr_fill
						
			lda #%00001111
			sta $d015	; turn on
			lda #%00001110
			sta $d010	; 9th bit of x
			
			; x
			lda #$f2
			sta $d000
			lda #$0a
			sta $d002
			lda #$22
			sta $d004
			lda #$3a
			sta $d006
					
			; y
			lda #$f0
			sta $d001
			sta $d003
			sta $d005
			sta $d007
			
			; color
			lda #1
			sta $d027
			sta $d028
			sta $d029
			sta $d02a
			
			lda #0
			sta $d01c ; hires
			sta $d017 ; no stretch x
			sta $d01d ; no stretch y
						
			jsr pointers		
						
			lda #$00			
			jsr scode			
						
			ldy #1			
			jsr wait			
						
			lda #$40			
			sta $d012			
						
			lda #$1b		; turn the screen on			
			sta $d011			
									
			cli			

			; main display routine
			
main_loop	ldx frame
			
			lda ad_dd00 , x
			sta ora_dd00 + 1 
			lda ad_d018_ch , x
			sta ora_d018_1 + 1
			lda ad_d018_sc , x
			sta ora_d018_2 + 1
			
			lda $dd00
			and #$fc			
ora_dd00	ora #$00			
			sta $dd00			
						
			lda $d018			
			and #$01			
ora_d018_1	ora #$00			
ora_d018_2	ora #$00			
			sta $d018			

			; scroll 0f00
			
			; column 1/12
			
			clc
			rol $7000
			clc
			rol $7003
			clc
			rol $7006
			clc
			rol $7009
			clc
			rol $700c
			clc
			rol $700f
			clc
			rol $7012
			clc
			rol $7015

			; column 2/12
			
			clc
			rol $7001
			bcc *+5
			inc $7000
			
			clc
			rol $7004
			bcc *+5
			inc $7003

			clc
			rol $7007
			bcc *+5
			inc $7006

			clc
			rol $700a
			bcc *+5
			inc $7009

			clc
			rol $700d
			bcc *+5
			inc $700c

			clc
			rol $7010
			bcc *+5
			inc $700f

			clc
			rol $7013
			bcc *+5
			inc $7012

			clc
			rol $7016
			bcc *+5
			inc $7015

			; column 3/12
			
			clc
			rol $7002
			bcc *+5
			inc $7001
			
			clc
			rol $7005
			bcc *+5
			inc $7004

			clc
			rol $7008
			bcc *+5
			inc $7007

			clc
			rol $700b
			bcc *+5
			inc $700a

			clc
			rol $700e
			bcc *+5
			inc $700d

			clc
			rol $7011
			bcc *+5
			inc $7010

			clc
			rol $7014
			bcc *+5
			inc $7013

			clc
			rol $7017
			bcc *+5
			inc $7016

			; column 4/12
			
			clc
			rol $7040
			bcc *+5
			inc $7002
			
			clc
			rol $7043
			bcc *+5
			inc $7005

			clc
			rol $7046
			bcc *+5
			inc $7008

			clc
			rol $7049
			bcc *+5
			inc $700b

			clc
			rol $704c
			bcc *+5
			inc $700e

			clc
			rol $704f
			bcc *+5
			inc $7011

			clc
			rol $7052
			bcc *+5
			inc $7014

			clc
			rol $7055
			bcc *+5
			inc $7017

			; column 5/12
			
			clc
			rol $7041
			bcc *+5
			inc $7040
			
			clc
			rol $7044
			bcc *+5
			inc $7043

			clc
			rol $7047
			bcc *+5
			inc $7046

			clc
			rol $704a
			bcc *+5
			inc $7049

			clc
			rol $704d
			bcc *+5
			inc $704c

			clc
			rol $7050
			bcc *+5
			inc $704f

			clc
			rol $7053
			bcc *+5
			inc $7052

			clc
			rol $7056
			bcc *+5
			inc $7055

			; column 6/12
			
			clc
			rol $7042
			bcc *+5
			inc $7041
			
			clc
			rol $7045
			bcc *+5
			inc $7044

			clc
			rol $7048
			bcc *+5
			inc $7047

			clc
			rol $704b
			bcc *+5
			inc $704a

			clc
			rol $704e
			bcc *+5
			inc $704d

			clc
			rol $7051
			bcc *+5
			inc $7050

			clc
			rol $7054
			bcc *+5
			inc $7053

			clc
			rol $7057
			bcc *+5
			inc $7056

			; column 7/12
			
			clc
			rol $7080
			bcc *+5
			inc $7042
			
			clc
			rol $7083
			bcc *+5
			inc $7045

			clc
			rol $7086
			bcc *+5
			inc $7048

			clc
			rol $7089
			bcc *+5
			inc $704b

			clc
			rol $708c
			bcc *+5
			inc $704e

			clc
			rol $708f
			bcc *+5
			inc $7051

			clc
			rol $7092
			bcc *+5
			inc $7054

			clc
			rol $7095
			bcc *+5
			inc $7057

			; column 8/12
			
			clc
			rol $7081
			bcc *+5
			inc $7080
			
			clc
			rol $7084
			bcc *+5
			inc $7083

			clc
			rol $7087
			bcc *+5
			inc $7086

			clc
			rol $708a
			bcc *+5
			inc $7089

			clc
			rol $708d
			bcc *+5
			inc $708c

			clc
			rol $7090
			bcc *+5
			inc $708f

			clc
			rol $7093
			bcc *+5
			inc $7092

			clc
			rol $7096
			bcc *+5
			inc $7095

			; column 9/12
			
			clc
			rol $7082
			bcc *+5
			inc $7081
			
			clc
			rol $7085
			bcc *+5
			inc $7084

			clc
			rol $7088
			bcc *+5
			inc $7087

			clc
			rol $708b
			bcc *+5
			inc $708a

			clc
			rol $708e
			bcc *+5
			inc $708d

			clc
			rol $7091
			bcc *+5
			inc $7090

			clc
			rol $7094
			bcc *+5
			inc $7093

			clc
			rol $7097
			bcc *+5
			inc $7096

			; column 10/12
			
			clc
			rol $70c0
			bcc *+5
			inc $7082
			
			clc
			rol $70c3
			bcc *+5
			inc $7085

			clc
			rol $70c6
			bcc *+5
			inc $7088

			clc
			rol $70c9
			bcc *+5
			inc $708b

			clc
			rol $70cc
			bcc *+5
			inc $708e

			clc
			rol $70cf
			bcc *+5
			inc $7091

			clc
			rol $70d2
			bcc *+5
			inc $7094

			clc
			rol $70d5
			bcc *+5
			inc $7097

			; column 11/12
			
			clc
			rol $70c1
			bcc *+5
			inc $70c0
			
			clc
			rol $70c4
			bcc *+5
			inc $70c3

			clc
			rol $70c7
			bcc *+5
			inc $70c6

			clc
			rol $70ca
			bcc *+5
			inc $70c9

			clc
			rol $70cd
			bcc *+5
			inc $70cc

			clc
			rol $70d0
			bcc *+5
			inc $70cf

			clc
			rol $70d3
			bcc *+5
			inc $70d2

			clc
			rol $70d6
			bcc *+5
			inc $70d5

			; column 12/12
			
			clc
			rol $70c2
			bcc *+5
			inc $70c1
			
			clc
			rol $70c5
			bcc *+5
			inc $70c4

			clc
			rol $70c8
			bcc *+5
			inc $70c7

			clc
			rol $70cb
			bcc *+5
			inc $70ca

			clc
			rol $70ce
			bcc *+5
			inc $70cd

			clc
			rol $70d1
			bcc *+5
			inc $70d0

			clc
			rol $70d4
			bcc *+5
			inc $70d3

			clc
			rol $70d7
			bcc *+5
			inc $70d6

			; new char
			
ad_scroll	lda $dead		; always makes me smile ;)

			; char bytes changes

			cmp #$2e	; full stop / kropka
			bne *+4
			lda #$1b
			
			cmp #$2c	; comma / przecinek
			bne *+4
			lda #$1c
			
			cmp #$21	; !
			bne *+4
			lda #$1d
			
			cmp #$3f	; ?
			bne *+4
			lda #$1e
			
			cmp #$2f	; /
			bne *+4
			lda #$1f

			cmp #$ff
			bne nie_reset_scrolla

			lda #<scroll
			sta ad_scroll + 1
			lda #>scroll
			sta ad_scroll + 2
			
			lda #$07			
			sta licznik_znak			

			jmp ad_scroll
			
nie_reset_scrolla			

			clc
			rol 
			clc
			rol 
			clc
			rol 
			
			tax

			ldy #0
cpy_font	lda font,x
			sta ten_znak,y
			inx
			iny
			cpy #8
			bne cpy_font
						
			ldx licznik_znak
			lda and_znak,x
			sta and_teraz
			
			ldx #0
			
andujemy	lda ten_znak,x
			and and_teraz
			sta ten_znak,x
			inx
			cpx #$08
			bne andujemy
			
			lda ten_znak
			cmp #$00
			beq *+5
			inc $70c2
			
			lda ten_znak + 1
			cmp #$00
			beq *+5
			inc $70c5

			lda ten_znak + 2
			cmp #$00
			beq *+5
			inc $70c8

			lda ten_znak + 3
			cmp #$00
			beq *+5
			inc $70cb

			lda ten_znak + 4
			cmp #$00
			beq *+5
			inc $70ce

			lda ten_znak + 5
			cmp #$00
			beq *+5
			inc $70d1

			lda ten_znak + 6
			cmp #$00
			beq *+5
			inc $70d4

			lda ten_znak + 7
			cmp #$00
			beq *+5
			inc $70d7

			dec licznik_znak
			lda licznik_znak
			cmp #$ff
			bne nie_reset_znak
			
			lda #$07
			sta licznik_znak
			
			inc ad_scroll + 1
			lda ad_scroll + 1
			cmp #0
			bne nie_reset_znak
			
			inc ad_scroll + 2			
			
nie_reset_znak			

			; copy to $0f00
			
			ldx #0
spr_copy	lda $7000,x
			sta $0f00,x
			lda $7040,x
			sta $0f40,x
			lda $7080,x
			sta $0f80,x
			lda $70c0,x
			sta $0fc0,x
			inx
			cpx #24
			bne spr_copy 
			
			dec frame				
			lda frame				
			cmp #$ff				
			bne main_loop_point				
							
			lda #$0e				
			sta frame				
							
main_loop_point			
			
			ldy #2
			jsr wait
			
			jmp main_loop				
			
;------------------------------------
; irq
;------------------------------------

irq1		sta ia + 1
			stx ix + 1
			sty iy + 1
			
			lda #$ff
			sta $d019
			
			lda #$d0
			sta $d012
			lda #$1b
			sta $d011
			
			lda #<irq2
			sta $fffe
			lda #>irq2
			sta $ffff
			
			jsr $1303
									
ia			lda #$00
ix			ldx #$00
iy			ldy #$00

			rti



irq2		sta ja + 1
			stx jx + 1
			sty jy + 1
			
			lda #$ff
			sta $d019
			
			lda #$40
			sta $d012
			lda #$1b
			sta $d011
			
			lda #<irq1
			sta $fffe
			lda #>irq1
			sta $ffff

			jsr $1303
			
			jsr check_1760
			lda blysk_kolor
			jsr scode
						
ja			lda #$00
jx			ldx #$00
jy			ldy #$00

			rti

;------------------------------------
; variables etc
;------------------------------------

frame		.byte $0e

licznik_znak	.byte	$07

ten_znak		.byte $00, $00, $00, $00, $00, $00, $00, $00		
and_znak		.byte $01, $02, $04, $08, $10, $20, $40, $80 		
and_teraz		.byte $00

blysk_licz		.byte $09

blysk_kolor		.byte $00

;					    0    1    2    3    4    5    6    7   	8    9
blysk_tab		.byte $01, $0d, $07, $03, $03, $03, $03, $03, $00, $00

;-------------------------------------
; procedures
;-------------------------------------

			; a classic wait
			; y - amount of frames
			;
wait		bit $d011
			bpl *-3
			bit $d011
			bmi *-3
			dey
			bne wait
			rts
			;

			; this one is for detecting basedrum

check_1760
			lda $1760
			cmp #$fe
			bne nie_drum
						
			lda #0
			sta blysk_licz
			jmp nie_reset_licz
						
nie_drum	lda blysk_licz
			cmp #9
			beq nie_reset_licz
			
			inc blysk_licz
			lda blysk_licz
			cmp #8
			bne nie_reset_licz

			lda #7
			sta blysk_licz

nie_reset_licz
			ldx blysk_licz
			lda blysk_tab,x
			sta blysk_kolor
			rts

;-------------------------------------
; tabs
;-------------------------------------

;			       01  02  03  04  05  06  07  08  09  10  11  12  13  14  15
ad_dd00		.byte $03,$03,$03,$03,$03,$03,$02,$02,$02,$02,$02,$02,$02,$02,$02
ad_d018_ch	.byte $08,$08,$08,$08,$08,$08,$00,$00,$00,$00,$00,$00,$00,$00,$00
ad_d018_sc	.byte $a0,$b0,$c0,$d0,$e0,$f0,$20,$30,$40,$50,$60,$70,$80,$90,$a0

;-----------------------
; binary includes
;-----------------------

		* = $1300 
		; 
		; music
		;
		.binary "1300.gubbplasma.prg",2

		* = $2000 
		; 
		; charset
		;
		.binary "2000.codebook.prg",2

		* = $2800 
		;
		; frames 01-06
		;
		.binary "01f.prg",2
		.binary "02f.prg",2
		.binary "03f.prg",2
		.binary "04f.prg",2
		.binary "05f.prg",2
		.binary "06f.prg",2
		
		* = $4000 
		;
		; charset again, i know this is lazy :)
		;
		.binary "2000.codebook.prg",2 

		* = $4800 
		;
		; frames 07-15
		;
		.binary "07f.prg",2
		.binary "08f.prg",2
		.binary "09f.prg",2
		.binary "10f.prg",2
		.binary "11f.prg",2
		.binary "12f.prg",2
		.binary "13f.prg",2
		.binary "14f.prg",2
		.binary "15f.prg",2

		* = $6c00
		;
		; screen colors
		;		
kolory	.binary "kolory.v2.prg",2

		* = $7100
		;
		; charset
		;
font	.binary "font.100.v2.prg",2

		;
		; speedcode (lazyness again...)
		;
scode	.binary "scode.v2.prg",2
		.byte $60

		;
		; scroll text
		;
scroll	.screen "                         "
		.screen "hehe no i co? i udalo mi sie wyjsc z domku. "
		.screen "lawka to byla kiepska lamiglowka... "
		.screen "pozdro dla torun escape team czyli bimbra, kenjiego i roodego."
		.screen "     press any reset?...   "
		.screen "   "
		.byte $ff

;-------------------------------------
; a quick hack ;)
;-------------------------------------

		* = $c000
		;
		; setting up some sprite pointers.
		; moved here to avoid overlapping code
		; 
	
pointers
		
			lda #$3c
			sta $2bf8
			sta $2ff8
			sta $33f8
			sta $37f8
			sta $3bf8
			sta $3ff8
			
			lda #$3d
			sta $2bf9
			sta $2ff9
			sta $33f9
			sta $37f9
			sta $3bf9
			sta $3ff9

			lda #$3e
			sta $2bfa
			sta $2ffa
			sta $33fa
			sta $37fa
			sta $3bfa
			sta $3ffa

			lda #$3f
			sta $2bfb
			sta $2ffb
			sta $33fb
			sta $37fb
			sta $3bfb
			sta $3ffb
			
			lda #$c0
			sta $4bf8
			sta $4ff8
			sta $53f8
			sta $57f8
			sta $5bf8
			sta $5ff8
			sta $63f8
			sta $67f8
			sta $6bf8		
			
			lda #$c1
			sta $4bf9
			sta $4ff9
			sta $53f9
			sta $57f9
			sta $5bf9
			sta $5ff9
			sta $63f9
			sta $67f9
			sta $6bf9		
			
			lda #$c2
			sta $4bfa
			sta $4ffa
			sta $53fa
			sta $57fa
			sta $5bfa
			sta $5ffa
			sta $63fa
			sta $67fa
			sta $6bfa		
			
			lda #$c3
			sta $4bfb
			sta $4ffb
			sta $53fb
			sta $57fb
			sta $5bfb
			sta $5ffb
			sta $63fb
			sta $67fb
			sta $6bfb
			
			rts

;--------------------
; all ends here
;---------------------