public class Starfield5 implements Effect
{
  int w, h;
  int starsize = 5, starcount = 2;
  
  float sizeratio = 0.35;
  
  PVector location[], speed[];
  float anglespeed, angle[];
  PVector center = new PVector(w/2, h/2);
  
  void setup(PGraphics pg)
  {
    w = pg.width; h = pg.height;
    background(0);
    size(w, h);
    smooth();
    sketchFullScreen();
  
    location = new PVector[starcount];
    speed = new PVector[starcount];
    angle = new float[starcount];
    for (int i = 0; i < starcount; i++) {
      location[i] = new PVector(w/2, h/2);
    }
    angle[0] = PI/2;
    angle[1] = 3*PI/2;
    speed[0] = new PVector(0, -0.5);
    speed[1] = new PVector(0, 0.5);
    anglespeed = 0.001;
  }
  
  void draw(PGraphics pg)
  {
    pg.beginDraw();
    PVector center = new PVector(pg.width/2, pg.height/2);
    for (int i = 0; i < starcount; i++) {
      angle[i] = angle[i] + anglespeed*center.dist(location[i]);
      location[i].add(new PVector(25*cos(angle[i]), 25*sin(angle[i])));
      location[i].add(speed[i]);
      println("angle: " + angle[i] + " cos: " + cos(angle[i]) + " sin: " + sin(angle[i]));
      pg.ellipse(location[i].x, location[i].y, starsize + sizeratio*center.dist(location[i]), starsize+sizeratio*center.dist(location[i]));
    }
    pg.endDraw();
  }
  
  void mouseClicked(MouseEvent e)
  {
    if (mouseButton == RIGHT)
      clear();
    for (PVector l: location) {
//      l.set(w/2, h/2);
    }    
    for (PVector s: speed) {
//      s.set(random(s_lo, s_hi), random(s_lo, s_hi));
    }
  }  //method
}  //class
