
float dist(in vec3 pos, out float mat)
{
	float d = 100000.0;

	float gd = pos.y + 3.0;

	if (gd < d)
	{
		mat = 2.0;
		d = gd;
	}

	float sphd = length(pos - vec3(0.0)) - 3.0;
	if (sphd < d)
	{
		mat = 1.0;
		d = sphd;
	}

	return d;
}

vec3 normal(vec3 p) 
{
	vec3 e = vec3(0.2, 0.0, 0.0);
	vec3 n;
	float uf;
	n.x = dist(p + e.xyy,uf) - dist(p - e.xyy,uf);
	n.y = dist(p + e.yxy,uf) - dist(p - e.yxy,uf);
	n.z = dist(p + e.yyx,uf) - dist(p - e.yyx,uf);
	return normalize(n);
}

mat3 rot_y(float ang){ return mat3(
			cos(ang), 0.0, -sin(ang),
			0.0,      1.0, 0.0,
			sin(ang), 0.0, cos(ang)); }

vec4 function()
{
	float ft = motionblur(2.0);
	vec3 rd_camspace = normalize(vec3(uv2, 2.0));

	vec3 rp;
	float rl;
	vec3 rd;

	mat3 rotmtx = mat3(1.0);

	rotmtx = rot_y(ft * 0.5323);

	rd = rotmtx * rd_camspace;
	vec3 ro = rotmtx * vec3(0.0, 0.0, -15.0);


	rp = ro;
	rl = 0.0;

	float mat = 0.0;

	for (int i = 0; i < 256; i++)
	{
		float d;
		float matn;

		d = dist(rp, matn);

		if (d < 0.1)
		{
			mat = matn;
			break;
		}
		if (rl > 200.0)
			break;

		rp += rd * d * 0.8;
		rl += rd_camspace.z * d * 0.8;

	}

	vec3 col = vec3(0.0);

	vec3 normal = normal(rp);

	vec3 lightdir = normalize(vec3(1.0, 1.0, 0.0));
	float lightamount = clamp(dot(normal, lightdir), 0.1, 1.0);


	if (mat < 0.5)
	{

	}
	else if (mat < 1.5)
	{
		col = vec3(1.0, 0.0, 0.0);
	}
	else if (mat < 2.5)
	{
		float checker = mod(floor(rp.z * 0.6) + floor(rp.x * 0.6), 2.0);
		col = vec3(1.0) * (0.1 + checker * 0.9);
		//col = vec3(0.5 + sin(ft) * 0.5);
		if (length(rp.xz-vec2(4.0,3.0)) < 3.0)
			col = vec3(1.0);
	}

	col *= lightamount;

	float hitdist = rl;

	float zf = 14.0;
	float focusarea = hitdist-zf;

	float blr = max(0.0, pow(focusarea, 2.0)-0.0)*sign(focusarea) * -0.01 + 0.5;
	//blr = 0.5;




	return vec4(col, blr);
}