#include "ShaderCommon.fx"
#include "gpunoise.fx"

cbuffer ShatterParams
{
	float4 hitParams;		// xyz is hitpos, w is force width
	float4 forceParams;		// xyz is force direction, w is force amount
	float4 dimensions;		// xy is dimensions, zw is inv dimensions
};

static float forceMulScalars[3] = 
{
	1.00f,
	0.95f,
	0.90f,
};

DefaultVertexOut ShatterVS(DefaultVertexIn input, uint id : SV_VertexID)
{
	DefaultVertexOut output = (DefaultVertexOut)0;
	uint primId = id / 3;
	float4x4 t = (float4x4)0;

	float force = 0.0f;
	float2 hitPos = hitParams.xy * dimensions.zw;
	float2 normalizedPos = input.position.xy * dimensions.zw;
	float3 r = float3(fbm(input.position.xyz),
					  fbm(input.position.xyz*123.0f),
					  fbm(input.position.xyz*2573.0f));

	float3 forceDir = normalize(forceParams.xyz);
	float forceMul = forceParams.w * forceMulScalars[primId%3];
	float forceWidth = hitParams.w;

	float d = distance(hitPos, normalizedPos);
	float powCurve = pow(((4.0f * d) * (1.0f - d)), forceParams.w);
	float3 displacement = forceDir * forceMul * pow(d, 0.3f);

	float4 pos = float4(displacement + input.position.xyz, 1.0f);

	output.wpos = mul(pos, World);
	output.position = mul( mul( output.wpos, View), Projection);
	//output.color = input.color;
	output.color = float4(0.01f, 0.01f, 0.05f, 0.5f);
	output.normal = normalize(r + input.normal);
	output.uv = input.uv;
	return output;
}

float4 ShatterPS(DefaultVertexOut input) : SV_Target
{
	//return float4(input.color.xyz, 1.0f);

	float3 color = input.color.xyz + renderDirectionalLight(directionalLights[0], input.position.xyz, input.normal.xyz);
	//color += ambLightColor.xyz;
	return float4(color, input.color.a);
	//return float4(input.normal.xyz, 1.0f);
}