#include "ShaderCommon.fx"

Texture2D<float4> InputTexture;

cbuffer TransitionParams
{
	float4 fadeParams;		// xyz is fade color, w is interpolant
}

float3 Fade(float3 baseCol, float3 fadeCol, float interp)
{
	return lerp(baseCol, fadeCol, interp);
}

float4 PassThroughPS(FullScreenVertexOut input) : SV_Target
{
	float3 baseCol = InputTexture.SampleLevel(PointClampSampler, input.uv, 0).xyz;
	float3 fadeCol = fadeParams.xyz;

	return float4(saturate(Fade(baseCol, fadeCol, fadeParams.w)), 1.0f);
}