#include "ShaderCommon.fx"

Texture2D<float4> InputTexture;

#define BLURSIZE		0.0001f

//float4 BlurBasicPS(FullScreenVertexOut input) : SV_Target
//{
//	const float blurDist = BLURSIZE;
//
//	float2 uv = input.uv;
//	float4 col = float4(0.0f, 0.0f, 0.0f, 0.0f);
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv + float2(-blurDist, -blurDist), 0);
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv + float2(0, -blurDist), 0);
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv + float2(blurDist, -blurDist), 0);
//	
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv + float2(-blurDist, 0), 0);
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv, 0);
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv + float2(blurDist, 0), 0);
//
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv + float2(-blurDist, blurDist), 0);
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv + float2(0, -blurDist), 0);
//	col += InputTexture.SampleLevel(BilinearClampSampler, uv + float2(blurDist, blurDist), 0);
//
//	col *= 1.0f / 9.0f;
//
//	return col;
//}

static const float2 hblurTexOffset[14] = 
{
	float2(-0.028, 0.0),
	float2(-0.024, 0.0),
	float2(-0.020, 0.0),
	float2(-0.016, 0.0),
	float2(-0.012, 0.0),
	float2(-0.008, 0.0),
	float2(-0.004, 0.0),
	float2( 0.004, 0.0),
	float2( 0.008, 0.0),
	float2( 0.012, 0.0),
	float2( 0.016, 0.0),
	float2( 0.020, 0.0),
	float2( 0.024, 0.0),
	float2( 0.028, 0.0),
};

static const float2 vblurTexOffset[14] = 
{
	float2(0.0f, -0.028),
	float2(0.0f, -0.024),
	float2(0.0f, -0.020),
	float2(0.0f, -0.016),
	float2(0.0f, -0.012),
	float2(0.0f, -0.008),
	float2(0.0f, -0.004),
	float2(0.0f,  0.004),
	float2(0.0f,  0.008),
	float2(0.0f,  0.012),
	float2(0.0f,  0.016),
	float2(0.0f,  0.020),
	float2(0.0f,  0.024),
	float2(0.0f,  0.028),
};

static const float gaussianWeights[15] =
{
	0.0044299121055113265,
	0.00895781211794,
	0.0215963866053,
	0.0443683338718,
	0.0776744219933,
	0.115876621105,
	0.147308056121,
	0.159576912161,
	0.147308056121,
	0.115876621105,
	0.0776744219933,
	0.0443683338718,
	0.0215963866053,
	0.00895781211794,
	0.0044299121055113265,
};

float4 GaussianBlurHorizontalPS(FullScreenVertexOut input) : SV_Target
{
	float2 uv = input.uv;
	const float blurSize = BLURSIZE;

	float4 col = float4(0.0f, 0.0f, 0.0f, 0.0f);
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 0], 0) * gaussianWeights[ 0];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 1], 0) * gaussianWeights[ 1];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 2], 0) * gaussianWeights[ 2];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 3], 0) * gaussianWeights[ 3];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 4], 0) * gaussianWeights[ 4];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 5], 0) * gaussianWeights[ 5];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 6], 0) * gaussianWeights[ 6];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv					 , 0) * gaussianWeights[ 7];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 7], 0) * gaussianWeights[ 8];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 8], 0) * gaussianWeights[ 9];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[ 9], 0) * gaussianWeights[10];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[10], 0) * gaussianWeights[11];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[11], 0) * gaussianWeights[12];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[12], 0) * gaussianWeights[13];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + hblurTexOffset[13], 0) * gaussianWeights[14];
	col /= 14.0f;
	return col;
}

float4 GaussianBlurVerticalPS(FullScreenVertexOut input) : SV_Target
{
	float2 uv = input.uv;
	const float blurSize = BLURSIZE;

	float4 col = float4(0.0f, 0.0f, 0.0f, 0.0f);
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 0], 0) * gaussianWeights[ 0];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 1], 0) * gaussianWeights[ 1];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 2], 0) * gaussianWeights[ 2];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 3], 0) * gaussianWeights[ 3];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 4], 0) * gaussianWeights[ 4];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 5], 0) * gaussianWeights[ 5];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 6], 0) * gaussianWeights[ 6];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv					 , 0) * gaussianWeights[ 7];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 7], 0) * gaussianWeights[ 8];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 8], 0) * gaussianWeights[ 9];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[ 9], 0) * gaussianWeights[10];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[10], 0) * gaussianWeights[11];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[11], 0) * gaussianWeights[12];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[12], 0) * gaussianWeights[13];
	col += InputTexture.SampleLevel(BilinearClampSampler, uv + vblurTexOffset[13], 0) * gaussianWeights[14];
	col /= 14.0f;
	return col;
}

