#include "inc/uniforms.glsl"
#include "inc/utils.glsl"
#line 3

#ifdef VERTEX

layout(location=0) in vec4 in_Position;
layout(location=1) in vec4 in_Color;
// normal
layout(location=3) in vec2 in_UV;
out vec4 ex_Color;
out vec2 ex_UV;

void main()
{
	ex_Color = in_Color;
	ex_UV = in_UV;
	gl_Position = in_Position;
}

#endif

#ifdef FRAGMENT

in vec4 ex_Color;
in vec2 ex_UV;

layout(location=0) out vec4 out_Color;

uniform float p_bloom_add;

uniform sampler2D colorbuffer;
uniform sampler2D depthbuffer;
uniform int vertical;
float bloom_kernul[9] = float[9](0.03, 0.05, 0.10, 0.15, 0.21, 0.15, 0.10, 0.05, 0.03);
void main()
{
	vec2 resolution = textureSize(colorbuffer, 0);
	vec3 col = vec3(0.0);
	float ofs = 0.003;
	
	for (float i=-3.0; i < 4.0; i+=1.0) {
		vec2 dir = vec2(i, 0.0);
		if (vertical == 1) {
			dir.xy = dir.yx;
		} else {
			dir *= 1.0;
		}
		vec2 uv = ex_UV + dir*ofs;
		vec3 sample = texture(colorbuffer, uv).rgb;
		sample *= bloom_kernul[int(i)+3];
		
		
		col += sample * (2.5 + p_bloom_add);
	}
	
	col *= 1.0/9.0;
	col *= 2.0;
	
	out_Color = vec4(col, 1.0); 
} 

#endif