uniform float u_begin;
uniform float u_cmix;
uniform float u_rot;

vec4 rollers(vec2 p)
{
	float c = 0.0;
	vec2 sp;
	float ft = motionblur(2.0);
	
	sp = p - vec2(0.0, 0.0)*1.5;
	c = abs(c - mod(atan(sp.x, sp.y) / (3.14159*2.0) + ft * 0.2, 1.0));
	sp = p - vec2(-0.4, 0.9)*1.5;
	c = abs(c - mod(atan(sp.x, sp.y) / (3.14159*2.0) + ft * -0.1, 1.0));
	sp = p - vec2(-0.5, -0.3)*1.5;
	c = abs(c - mod(atan(sp.x, sp.y) / (3.14159*2.0) + ft * -0.3, 1.0));
	sp = p - vec2(0.7, -0.3)*1.5;
	c = abs(c - mod(atan(sp.x, sp.y) / (3.14159*2.0) + ft * 0.25, 1.0));
	sp = p - vec2(-0.6, 0.7)*1.5;
	c = abs(c - mod(atan(sp.x, sp.y) / (3.14159*2.0) + ft * -0.22, 1.0));
	sp = p - vec2(-0.7, -0.9)*1.5;
	c = abs(c - mod(atan(sp.x, sp.y) / (3.14159*2.0) + ft * 0.31, 1.0));
	sp = p - vec2(0.7, -0.5)*1.5;
	c = abs(c - mod(atan(sp.x, sp.y) / (3.14159*2.0) + ft * -0.3, 1.0));

	return vec4(c);
}

vec2 shuv2;

void john(inout vec4 c, vec2 cp, float zoom)
{
	vec2 p = (shuv2-cp)/vec2(1.0, 1.6);

	p *= zoom;

	p += vec2(0.5);


	if (p.x < 0.0 || p.y < 0.0 || p.x > 1.0 || p.y > 1.0)
		return;

	vec4 tc = texture2D(iChannel1, p);

	c.rgb = mix(c.rgb, tc.rgb, tc.a);
}

//pöllitty!
void rY(inout vec3 p, float a)
{
    float c,s;
	vec3 q=p;
    c = cos(a); s = sin(a);
    p.x = c * q.x + s * q.z;
    p.z = -s * q.x + c * q.z;
}


float ft;

vec4 trac(vec3 uuuv2)
{
	vec2 puv2 = vec2(0.1/abs(uuuv2.z), atan(uuuv2.x, uuuv2.y));
//	vec2 puv2 = shuv2;

//	return vec4(mod(puv2, vec2(1.0)), 0.0, 0.0);

	float modemix = 0.0;

	puv2.x = mix(-3.0/puv2.x, -(puv2.x)-3.0, modemix);
	puv2.x -= pow(ft,1.8) * 2.0;

	float tile = floor(puv2.x / 8.0); 
	float rmul = 3.3 + cos(tile) * 2.0;
	puv2.x = mod(puv2.x*0.5, 4.0);

	vec2 duv2 = vec2(sin(puv2.y), cos(puv2.y)) * puv2.x;

	float rotmul = pow(0.5 + sin(ft * 0.1) * 0.5, 4.0);
	puv2.y += ft;

	vec2 duv2b = vec2(sin(puv2.y), cos(puv2.y)) * puv2.x;

	float idx = 0.0;
	vec2 sp;
	sp = vec2(sin(ft * 1.2314), cos(ft * 1.512));  
	idx += mod(length(sp-duv2) * rmul, 2.0) - 1.0;
	sp = vec2(sin(ft * 1.4314), cos(ft * 1.744));    
	idx += mod(length(sp-duv2) * rmul, 2.0) - 1.0;
	sp = vec2(sin(ft * 1.666), cos(ft * 1.999));    
	idx += mod(length(sp-duv2) * rmul, 2.0) - 1.0;
	
	float m = mod(idx * 0.3, 1.0);

	m = clamp(m, 0.0, 1.0);

	vec4 c1 = vec4(1.0, 0.9, 0.7, 0.0) * 1.5;
	vec4 c2 = vec4(0.4, 0.6, 1.0, 0.0) * 0.0;
	vec4 c3 = vec4(0.6, 0.3, 0.5, 0.0) * 1.4;
	

	vec4 c = mix(mix(c1,c2, m), mix(c2, c3, m), m);

	if (mod(tile, 2.0) < 0.5)
	{
		c = texture2D(iChannel0, duv2b * 0.2 + vec2(0.53,0.8));
	}
	else
	if (mod(tile, 5.0) < 0.5)
	{
		c = rollers(duv2);
	}

	if (mod(tile, 4.0) < 0.5)
		c = vec4(1.2) - c * 1.3;


	 c *= vec4(1.0 - max(0.0, puv2.x - 3.75) * 4.0);
	 c *= vec4(min(1.0, puv2.x*4.0));

	 return c;

}

vec3 pd;

void surfman(inout vec4 c, vec2 cp, float zoom, float angle)
{
	vec2 p = (shuv2-cp)/vec2(2.0, 2.0);

	p *= zoom;

	p += vec2(0.5);

	if (p.x < 0.0 || p.y < 0.0 || p.x > 1.0 || p.y > 1.0)
		return;

	float ft = motionblur(3.0);

	float fr = mod(floor(angle) , 16.0);
//	fr = 12.0;
	vec2 fuv;
	fuv.y = 3.0 - floor(fr / 4.0);
	fuv.x = mod(fr, 4.0);

	vec4 tc = texture2D(iChannel3, (p+fuv) / 4.0);
	c.rgb = mix(c.rgb, tc.rgb, tc.a);


	tc = texture2D(iChannel2, (p+fuv) / 4.0);

	vec3 n = normalize(tc.rgb - vec3(0.5));

	rY(n, (-fr+4.0) * 3.14159265359 / 8.0);

//	n = normalize(n);

	vec3 ld = normalize(vec3(0.0, 0.4, 1.0));
//	rY(n, -fr * 3.14159265359 / 8.0);


	tc.rgb = (n * 0.5) + vec3(0.5);
	float diffuse = pow(clamp(dot(ld, n), 0.0, 1.0), 2.0);
	tc.rgb = vec3(0.7, 0.7, 0.8) * diffuse;

	vec3 rd = reflect(pd, n);

	float reflec = pow(clamp(dot(rd, n), 0.0, 1.0), 37.0);
	tc.rgb += vec3(1.0) * reflec;
	tc.rgb += trac(rd).rgb * diffuse * 0.3;

//	tc.rgb = rd*0.5+vec3(0.5);

	c.rgb = mix(c.rgb, tc.rgb, tc.a);
/* ef: B99EB7F1 03040018
 ZHGIBC */
}

vec3 plasma()
{
	float c;
	c = 0.0;
	c += dot(sin(uv2 * vec2(6.4,9.92) + ft * vec2(4.365, 5.843)), vec2(1.0)) * 0.2;
	c += dot(sin(uv2 * vec2(9.0,14.00) + ft * vec2(-5.999, -6.312)), vec2(1.0)) * 0.2;
	c += dot(sin(uv2 * vec2(12.4,18.92) + ft * vec2(7.111, 5.531)), vec2(1.0)) * 0.2;
	c += dot(sin(uv2 * vec2(16.0,24.00) + ft * vec2(-3.765, -16.543)), vec2(1.0)) * 0.2;
	c += dot(sin(uv2 * vec2(19.0,25.00) + ft * vec2(-6.765, -2.543)), vec2(1.0)) * 0.2;
	return vec3(1.0, 0.8, 0.3) * (0.5 + c) + vec3(0.7);
}

vec4 function()
{
	ft = motionblur(2.0) - u_begin;

	shuv2 = uv2 + sin(vec2(63.5, 54.1) * ft) * u_cmix * 0.06;
	pd = normalize(vec3(shuv2.x, -shuv2.y, -0.3));

	vec4 c = trac(pd);


	 float fugger = pow(length(shuv2)*2.0, 2.0);
	 fugger += sin(atan(shuv2.x, shuv2.y) * 9.0 - ft*2.33) * 0.1;
	vec4 outc = pow(c, vec4(4.0 - fugger*0.2)) * vec4(1.0, 0.8, 0.9, 0.0) * min(2.0, fugger);

	vec2 johnpos = vec2(0.0);
	johnpos += vec2(cos(ft * 2.3), sin(ft*3.2)) * 0.3;
	float fastcomp = 0.5 + sin(ft * 3.61) * 0.5;
	johnpos += vec2(cos(ft * 5.3), sin(ft*7.2)) * 0.1 * fastcomp;
	fastcomp = 0.5 + sin(ft * 2.12) * 0.5;
//	johnpos += vec2(cos(ft * 7.9), sin(ft*13.11)) * 0.2 * fastcomp;

	float extrax = (1.0 - smoothstep(0.0, 3.0, ft)) * 15.0;
 	extrax += (1.0 - smoothstep(2.0, 4.0, ft)) * -3.0;
	johnpos.x += extrax;

	float johnzoom = min(0.0 + ft * 0.1, 1.5);

	float surfang = mod(floor(15.0 + u_rot), 16.0);
	float surfzoom = 1.0;
	vec2 surfpos = vec2(0.6 + sin(ft * 2.324) * 0.1, -0.2 + sin(ft * 3.0) * 0.1);

	if (ft < 3.0)
	{
		surfman(outc, surfpos, surfzoom, surfang);
		john(outc, johnpos, johnzoom);
	}
	else
	{
		john(outc, johnpos, johnzoom);
		surfman(outc, surfpos, surfzoom, surfang);
	}

	outc.rb *= u_cmix+1.0;
	outc.rgb += vec3(max(0.0, u_cmix - 2.0));

	vec4 colli;
	vec2 bossuv = uv2 * vec2(0.8, 1.5) + vec2(0.9, 1.3);
	colli = texture2D(iChannel4, bossuv);
	outc.rgb = mix(outc.rgb, vec3(0.0), colli.g);
	outc.rgb = mix(outc.rgb, plasma(), colli.r);

//	outc.rgb = plasma();

	return outc;
}