
#ifdef vertexcompile

layout (location=0) in vec3 a_position;
layout (location=1) in vec3 a_normal;
layout (location=2) in vec3 a_house_pos;
layout (location=3) in vec3 a_cluster_pos;
layout (location=4) in float house_index;

uniform mat4 world_to_cam;
uniform mat4 cam_to_clip;

uniform float t;


mat4 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
                0.0,                                0.0,                                0.0,                                1.0);
}

out vec3 pos, cam_pos, cam_normal, uv;
flat out vec3 normal;
out vec3 col;
void main() {
	normal = a_normal;
	vec3 rnd_dir = normalize(fract(1000.0*cos(99.9*vec3(a_cluster_pos.x*1.2+a_cluster_pos.y*3.4, a_cluster_pos.z*1.9+a_cluster_pos.y*3.1, a_cluster_pos.x*1.6+a_cluster_pos.z*2.4)))-vec3(.5));
	float time_ = a_cluster_pos.y*.5-(house_index*.3f+2.0*fract(891.2*cos(dot(a_cluster_pos, vec3(103.0, 121.0, 97.1)))));
	float descend_t = exp(10.0+time_-t);
	float broken = mod(house_index*1.5, 4.)/3.0;
	float blow_t = max(.6 * broken, -108+t+time_);
	if(house_index<.0) {
		blow_t  = time_*0.3;
	} else {
		descend_t = max((20-t)*20.0, .0);
	}
	vec3 v_position = vec3(.0, -descend_t, .0)+vec3(.0, 1.0, .0)*blow_t*blow_t*.1+.2*(a_cluster_pos-a_house_pos)*blow_t*vec3(1,.1,1)+a_cluster_pos+clamp((15.0-blow_t)*.1, .0, 1.0)*(rotationMatrix(rnd_dir, blow_t*blow_t*.5/(blow_t+5.0))*vec4(a_position-a_cluster_pos, 1.0)).xyz;
	pos = v_position;
	vec4 cpos = world_to_cam * vec4(v_position,1.0);
	cam_normal = vec4(world_to_cam * vec4(normal,.0)).xyz;
	cam_pos = cpos.xyz;
	gl_Position = cam_to_clip *cpos;

	uv = a_position - a_cluster_pos;
	
	//col = vec3(mod(house_index, 4.0)/4.0, mod(house_index, 6.0)/6.0, 0.0)*vec3(.3, .2, .1)+vec3(.3);
	col = vec3(1.0, mod(house_index, 4.0)/3.0, 0.0)*vec3(0.8, 0.9, 0.8) + vec3(0.1);
	if(house_index>.0)
		col *= max(0.25, min(pos.y, 1.0));
}

#endif

#ifdef fragmentcompile

layout (location=0) out vec4 outcol;
layout (location=1) out vec4 outbloom;

in vec3 pos, cam_pos, cam_normal, uv;
flat in vec3 normal;
in vec3 col;

uniform vec3 lightdir, lightpos;
uniform mat4 world_to_light_clip;
uniform mat4 world_to_cam;
//uniform sampler2D shadowmap;
uniform sampler3D noisetex;
uniform sampler2DShadow shadowmap;
uniform float bloom_treshold;

vec3 lightdir_cam = vec4(world_to_cam*vec4(lightdir, .0)).xyz;

//common

vec4 project(vec3 pos){
	vec4 projected = world_to_light_clip*vec4(pos,1.0);
	
	projected.xyz = vec3(.5)+projected.xyz*.5;
	projected.xy += fract(1000.0*cos(pos.xz*1000.0))*.00025;
	projected.z -= .001;
	return projected;
}

float shadow_factor(vec3 pos) {
	vec4 projected = project(pos);
	return textureProj(shadowmap, vec4(projected), -.01);
}

float smooth_shadow_factor(vec3 pos) {
	float res = .0f;
	for(int i = 0; i<10; ++i) {
		vec4 projected = world_to_light_clip*vec4(pos,1.0);
	
		projected.xyz = vec3(.5)+projected.xyz*.5;
		projected.xy += fract(1000.0*cos(pos.xz*1000.0+vec2(310.9,294.1)*i))*.001;
		projected.z -= .001;
		res += textureProj(shadowmap, vec4(projected), -.01);
	}
	return .1f*res;
}

// vol
mat4 cam_to_world = inverse(world_to_cam);

float vol_light(vec3 cam_pos,vec3 pos) {
	int steps=20;
	float light=0.;
	float last=0.;
	vec3 rdir = pos-cam_pos;
	float rnd = fract(100.0*cos(40.0*dot(pos, vec3(1,1.1,1.3))));
	for(int i=0;i<=steps;i++){
		float a= (i+rnd) /float(steps+1);
		vec3 new_pos= cam_pos*(1-a)+pos*a;
		float scatter=max(0.,2.7-abs(dot(normalize(cam_pos-pos),normalize(new_pos-lightpos))));
		float step=a-last;
		last=0;
		light+=shadow_factor(new_pos)*step*length(cam_pos-pos)*scatter;
	}
	return light;
}


void main() {
	vec3 lightcolor = vec3(0.9, 0.2, 0.1);
	vec3 noisesample = texture(noisetex, uv).rgb;
	vec3 diffuse = max(.0,dot(normal, -lightdir))*vec3(lightcolor+noisesample.r*.2) * col;
	vec3 specular = .2*pow(max(.0, dot(normalize(-lightdir_cam+normalize(-cam_pos)), cam_normal)), 40.0) * vec3(1.0, 0.8, 0.5);

	float fog = max(.0,exp(-.2*length(cam_pos)));
	float shadow = smooth_shadow_factor(pos);
	vec3 ambient = vec3(0.002, 0.005, .015);
	float vol = vol_light((cam_to_world*vec4(0,0,0,1)).xyz,pos)*0.005;

	vec3 fogc = vec3(.35, 0.1, 0.11) * 0.06;
	outcol = vec4(
		mix(
		fogc, 
		ambient + (diffuse + specular)*shadow  + vec3(1.0,1.0,0.5)*vol*0.1, 
		vec3(min(1.0, fog*0.7))), 
	1.0);

	outbloom = min(vec4(1.0), max(vec4(.0), outcol-vec4(bloom_treshold)));
}

#endif
