#ifdef GL_ES
    precision mediump float;
#endif

uniform float time;
uniform vec2 iResolution;
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
uniform mat4 u_projTrans;
vec2 iMouse = vec2(cos(time),sin(time));
mat3 rotY(in float a) {
	return mat3( cos(a), 0.0, sin(a),
				 0.0,    1.0, 0.0,
				-sin(a), 0.0, cos(a)
			    );
}
float smin( float a, float b, float k ) {
    a = pow( a, k ); b = pow( b, k );
    return pow( (a*b)/(a+b), 1.0/k );
}
float length2( vec2 p ) {
	return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
	p = p*p*p; p = p*p;
	return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
	p = p*p; p = p*p; p = p*p;
	return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus82( vec3 p, vec2 t ){
  t.xy+=texture2D(iChannel1, (.4+p.xz)*.01+p.y*0.06).xy*.1+sin(p.x*3.)*.06;
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdTorus( vec3 p, vec2 t ) {
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}
float sdCapsule( vec3 p, vec3 a, vec3 b, float r ) {
    r -= texture2D(iChannel0, p.xy*0.1).r*0.1-texture2D(iChannel0, p.zy*0.1).r*0.1;
    vec3 pa = p - a , ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
float sdHexPrism( vec3 p, vec2 h ) {
    vec3 q = abs(p);
    return max(q.z-h.y,max(q.x+q.y*0.57735,q.y*1.1547)-h.x);
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float udBox( vec3 p, vec3 b ){
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}

float calculateDistance(in vec3 p, out vec3 color) {
    vec3 p2 = vec3(mod(p.x,4.0)-2.0+rand(vec2(floor(p.x/2.))+vec2(0.5)), p.y, mod(p.z,4.0)-2.0+rand(vec2(floor(p.z/2.))+vec2(0.5)));
    color = vec3(0.6) + texture2D(iChannel0, p.xy*0.1).rgb*10.9-texture2D(iChannel0, p.zy*0.1).rgb*10.9;  
    float finalDistance = 10000000.;
    finalDistance = sdCapsule( p2, vec3(0.0,-13.0,0.0), vec3(0.0,10.0,0.0), 0.3 );
    if(p.y<4.0){
    float dist2 = udBox( p-vec3(0.0,-18.0,0.0), vec3(20.0,
                                                    15.0+
                                                    texture2D(iChannel1,p.xz*0.007+vec2(0.5)).r*1.77
                                                    
                                                    ,20.0) );
    if(finalDistance > dist2){
        finalDistance = dist2;
        color = vec3(2.8);
    }

    }
    return finalDistance;
}

float softshadow( in vec3 ro, in vec3 rd, float mint, float k ) {
    float res = 1.0;
    float t = mint;
    for( float i=0.; i<32.; i++ ){
        vec3 C;
        float h = calculateDistance(ro + rd*t, C);
        res = min( res, k*h/t );
        t += h;
    }
    return clamp(res,0.0,1.0);
}

vec3 tracer(vec3 rayStartPosition, vec3 rayDirection) {
                const float epsilon = 0.006;
    vec3 finalColor = vec3(0., 0., 0.);
    vec3 rayPosition = rayStartPosition;
    float stepable = 1.;
    float dist = 0.;
    vec3 normalVector = rayDirection;
    float coff = 0.2;
    float find;
    vec3 lightSource = vec3(0.,13., -0.7);
    
    for(float k=0.; k<2.; k++) {
        find = 0.0;
        for(float i=0.; i<32.; i++) {
            vec3 color;
            stepable = calculateDistance(rayPosition, color);
            dist += stepable;
            rayPosition = rayStartPosition + dist * rayDirection;
            if(length(rayPosition.xz)>8.) {
                vec3 lightDir = (lightSource-rayStartPosition);
                lightDir = (lightDir/length(lightDir));
                float directLight = dot(normalVector, lightDir);
                finalColor+=max(pow(directLight,53.)*vec3(1.7,1.1,.9)*1.8,0.01) + 0.2 * texture2D(iChannel1,2.0*vec2(abs(atan(rayDirection.x,rayDirection.z)/3.141),rayDirection.y)).rgb * 0.7 * min(max(length(rayDirection.xz)*3.0,0.0),1.0);;
                float shadow = (softshadow(rayPosition + normalVector, normalize(lightSource), 0.01, 22.0) * .6);
                
                return finalColor;
            }
            if( abs(stepable) <= epsilon){
                vec3 C;
                normalVector = vec3(	calculateDistance(rayPosition+vec3(epsilon,0,0),C)-calculateDistance(rayPosition+vec3(-epsilon,0,0),C),
                                        calculateDistance(rayPosition+vec3(0,epsilon,0),C)-calculateDistance(rayPosition+vec3(0,-epsilon,0),C),
                                        calculateDistance(rayPosition+vec3(0,0,epsilon),C)-calculateDistance(rayPosition+vec3(0,0,-epsilon),C));
                normalVector = normalize(normalVector);
                
                float shadow = (softshadow(rayPosition + normalVector, normalize(lightSource), 0.01, 22.0) * .6);
                finalColor = mix(finalColor, color * vec3(dot(normalVector, -rayDirection)) * shadow, coff) ;
                //finalColor = mix(finalColor, vec3(0.0), dist/24.0);  /*fog*/
                find = 1.0;
                break;
                
            }
        }
        dist = 0.0;
        rayStartPosition = rayPosition + normalVector*1.1;
        rayPosition = rayStartPosition;
        rayDirection = reflect(rayDirection, normalVector);
        coff *= 0.2;
    }
    return finalColor;
}

void main() {
    vec3 cameraPosition = vec3( 0., 0., -8.);
    cameraPosition*=rotY(3.141*2.*iMouse.x/iResolution.x);
	//cameraPosition*=rotY(time*.7);
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.x / iResolution.y;
    if(length(uv*vec2(0.,aspect))>0.9) discard;
    vec3 direction = normalize(vec3(.5 * uv * vec2(aspect, 1.0), 1. )) ;
    direction.yxz *= rotY(-0.24);
    direction*=rotY(3.141*2.*iMouse.x/iResolution.x);
    //direction *= rotY(time*.7);
    gl_FragColor = vec4(tracer(cameraPosition, direction),1.0);
}