; shebadob
; by gasman / hooy-program
; a 128b intro
; for outline 2015

	org 0xf000

CALC_DELETE		equ 0x02
CALC_MULTIPLY	equ 0x04
CALC_ADDITION	equ 0x0f
CALC_SIN		equ 0x1f
CALC_INT		equ 0x27
CALC_DUPLICATE	equ 0x31
CALC_CONST		equ 0x34
CALC_STK_ZERO	equ 0xa0
CALC_ST_MEM_0	equ 0xc0
CALC_END_CALC	equ	0x38

sine	equ 0xf800

	out (254),a ; a=0 here
; straight line background
	inc a ; a=1
	ld h,0x5b
background_lp
	ld (hl),a
	cp (hl) ; are we in ROM yet?
	dec hl
	jr z,background_lp

; Generate a sine table
	rst 0x28
	db CALC_STK_ZERO
	db CALC_END_CALC

	ld de,sine
sinelp
	push de

	rst 0x28
	db CALC_CONST, 0x2b, 0x49 ;const pi/128 (ish)
	db CALC_ADDITION
	db CALC_DUPLICATE
	db CALC_SIN
	; db CALC_CONST, 0x37, 0x70		; const 113
	db CALC_CONST, 0x36, 0x6f		; const 60
	;db CALC_CONST, 0x36, 0x4f		; const 40ish
	db CALC_MULTIPLY
	db CALC_INT
	db CALC_ST_MEM_0
	db CALC_DELETE
	db CALC_END_CALC
	ld a,(iy+0x5a)			; third byte of calculator memory 0

	pop de
	ld (de),a
	inc e
	jr nz,sinelp

	; enter with a=frame counter (00..7e, increments of 2)
framelp
	halt

	ld bc,512

	add a,b
	and 0x7e
	push af

	ld de,0x5860 ; 0x5880 would be centred on the screen, but we can re-use the 0x60 byte below

	add a,e ; a is now high byte of frame (0x60...0xde)
	ld h,a

	; copy frame at highbyte a to screen
	ld l,c
	ldir

ysine
	ld a,0
	add a,5
	ld (ysine+1),a
	ld d,high sine
	ld e,a

	ld a,(de) ; -64 to 64
	and d ; and 0xf8 => -8 to 8 * 8
	add a,a ; -8 to 8 * 16
	ld l,a
	sbc a,a
	ld h,a  ; -8 to 8 * 16, sign-extended
	add hl,hl ; -8 to 8 * 32
	ld bc,0x6110
	add hl,bc

amplsine
	ld a,(23672) ; FRAMES system variable
	ld e,a
	ld a,(de)
	ld (ampl+1),a

;rotasine
;	ld a,0
;	add a,3
;	ld (rotasine+1),a
;	ld e,a

; shorter way of doing the above, if af' is free:
	ex af, af'
	add a,3
	ld e,a
	ex af,af'

	; weirdify sine
	ld a,(de)
	add a,a
	; now a = rotation value; midpoint of the two values we pick from sine table

	; plot the point for each frame, with rotation value advanced by 4 each time
	ld b,64

	; enter with b=frame counter, a=rota position, hl=image base address, d=high sinetbl
imgloop
	push af ; save rota position
	push hl ; save image base address

	ex de,hl ; get sine table into hl, save image pos in de

ampl
	ld c,30
	sub c
	ld l,a
	add a,c
	add a,c
	ld c,(hl)
	ld l,a
	ld a,(hl)
	add a,c

	ex de,hl ; sine table in de again, image pos in hl

;	add a,a ; equivalent of performing amplitude multiplier at max amplitude;
		; now a = -128 to 128
	sra a
	sra a
	sra a ; now a = -16 to 16
	add a,l
	ld l,a
	inc (hl)
;	inc (hl)  ; evolve faster

	; advance hl to next frame
	pop hl
	inc h
	inc h

	pop af
	; advance to next rota position
	add a,4

	djnz imgloop

	pop af
	jr framelp
