
#version 330

uniform struct Material {
  int flags;
  vec3 diffuse;
  vec3 specular;
  float specularExp;
} u_material;

#define MATERIAL_FLAG_TEXTURED 2

uniform sampler2D s_texture0;

in vec4 v_colour;
in vec2 v_texCoord;

out vec4 fragColor;

void main() {
    if ((u_material.flags & MATERIAL_FLAG_TEXTURED) != 0) {
        vec4 texel = texture(s_texture0, v_texCoord);
        if (texel == vec4(1)) {
            fragColor = vec4(232.0/255.0, 200.0/255.0, 113.0/255.0, 1.0);
        }
        else {
            fragColor = v_colour * 3.0;
        }
    }
    else {
        fragColor = v_colour;
    }
}
