
#include "fw_Globals.fxi"		// shared stuff
#include "fw_States.fxi"		// standard fw_Effect states
//#include "fw_Color.fxi"


float gDrift;
float gGlitch;
float gBgZoom;
float gSpread;
float gImageAspect;
float2 gQuadScale;
float gDepthMess;


//-----------------------------------------------------------------------------
// Textures
//-----------------------------------------------------------------------------

Texture2D gBgTex;
Texture2D gTapetTexture;

SamplerState bgSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = BORDER;
    AddressV = BORDER;
    BorderColor = float4(0.0, 0.0, 0.0, 0.0);
};

SamplerState tapetSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};
//----------------------------------------------------------------------------
// Vertex input stream.
//----------------------------------------------------------------------------
struct VS_INPUT
{
    float4 position_offset : POSITION0;
    uint vertexId : SV_VertexId;
};

struct VS_OUTPUT
{
    float4 position : SV_POSITION;
    float2 uv : TEXCOORD0;
    float2 tapetUv : TEXCOORD1;
    float4 color : TEXCOORD2;
};


//-----------------------------------------------------------------------------
// Shaders
//-----------------------------------------------------------------------------

float gBehindTreshold = 0.0;

VS_OUTPUT
VS(VS_INPUT In)
{
    VS_OUTPUT Out;

    float depth = (float)(In.vertexId/4)/(4*1500.0);

    // Smallen the quads coming out behind.

    float extraScale = 1.0;
    if (depth < gBehindTreshold)
        extraScale *= 0.3;

    float2 uvPos = In.position_offset.xy + extraScale*gQuadScale*In.position_offset.zw;

    Out.uv = (100.0/gBgZoom)*0.5*float2(uvPos.x, -uvPos.y);
    Out.uv.y *= gImageAspect/1.6;
    Out.uv += 0.5;

    float messFactor = (gDepthMess*depth) % 1.0;

    bool doGlitch = messFactor < 0.01*gGlitch;

    Out.color = 0.8 + 0.2*gBgTex.SampleLevel(bgSampler, 0.5 + (100.0/gBgZoom)*(Out.uv - 0.5), /* level */ 0.0);
    if (doGlitch)
        Out.color.rgb = float3(1.2, 1.2, 1.2)*pow(Out.color.grb, float3(0.6, 0.2, 0.4));

    // Darken the quads coming out behind.
    if (depth < gBehindTreshold)
        Out.color.rgb *= 0.25;

    float2 offset = 0.001*(-1.0 + 2.0*float2(19.3331*messFactor % 1.0, 93.33317*messFactor % 1.0));

    Out.tapetUv = 14.553*offset + Out.uv;

    float2 pos = In.position_offset.xy;
    pos +=  gSpread*offset + 
        0.05*((doGlitch ? (1.4 + 500.0*abs(offset.x)) : 0.0) + gDrift)/(1.0 + messFactor)*float2(-1.0, 0.0);

    // Hvis dingsene detter ut p venstre siden, s la dem gjenopst p hyre siden!  Starfield!
    pos.x *= 0.65;
    pos.x = 1.0 - (((-pos.x+1.0)*0.5) % 1.0)*2.0;
    pos.x /= 0.65;

    Out.position = float4(
        pos + extraScale*gQuadScale*In.position_offset.zw,
        messFactor,
        1.0);

    return Out;
}


float4 
PS(VS_OUTPUT In) : SV_TARGET0
{
//    return float4(1.0, 0.4, 0.3, 1.0);
    float4 raff = 0.1 + 0.4*gTapetTexture.Sample(tapetSampler, In.tapetUv);
    float4 color = gBgTex.Sample(bgSampler, In.uv);
//    if (color.a < 0.5)
//        discard;

    //    float luma = dot(float3(0.3, 0.59, 0.11), color);
    //    return float4((0.8 + 0.2*luma)*In.color.rgb, 1.0);
//    return float4(gFinalColorScale*raff.rgb*In.color.rgb*color.rgb, 0.7*color.a);
//  return float4(color.rgb, 0.7*color.a);
    return float4(raff.rgb*In.color.rgb*color.rgb, 0.7*color.a);
}


technique10 Quads
{
    pass P0
    {
//        SetBlendState(Blending_None, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetBlendState(Blending_Alpha, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Disable, /*ref value*/ 0);
        SetRasterizerState(Culling_None);

        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS()));
    }
}

