/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.query;

import com.sun.jna.Library;
import com.sun.jna.Pointer;
import java.util.AbstractList;
import java.util.List;
import org.gstreamer.Format;
import org.gstreamer.Query;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatsQuery
extends Query {
    private static final API gst = GstNative.load(API.class);

    public FormatsQuery() {
        this(FormatsQuery.initializer(gst.gst_query_new_formats()));
    }

    public FormatsQuery(NativeObject.Initializer init) {
        super(init);
    }

    public void setFormats(Format ... formats) {
        gst.gst_query_set_formats(this, formats.length, formats);
    }

    public int getCount() {
        int[] count = new int[]{0};
        gst.gst_query_parse_formats_length(this, count);
        return count[0];
    }

    public Format getFormat(int index) {
        int[] fmt = new int[]{0};
        gst.gst_query_parse_formats_nth(this, index, fmt);
        return Format.valueOf(fmt[0]);
    }

    public List<Format> getFormats() {
        final int count = this.getCount();
        return new AbstractList<Format>(){

            @Override
            public Format get(int index) {
                return FormatsQuery.this.getFormat(index);
            }

            @Override
            public int size() {
                return count;
            }
        };
    }

    private static interface API
    extends Library {
        public Pointer gst_query_new_formats();

        public void gst_query_set_formats(Query var1, int var2, Format ... var3);

        public void gst_query_set_formatsv(Query var1, int var2, int[] var3);

        public void gst_query_parse_formats_length(Query var1, int[] var2);

        public void gst_query_parse_formats_nth(Query var1, int var2, int[] var3);
    }
}

