/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.media;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.gstreamer.media.MediaPlayer;
import org.gstreamer.media.event.EndOfMediaEvent;
import org.gstreamer.media.event.MediaListener;
import org.gstreamer.media.event.PauseEvent;
import org.gstreamer.media.event.StartEvent;
import org.gstreamer.media.event.StopEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMediaPlayer
implements MediaPlayer {
    private final Map<MediaListener, MediaListener> mediaListeners = new HashMap<MediaListener, MediaListener>();
    private final List<MediaListener> listeners = new CopyOnWriteArrayList<MediaListener>();
    protected final Executor eventExecutor;
    protected final Queue<URI> playList = new ConcurrentLinkedQueue<URI>();

    protected AbstractMediaPlayer(Executor eventExecutor) {
        this.eventExecutor = eventExecutor;
    }

    protected void fireEndOfMediaEvent(EndOfMediaEvent ev) {
        for (MediaListener l : this.getMediaListeners()) {
            l.endOfMedia(ev);
        }
    }

    protected void fireStartEvent(StartEvent ev) {
        for (MediaListener l : this.getMediaListeners()) {
            l.start(ev);
        }
    }

    protected void fireStopEvent(StopEvent ev) {
        for (MediaListener l : this.getMediaListeners()) {
            l.stop(ev);
        }
    }

    protected void firePauseEvent(PauseEvent ev) {
        for (MediaListener l : this.getMediaListeners()) {
            l.pause(ev);
        }
    }

    @Override
    public void enqueue(URI uri) {
        this.playList.add(uri);
    }

    @Override
    public void enqueue(Collection<URI> playlist) {
        this.playList.addAll(playlist);
    }

    @Override
    public void setPlaylist(Collection<URI> playlist) {
        this.playList.clear();
        this.playList.addAll(playlist);
    }

    @Override
    public void remove(URI uri) {
        this.playList.remove(uri);
    }

    @Override
    public synchronized void addMediaListener(MediaListener listener) {
        MediaListener proxy = AbstractMediaPlayer.wrapListener(MediaListener.class, listener, this.eventExecutor);
        this.mediaListeners.put(listener, proxy);
        this.listeners.add(proxy);
    }

    @Override
    public synchronized void removeMediaListener(MediaListener listener) {
        MediaListener proxy = this.mediaListeners.remove(listener);
        this.listeners.remove(proxy);
    }

    protected List<MediaListener> getMediaListeners() {
        return this.listeners;
    }

    private static <T> T wrapListener(Class<T> interfaceClass, T instance, Executor executor) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new ExecutorInvocationProxy(instance, executor)));
    }

    private static class ExecutorInvocationProxy
    implements InvocationHandler {
        private final Executor executor;
        private final Object object;

        public ExecutorInvocationProxy(Object object, Executor executor) {
            this.object = object;
            this.executor = executor;
        }

        public Object invoke(Object self, final Method method, final Object[] argArray) throws Throwable {
            if (method.getName().equals("hashCode")) {
                return this.object.hashCode();
            }
            this.executor.execute(new Runnable(){

                public void run() {
                    try {
                        method.invoke(ExecutorInvocationProxy.this.object, argArray);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
    }
}

