/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.BasicStroke;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.data.XML;

public class PGraphicsJava2D
extends PGraphics {
    BufferStrategy strategy;
    BufferedImage bimage;
    VolatileImage vimage;
    Canvas canvas;
    boolean useCanvas = false;
    boolean useOffscreen = false;
    public Graphics2D g2;
    protected BufferedImage offscreen;
    Composite defaultComposite;
    GeneralPath gpath;
    GeneralPath auxPath;
    boolean openContour;
    boolean breakShape;
    float[] curveCoordX;
    float[] curveCoordY;
    float[] curveDrawX;
    float[] curveDrawY;
    int transformCount;
    AffineTransform[] transformStack = new AffineTransform[32];
    double[] transform = new double[6];
    Line2D.Float line = new Line2D.Float();
    Ellipse2D.Float ellipse = new Ellipse2D.Float();
    Rectangle2D.Float rect = new Rectangle2D.Float();
    Arc2D.Float arc = new Arc2D.Float();
    protected Color tintColorObject;
    protected Color fillColorObject;
    public boolean fillGradient;
    public Paint fillGradientObject;
    protected Color strokeColorObject;
    public boolean strokeGradient;
    public Paint strokeGradientObject;
    int[] clearPixels;
    static int[] getset = new int[1];
    static final String MASK_WARNING = "mask() cannot be used on the main drawing surface";

    @Override
    public void setSize(int iwidth, int iheight) {
        this.width = iwidth;
        this.height = iheight;
        this.allocate();
        this.reapplySettings();
    }

    @Override
    protected void allocate() {
        if (this.primarySurface) {
            if (this.useCanvas) {
                if (this.canvas != null) {
                    this.parent.removeListeners(this.canvas);
                    this.parent.remove(this.canvas);
                }
                this.canvas = new Canvas();
                this.canvas.setIgnoreRepaint(true);
                this.parent.add(this.canvas);
                if (this.canvas.getWidth() != this.width || this.canvas.getHeight() != this.height) {
                    PApplet.debug("PGraphicsJava2D comp size being set to " + this.width + "x" + this.height);
                    this.canvas.setSize(this.width, this.height);
                } else {
                    PApplet.debug("PGraphicsJava2D comp size already " + this.width + "x" + this.height);
                }
                this.parent.addListeners(this.canvas);
            } else {
                this.parent.updateListeners(this.parent);
                if (this.useOffscreen) {
                    this.image = new BufferedImage(this.width, this.height, 1);
                    this.offscreen = new BufferedImage(this.width, this.height, 2);
                    this.g2 = (Graphics2D)this.offscreen.getGraphics();
                } else {
                    GraphicsConfiguration gc = this.parent.getGraphicsConfiguration();
                    if (gc == null) {
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
                    }
                    this.image = gc.createCompatibleImage(this.width, this.height);
                    this.g2 = (Graphics2D)this.image.getGraphics();
                }
            }
        } else {
            this.image = new BufferedImage(this.width, this.height, 2);
            this.g2 = (Graphics2D)this.image.getGraphics();
        }
    }

    @Override
    public boolean canDraw() {
        return true;
    }

    @Override
    public void requestDraw() {
        this.parent.handleDraw();
    }

    @Override
    public void beginDraw() {
        GraphicsConfiguration gc;
        if (this.primarySurface && !this.useOffscreen && this.image == null) {
            gc = this.parent.getGraphicsConfiguration();
            this.image = gc.createCompatibleImage(this.width, this.height);
            PApplet.debug("created new image, type is " + this.image);
            this.g2 = (Graphics2D)this.image.getGraphics();
            this.reapplySettings = true;
        }
        if (this.useCanvas && this.primarySurface) {
            if (this.parent.frameCount == 0) {
                this.canvas.createBufferStrategy(2);
                this.strategy = this.canvas.getBufferStrategy();
                PApplet.debug("PGraphicsJava2D.beginDraw() strategy is " + this.strategy);
                BufferCapabilities caps = this.strategy.getCapabilities();
                caps = this.strategy.getCapabilities();
                PApplet.debug("PGraphicsJava2D.beginDraw() caps are  flipping: " + caps.isPageFlipping() + " front/back accel: " + caps.getFrontBufferCapabilities().isAccelerated() + " " + "/" + caps.getBackBufferCapabilities().isAccelerated());
            }
            gc = this.canvas.getGraphicsConfiguration();
            if (this.bimage == null || this.bimage.getWidth() != this.width || this.bimage.getHeight() != this.height) {
                PApplet.debug("PGraphicsJava2D creating new image");
                this.bimage = gc.createCompatibleImage(this.width, this.height);
                this.g2 = this.bimage.createGraphics();
                this.defaultComposite = this.g2.getComposite();
                this.reapplySettings = true;
            }
        }
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDraw() {
        if (this.primarySurface) {
            if (this.useCanvas) {
                this.redraw();
            } else if (this.useOffscreen) {
                Image image = this.image;
                synchronized (image) {
                    this.image.getGraphics().drawImage(this.offscreen, 0, 0, null);
                }
            }
        } else {
            this.loadPixels();
        }
        this.setModified();
    }

    private void redraw() {
        do {
            PApplet.debug("PGraphicsJava2D.redraw() top of outer do { } block");
            do {
                PApplet.debug("PGraphicsJava2D.redraw() top of inner do { } block");
                PApplet.debug("strategy is " + this.strategy);
                Graphics bsg = this.strategy.getDrawGraphics();
                if (this.vimage != null) {
                    bsg.drawImage(this.vimage, 0, 0, null);
                } else {
                    bsg.drawImage(this.bimage, 0, 0, null);
                }
                bsg.dispose();
            } while (this.strategy.contentsRestored());
            PApplet.debug("PGraphicsJava2D.redraw() showing strategy");
            this.strategy.show();
        } while (this.strategy.contentsLost());
        PApplet.debug("PGraphicsJava2D.redraw() out of do { } block");
    }

    @Override
    protected void defaultSettings() {
        if (!this.useCanvas) {
            this.defaultComposite = this.g2.getComposite();
        }
        super.defaultSettings();
    }

    @Override
    public void hint(int which) {
        super.hint(which);
        if (which == 9) {
            this.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        } else if (which == -9) {
            this.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        }
    }

    @Override
    public PShape createShape() {
        return this.createShape(3);
    }

    @Override
    public PShape createShape(int type) {
        return PGraphicsJava2D.createShapeImpl(this, type);
    }

    @Override
    public PShape createShape(int kind, float ... p) {
        return PGraphicsJava2D.createShapeImpl(this, kind, p);
    }

    protected static PShape createShapeImpl(PGraphicsJava2D pg, int type) {
        PShape shape = null;
        if (type == 0) {
            shape = new PShape(pg, 0);
        } else if (type == 2) {
            shape = new PShape(pg, 2);
        } else if (type == 3) {
            shape = new PShape(pg, 3);
        }
        shape.set3D(false);
        return shape;
    }

    protected static PShape createShapeImpl(PGraphicsJava2D pg, int kind, float ... p) {
        PShape shape = null;
        int len = p.length;
        if (kind == 2) {
            if (len != 2) {
                PGraphicsJava2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape(pg, 1);
            shape.setKind(2);
        } else if (kind == 4) {
            if (len != 4) {
                PGraphicsJava2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape(pg, 1);
            shape.setKind(4);
        } else if (kind == 8) {
            if (len != 6) {
                PGraphicsJava2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape(pg, 1);
            shape.setKind(8);
        } else if (kind == 16) {
            if (len != 8) {
                PGraphicsJava2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape(pg, 1);
            shape.setKind(16);
        } else if (kind == 30) {
            if (len != 4 && len != 5 && len != 8 && len != 9) {
                PGraphicsJava2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape(pg, 1);
            shape.setKind(30);
        } else if (kind == 31) {
            if (len != 4 && len != 5) {
                PGraphicsJava2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape(pg, 1);
            shape.setKind(31);
        } else if (kind == 32) {
            if (len != 6 && len != 7) {
                PGraphicsJava2D.showWarning("Wrong number of parameters");
                return null;
            }
            shape = new PShape(pg, 1);
            shape.setKind(32);
        } else if (kind == 41) {
            PGraphicsJava2D.showWarning("Primitive not supported in 2D");
        } else if (kind == 40) {
            PGraphicsJava2D.showWarning("Primitive not supported in 2D");
        } else {
            PGraphicsJava2D.showWarning("Unrecognized primitive type");
        }
        if (shape != null) {
            shape.setParams(p);
        }
        shape.set3D(false);
        return shape;
    }

    @Override
    public void beginShape(int kind) {
        this.shape = kind;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
        this.gpath = null;
        this.auxPath = null;
    }

    @Override
    public void texture(PImage image) {
        PGraphicsJava2D.showMethodWarning("texture");
    }

    @Override
    public void vertex(float x, float y) {
        this.curveVertexCount = 0;
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][37];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
        }
        this.vertices[this.vertexCount][0] = x;
        this.vertices[this.vertexCount][1] = y;
        ++this.vertexCount;
        switch (this.shape) {
            case 3: {
                this.point(x, y);
                break;
            }
            case 5: {
                if (this.vertexCount % 2 != 0) break;
                this.line(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 9: {
                if (this.vertexCount % 3 != 0) break;
                this.triangle(this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 10: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], this.vertices[this.vertexCount - 1][0], this.vertices[this.vertexCount - 1][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                break;
            }
            case 11: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[0][0], this.vertices[0][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 16: 
            case 17: {
                if (this.vertexCount % 4 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                break;
            }
            case 18: {
                if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                break;
            }
            case 20: {
                if (this.gpath == null) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(x, y);
                    break;
                }
                if (this.breakShape) {
                    this.gpath.moveTo(x, y);
                    this.breakShape = false;
                    break;
                }
                this.gpath.lineTo(x, y);
            }
        }
    }

    @Override
    public void vertex(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void vertex(float[] v) {
        this.vertex(v[0], v[1]);
    }

    @Override
    public void vertex(float x, float y, float u, float v) {
        PGraphicsJava2D.showVariationWarning("vertex(x, y, u, v)");
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        PGraphicsJava2D.showDepthWarningXYZ("vertex");
    }

    @Override
    public void beginContour() {
        if (this.openContour) {
            PGraphics.showWarning("Already called beginContour()");
            return;
        }
        GeneralPath contourPath = this.auxPath;
        this.auxPath = this.gpath;
        this.gpath = contourPath;
        if (contourPath != null) {
            this.breakShape = true;
        }
        this.openContour = true;
    }

    @Override
    public void endContour() {
        if (!this.openContour) {
            PGraphics.showWarning("Need to call beginContour() first");
            return;
        }
        if (this.gpath != null) {
            this.gpath.closePath();
        }
        GeneralPath contourPath = this.gpath;
        this.gpath = this.auxPath;
        this.auxPath = contourPath;
        this.openContour = false;
    }

    @Override
    public void endShape(int mode) {
        if (this.openContour) {
            this.endContour();
            PGraphics.showWarning("Missing endContour() before endShape()");
        }
        if (this.gpath != null && this.shape == 20) {
            if (mode == 2) {
                this.gpath.closePath();
            }
            if (this.auxPath != null) {
                this.gpath.append(this.auxPath, false);
            }
            this.drawShape(this.gpath);
        }
        this.shape = 0;
    }

    @Override
    protected void clipImpl(float x1, float y1, float x2, float y2) {
        this.g2.setClip(new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1));
    }

    @Override
    public void noClip() {
        this.g2.setClip(null);
    }

    @Override
    protected void blendModeImpl() {
        if (this.blendMode == 1) {
            this.g2.setComposite(this.defaultComposite);
        } else {
            this.g2.setComposite(new Composite(){

                @Override
                public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
                    return new BlendingContext(PGraphicsJava2D.this.blendMode);
                }
            });
        }
    }

    @Override
    public void bezierVertex(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.bezierVertexCheck();
        this.gpath.curveTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphicsJava2D.showDepthWarningXYZ("bezierVertex");
    }

    @Override
    public void quadraticVertex(float ctrlX, float ctrlY, float endX, float endY) {
        this.bezierVertexCheck();
        Point2D cur = this.gpath.getCurrentPoint();
        float x1 = (float)cur.getX();
        float y1 = (float)cur.getY();
        this.bezierVertex(x1 + (ctrlX - x1) * 2.0f / 3.0f, y1 + (ctrlY - y1) * 2.0f / 3.0f, endX + (ctrlX - endX) * 2.0f / 3.0f, endY + (ctrlY - endY) * 2.0f / 3.0f, endX, endY);
    }

    @Override
    public void quadraticVertex(float x2, float y2, float z2, float x4, float y4, float z4) {
        PGraphicsJava2D.showDepthWarningXYZ("quadVertex");
    }

    @Override
    protected void curveVertexCheck() {
        super.curveVertexCheck();
        if (this.curveCoordX == null) {
            this.curveCoordX = new float[4];
            this.curveCoordY = new float[4];
            this.curveDrawX = new float[4];
            this.curveDrawY = new float[4];
        }
    }

    @Override
    protected void curveVertexSegment(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.curveCoordX[0] = x1;
        this.curveCoordY[0] = y1;
        this.curveCoordX[1] = x2;
        this.curveCoordY[1] = y2;
        this.curveCoordX[2] = x3;
        this.curveCoordY[2] = y3;
        this.curveCoordX[3] = x4;
        this.curveCoordY[3] = y4;
        this.curveToBezierMatrix.mult(this.curveCoordX, this.curveDrawX);
        this.curveToBezierMatrix.mult(this.curveCoordY, this.curveDrawY);
        if (this.gpath == null) {
            this.gpath = new GeneralPath();
            this.gpath.moveTo(this.curveDrawX[0], this.curveDrawY[0]);
        }
        this.gpath.curveTo(this.curveDrawX[1], this.curveDrawY[1], this.curveDrawX[2], this.curveDrawY[2], this.curveDrawX[3], this.curveDrawY[3]);
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("curveVertex");
    }

    @Override
    public void point(float x, float y) {
        if (this.stroke) {
            this.line(x, y, x + 1.0E-4f, y + 1.0E-4f);
        }
    }

    @Override
    public void line(float x1, float y1, float x2, float y2) {
        this.line.setLine(x1, y1, x2, y2);
        this.strokeShape(this.line);
    }

    @Override
    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.gpath = new GeneralPath();
        this.gpath.moveTo(x1, y1);
        this.gpath.lineTo(x2, y2);
        this.gpath.lineTo(x3, y3);
        this.gpath.closePath();
        this.drawShape(this.gpath);
    }

    @Override
    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x1, y1);
        gp.lineTo(x2, y2);
        gp.lineTo(x3, y3);
        gp.lineTo(x4, y4);
        gp.closePath();
        this.drawShape(gp);
    }

    @Override
    protected void rectImpl(float x1, float y1, float x2, float y2) {
        this.rect.setFrame(x1, y1, x2 - x1, y2 - y1);
        this.drawShape(this.rect);
    }

    @Override
    protected void ellipseImpl(float x, float y, float w, float h) {
        this.ellipse.setFrame(x, y, w, h);
        this.drawShape(this.ellipse);
    }

    @Override
    protected void arcImpl(float x, float y, float w, float h, float start, float stop, int mode) {
        start = -start * 57.295776f;
        stop = -stop * 57.295776f;
        float sweep = stop - start;
        int fillMode = 2;
        int strokeMode = 0;
        if (mode == 1) {
            fillMode = 0;
        } else if (mode == 3) {
            strokeMode = 2;
        } else if (mode == 2) {
            fillMode = 1;
            strokeMode = 1;
        }
        if (this.fill) {
            this.arc.setArc(x, y, w, h, start, sweep, fillMode);
            this.fillShape(this.arc);
        }
        if (this.stroke) {
            this.arc.setArc(x, y, w, h, start, sweep, strokeMode);
            this.strokeShape(this.arc);
        }
    }

    protected void fillShape(Shape s) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(s);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(s);
        }
    }

    protected void strokeShape(Shape s) {
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(s);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(s);
        }
    }

    protected void drawShape(Shape s) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(s);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(s);
        }
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(s);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(s);
        }
    }

    @Override
    public void box(float w, float h, float d) {
        PGraphicsJava2D.showMethodWarning("box");
    }

    @Override
    public void sphere(float r) {
        PGraphicsJava2D.showMethodWarning("sphere");
    }

    @Override
    public void bezierDetail(int detail) {
    }

    @Override
    public void curveDetail(int detail) {
    }

    @Override
    public void smooth() {
        this.smooth = true;
        if (this.quality == 0) {
            this.quality = 4;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.quality == 4 ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    @Override
    public void smooth(int antialias) {
        this.quality = antialias;
        if (antialias == 0) {
            this.noSmooth();
        } else {
            this.smooth();
        }
    }

    @Override
    public void noSmooth() {
        this.smooth = false;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    @Override
    protected void imageImpl(PImage who, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        if (who.width <= 0 || who.height <= 0) {
            return;
        }
        ImageCache cash = (ImageCache)this.getCache(who);
        if (cash != null && (who.width != cash.image.getWidth() || who.height != cash.image.getHeight())) {
            cash = null;
        }
        if (cash == null) {
            cash = new ImageCache();
            this.setCache(who, cash);
            who.updatePixels();
            who.modified = true;
        }
        if (this.tint && !cash.tinted || this.tint && cash.tintedColor != this.tintColor || !this.tint && cash.tinted) {
            who.updatePixels();
        }
        if (who.modified) {
            if (who.pixels == null) {
                who.pixels = new int[who.width * who.height];
            }
            cash.update(who, this.tint, this.tintColor);
            who.modified = false;
        }
        this.g2.drawImage(((ImageCache)this.getCache((PImage)who)).image, (int)x1, (int)y1, (int)x2, (int)y2, u1, v1, u2, v2, null);
    }

    @Override
    public PShape loadShape(String filename) {
        return this.loadShape(filename, null);
    }

    @Override
    public PShape loadShape(String filename, String options) {
        String extension = PApplet.getExtension(filename);
        PShapeSVG svg = null;
        if (extension.equals("svg")) {
            svg = new PShapeSVG(this.parent.loadXML(filename));
        } else if (extension.equals("svgz")) {
            try {
                GZIPInputStream input = new GZIPInputStream(this.parent.createInput(filename));
                XML xml = new XML(PApplet.createReader(input), options);
                svg = new PShapeSVG(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PGraphics.showWarning("Unsupported format: " + filename);
        }
        return svg;
    }

    @Override
    public float textAscent() {
        Font font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent");
        }
        if ((font = (Font)this.textFont.getNative()) != null) {
            FontMetrics metrics = this.parent.getFontMetrics(font);
            return metrics.getAscent();
        }
        return super.textAscent();
    }

    @Override
    public float textDescent() {
        Font font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textDescent");
        }
        if ((font = (Font)this.textFont.getNative()) != null) {
            FontMetrics metrics = this.parent.getFontMetrics(font);
            return metrics.getDescent();
        }
        return super.textDescent();
    }

    @Override
    protected boolean textModeCheck(int mode) {
        return mode == 4;
    }

    @Override
    public void textSize(float size) {
        Font font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textSize", size);
        }
        if ((font = (Font)this.textFont.getNative()) != null) {
            HashMap<TextAttribute, Number> map = new HashMap<TextAttribute, Number>();
            map.put(TextAttribute.SIZE, Float.valueOf(size));
            map.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
            font = font.deriveFont(map);
            this.g2.setFont(font);
            this.textFont.setNative(font);
        }
        super.textSize(size);
    }

    @Override
    protected float textWidthImpl(char[] buffer, int start, int stop) {
        Font font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textWidth");
        }
        if ((font = (Font)this.textFont.getNative()) != null) {
            int length = stop - start;
            FontMetrics metrics = this.g2.getFontMetrics(font);
            return metrics.charsWidth(buffer, start, length);
        }
        return super.textWidthImpl(buffer, start, stop);
    }

    @Override
    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        Font font = (Font)this.textFont.getNative();
        if (font != null) {
            Object antialias = this.g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (antialias == null) {
                antialias = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
            }
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.textFont.smooth ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.g2.setColor(this.fillColorObject);
            int length = stop - start;
            if (length != 0) {
                this.g2.drawChars(buffer, start, length, (int)(x + 0.5f), (int)(y + 0.5f));
            }
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias);
        } else {
            super.textLineImpl(buffer, start, stop, x, y);
        }
    }

    @Override
    public void pushMatrix() {
        if (this.transformCount == this.transformStack.length) {
            throw new RuntimeException("pushMatrix() cannot use push more than " + this.transformStack.length + " times");
        }
        this.transformStack[this.transformCount] = this.g2.getTransform();
        ++this.transformCount;
    }

    @Override
    public void popMatrix() {
        if (this.transformCount == 0) {
            throw new RuntimeException("missing a pushMatrix() to go with that popMatrix()");
        }
        --this.transformCount;
        this.g2.setTransform(this.transformStack[this.transformCount]);
    }

    @Override
    public void translate(float tx, float ty) {
        this.g2.translate(tx, ty);
    }

    @Override
    public void rotate(float angle) {
        this.g2.rotate(angle);
    }

    @Override
    public void rotateX(float angle) {
        PGraphicsJava2D.showDepthWarning("rotateX");
    }

    @Override
    public void rotateY(float angle) {
        PGraphicsJava2D.showDepthWarning("rotateY");
    }

    @Override
    public void rotateZ(float angle) {
        PGraphicsJava2D.showDepthWarning("rotateZ");
    }

    @Override
    public void rotate(float angle, float vx, float vy, float vz) {
        PGraphicsJava2D.showVariationWarning("rotate");
    }

    @Override
    public void scale(float s) {
        this.g2.scale(s, s);
    }

    @Override
    public void scale(float sx, float sy) {
        this.g2.scale(sx, sy);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        PGraphicsJava2D.showDepthWarningXYZ("scale");
    }

    @Override
    public void shearX(float angle) {
        this.g2.shear(Math.tan(angle), 0.0);
    }

    @Override
    public void shearY(float angle) {
        this.g2.shear(0.0, Math.tan(angle));
    }

    @Override
    public void resetMatrix() {
        this.g2.setTransform(new AffineTransform());
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.g2.transform(new AffineTransform(n00, n10, n01, n11, n02, n12));
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphicsJava2D.showVariationWarning("applyMatrix");
    }

    @Override
    public PMatrix getMatrix() {
        return this.getMatrix((PMatrix2D)null);
    }

    @Override
    public PMatrix2D getMatrix(PMatrix2D target) {
        if (target == null) {
            target = new PMatrix2D();
        }
        this.g2.getTransform().getMatrix(this.transform);
        target.set((float)this.transform[0], (float)this.transform[2], (float)this.transform[4], (float)this.transform[1], (float)this.transform[3], (float)this.transform[5]);
        return target;
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D target) {
        PGraphicsJava2D.showVariationWarning("getMatrix");
        return target;
    }

    @Override
    public void setMatrix(PMatrix2D source) {
        this.g2.setTransform(new AffineTransform(source.m00, source.m10, source.m01, source.m11, source.m02, source.m12));
    }

    @Override
    public void setMatrix(PMatrix3D source) {
        PGraphicsJava2D.showVariationWarning("setMatrix");
    }

    @Override
    public void printMatrix() {
        this.getMatrix((PMatrix2D)null).print();
    }

    @Override
    public float screenX(float x, float y) {
        this.g2.getTransform().getMatrix(this.transform);
        return (float)this.transform[0] * x + (float)this.transform[2] * y + (float)this.transform[4];
    }

    @Override
    public float screenY(float x, float y) {
        this.g2.getTransform().getMatrix(this.transform);
        return (float)this.transform[1] * x + (float)this.transform[3] * y + (float)this.transform[5];
    }

    @Override
    public float screenX(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("screenX");
        return 0.0f;
    }

    @Override
    public float screenY(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("screenY");
        return 0.0f;
    }

    @Override
    public float screenZ(float x, float y, float z) {
        PGraphicsJava2D.showDepthWarningXYZ("screenZ");
        return 0.0f;
    }

    @Override
    public void strokeCap(int cap) {
        super.strokeCap(cap);
        this.strokeImpl();
    }

    @Override
    public void strokeJoin(int join) {
        super.strokeJoin(join);
        this.strokeImpl();
    }

    @Override
    public void strokeWeight(float weight) {
        super.strokeWeight(weight);
        this.strokeImpl();
    }

    protected void strokeImpl() {
        int cap = 0;
        if (this.strokeCap == 2) {
            cap = 1;
        } else if (this.strokeCap == 4) {
            cap = 2;
        }
        int join = 2;
        if (this.strokeJoin == 8) {
            join = 0;
        } else if (this.strokeJoin == 2) {
            join = 1;
        }
        this.g2.setStroke(new BasicStroke(this.strokeWeight, cap, join));
    }

    @Override
    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.strokeColorObject = new Color(this.strokeColor, true);
        this.strokeGradient = false;
    }

    @Override
    protected void tintFromCalc() {
        super.tintFromCalc();
        this.tintColorObject = new Color(this.tintColor, true);
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        this.fillColorObject = new Color(this.fillColor, true);
        this.fillGradient = false;
    }

    protected void clearPixels(int color) {
        int imageWidth = this.image.getWidth(null);
        int imageHeight = this.image.getHeight(null);
        WritableRaster raster = this.getRaster();
        if (this.clearPixels == null || this.clearPixels.length < imageWidth) {
            this.clearPixels = new int[imageWidth];
        }
        Arrays.fill(this.clearPixels, 0, imageWidth, this.backgroundColor);
        int i = 0;
        while (i < imageHeight) {
            raster.setDataElements(0, i, imageWidth, 1, this.clearPixels);
            ++i;
        }
    }

    @Override
    public void backgroundImpl() {
        if (this.backgroundAlpha) {
            this.clearPixels(this.backgroundColor);
        } else {
            Color bgColor = new Color(this.backgroundColor);
            Composite oldComposite = this.g2.getComposite();
            this.g2.setComposite(this.defaultComposite);
            this.pushMatrix();
            this.resetMatrix();
            this.g2.setColor(bgColor);
            if (this.image != null) {
                this.g2.fillRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
            } else {
                this.g2.fillRect(0, 0, this.width, this.height);
            }
            this.popMatrix();
            this.g2.setComposite(oldComposite);
        }
    }

    @Override
    public void beginRaw(PGraphics recorderRaw) {
        PGraphicsJava2D.showMethodWarning("beginRaw");
    }

    @Override
    public void endRaw() {
        PGraphicsJava2D.showMethodWarning("endRaw");
    }

    protected WritableRaster getRaster() {
        Raster raster = null;
        if (this.primarySurface) {
            if (this.useOffscreen) {
                raster = this.offscreen.getRaster();
            } else if (this.image instanceof VolatileImage) {
                raster = ((VolatileImage)this.image).getSnapshot().getRaster();
            }
        }
        if (raster == null) {
            raster = ((BufferedImage)this.image).getRaster();
        }
        if (raster.getTransferType() != 3) {
            System.err.println("See https://github.com/processing/processing/issues/2010");
            throw new RuntimeException("Pixel operations are not supported on this device.");
        }
        return raster;
    }

    @Override
    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        WritableRaster raster = this.getRaster();
        raster.getDataElements(0, 0, this.width, this.height, this.pixels);
        if (raster.getNumBands() == 3) {
            int i = 0;
            while (i < this.pixels.length) {
                this.pixels[i] = 0xFF000000 | this.pixels[i];
                ++i;
            }
        }
    }

    @Override
    public void updatePixels(int x, int y, int c, int d) {
        if (x != 0 || y != 0 || c != this.width || d != this.height) {
            PGraphicsJava2D.showVariationWarning("updatePixels(x, y, w, h)");
        }
        if (this.pixels != null) {
            this.getRaster().setDataElements(0, 0, this.width, this.height, this.pixels);
        }
        this.modified = true;
    }

    @Override
    public int get(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        WritableRaster raster = this.getRaster();
        raster.getDataElements(x, y, getset);
        if (raster.getNumBands() == 3) {
            return getset[0] | 0xFF000000;
        }
        return getset[0];
    }

    @Override
    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    @Override
    protected void getImpl(int sourceX, int sourceY, int sourceWidth, int sourceHeight, PImage target, int targetX, int targetY) {
        WritableRaster raster = this.getRaster();
        if (sourceWidth == target.width && sourceHeight == target.height) {
            raster.getDataElements(sourceX, sourceY, sourceWidth, sourceHeight, target.pixels);
            if (raster.getNumBands() == 3) {
                target.filter(14);
            }
        } else {
            int[] temp = new int[sourceWidth * sourceHeight];
            raster.getDataElements(sourceX, sourceY, sourceWidth, sourceHeight, temp);
            int sourceOffset = 0;
            int targetOffset = targetY * target.width + targetX;
            int y = 0;
            while (y < sourceHeight) {
                if (raster.getNumBands() == 3) {
                    int i = 0;
                    while (i < sourceWidth) {
                        target.pixels[targetOffset + i] = 0xFF000000 | temp[sourceOffset + i];
                        ++i;
                    }
                } else {
                    System.arraycopy(temp, sourceOffset, target.pixels, targetOffset, sourceWidth);
                }
                sourceOffset += sourceWidth;
                targetOffset += target.width;
                ++y;
            }
        }
    }

    @Override
    public void set(int x, int y, int argb) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        PGraphicsJava2D.getset[0] = argb;
        this.getRaster().setDataElements(x, y, getset);
    }

    @Override
    protected void setImpl(PImage sourceImage, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int targetX, int targetY) {
        WritableRaster raster = this.getRaster();
        if (sourceX == 0 && sourceY == 0 && sourceWidth == sourceImage.width && sourceHeight == sourceImage.height) {
            raster.setDataElements(targetX, targetY, sourceImage.width, sourceImage.height, sourceImage.pixels);
        } else {
            PImage temp = sourceImage.get(sourceX, sourceY, sourceWidth, sourceHeight);
            raster.setDataElements(targetX, targetY, temp.width, temp.height, temp.pixels);
        }
    }

    @Override
    public void mask(int[] alpha) {
        if (this.primarySurface) {
            PGraphicsJava2D.showWarning(MASK_WARNING);
        } else {
            super.mask(alpha);
        }
    }

    @Override
    public void mask(PImage alpha) {
        if (this.primarySurface) {
            PGraphicsJava2D.showWarning(MASK_WARNING);
        } else {
            super.mask(alpha);
        }
    }

    @Override
    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (sw != dw || sh != dh) {
            this.g2.drawImage(this.image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        } else {
            this.g2.copyArea(sx, sy, sw, sh, dx -= sx, dy -= sy);
        }
    }

    @Override
    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.g2.drawImage((Image)src.getNative(), dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
    }

    private static final class BlendingContext
    implements CompositeContext {
        private int mode;

        private BlendingContext(int mode) {
            this.mode = mode;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            if (src.getSampleModel().getDataType() != 3 || dstIn.getSampleModel().getDataType() != 3 || dstOut.getSampleModel().getDataType() != 3) {
                throw new IllegalStateException("Source and destination must store pixels as INT.");
            }
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            int alphaFiller = dstIn.getNumBands() == 3 ? -16777216 : 0;
            int y = 0;
            while (y < height) {
                src.getDataElements(0, y, width, 1, srcPixels);
                dstIn.getDataElements(0, y, width, 1, dstPixels);
                int x = 0;
                while (x < width) {
                    dstPixels[x] = PGraphicsJava2D.blendColor(alphaFiller | dstPixels[x], srcPixels[x], this.mode);
                    ++x;
                }
                dstOut.setDataElements(0, y, width, 1, dstPixels);
                ++y;
            }
        }
    }

    static class ImageCache {
        boolean tinted;
        int tintedColor;
        int[] tintedTemp;
        BufferedImage image;

        ImageCache() {
        }

        public void update(PImage source, boolean tint, int tintColor) {
            boolean opaque;
            int targetType = 2;
            boolean bl = opaque = (tintColor & 0xFF000000) == -16777216;
            if (source.format == 1 && (!tint || tint && opaque)) {
                targetType = 1;
            }
            if (this.image == null) {
                this.image = new BufferedImage(source.width, source.height, 2);
            }
            WritableRaster wr = this.image.getRaster();
            if (tint) {
                if (this.tintedTemp == null || this.tintedTemp.length != source.width) {
                    this.tintedTemp = new int[source.width];
                }
                int a2 = tintColor >> 24 & 0xFF;
                int r2 = tintColor >> 16 & 0xFF;
                int g2 = tintColor >> 8 & 0xFF;
                int b2 = tintColor & 0xFF;
                if (targetType == 1) {
                    int index = 0;
                    int y = 0;
                    while (y < source.height) {
                        int x = 0;
                        while (x < source.width) {
                            int argb1 = source.pixels[index++];
                            int r1 = argb1 >> 16 & 0xFF;
                            int g1 = argb1 >> 8 & 0xFF;
                            int b1 = argb1 & 0xFF;
                            this.tintedTemp[x] = 0xFF000000 | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                            ++x;
                        }
                        wr.setDataElements(0, y, source.width, 1, this.tintedTemp);
                        ++y;
                    }
                } else if (targetType == 2) {
                    if (source.format == 1 && (tintColor & 0xFFFFFF) == 0xFFFFFF) {
                        int hi = tintColor & 0xFF000000;
                        int index = 0;
                        int y = 0;
                        while (y < source.height) {
                            int x = 0;
                            while (x < source.width) {
                                this.tintedTemp[x] = hi | source.pixels[index++] & 0xFFFFFF;
                                ++x;
                            }
                            wr.setDataElements(0, y, source.width, 1, this.tintedTemp);
                            ++y;
                        }
                    } else {
                        int index = 0;
                        int y = 0;
                        while (y < source.height) {
                            int a1;
                            int b1;
                            int g1;
                            int r1;
                            int x;
                            if (source.format == 1) {
                                int alpha = tintColor & 0xFF000000;
                                x = 0;
                                while (x < source.width) {
                                    int argb1 = source.pixels[index++];
                                    r1 = argb1 >> 16 & 0xFF;
                                    g1 = argb1 >> 8 & 0xFF;
                                    b1 = argb1 & 0xFF;
                                    this.tintedTemp[x] = alpha | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                                    ++x;
                                }
                            } else if (source.format == 2) {
                                int x2 = 0;
                                while (x2 < source.width) {
                                    int argb1 = source.pixels[index++];
                                    a1 = argb1 >> 24 & 0xFF;
                                    r1 = argb1 >> 16 & 0xFF;
                                    g1 = argb1 >> 8 & 0xFF;
                                    b1 = argb1 & 0xFF;
                                    this.tintedTemp[x2] = (a2 * a1 & 0xFF00) << 16 | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                                    ++x2;
                                }
                            } else if (source.format == 4) {
                                int lower = tintColor & 0xFFFFFF;
                                x = 0;
                                while (x < source.width) {
                                    a1 = source.pixels[index++];
                                    this.tintedTemp[x] = (a2 * a1 & 0xFF00) << 16 | lower;
                                    ++x;
                                }
                            }
                            wr.setDataElements(0, y, source.width, 1, this.tintedTemp);
                            ++y;
                        }
                    }
                }
            } else {
                if (targetType == 1 && source.pixels[0] >> 24 == 0) {
                    source.filter(14);
                }
                wr.setDataElements(0, 0, source.width, source.height, source.pixels);
            }
            this.tinted = tint;
            this.tintedColor = tintColor;
        }
    }
}

