/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.video.Movie;

public class painthuffer
extends PApplet {
    Movie movie;
    boolean imageswap = false;
    float CELL_SIZE = 20.0f;
    boolean DEBUG = false;
    PImage image;
    PImage image2;
    ParticleSystem particles;
    float nextClear = 10000.0f;
    int maxParticles = 4000;
    PGraphics can;
    int framec = 0;

    public boolean sketchFullScreen() {
        return true;
    }

    public void setup() {
        this.orientation(2);
        this.size(this.displayWidth, this.displayHeight);
        this.movie = new Movie((PApplet)this, "video.ogv");
        this.movie.loop();
        this.movie.speed(1.0f);
        this.particles = new ParticleSystem(this, this.image);
        this.background(0);
        this.noStroke();
        this.frameRate(60.0f);
    }

    public void movieEvent(Movie movie) {
        movie.read();
    }

    public void draw() {
        this.fill(0, 2.0f);
        this.rect(0.0f, 0.0f, this.width, this.height);
        this.translate(this.width / 2, this.height / 2);
        this.rotate(painthuffer.cos((float)this.millis()) * 0.01f);
        this.translate(-this.width / 2, -this.height / 2);
        this.particles.setImage((PImage)this.movie);
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.add((float)this.width * 0.5f + this.random(-2.0f, 2.0f), (float)this.height * 0.5f + this.random(-2.0f, 2.0f));
        this.particles.plan();
        this.particles.move();
        this.particles.draw2();
        this.particles.draw();
        ++this.framec;
        if (this.framec > 25) {
            this.fill(255, 16.0f);
            this.framec = 0;
        }
        if ((float)this.millis() > this.nextClear) {
            this.nextClear += 6000.0f;
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "painthuffer"};
        if (stringArray != null) {
            PApplet.main((String[])painthuffer.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Cell {
        ParticleSystem sys;
        ArrayList<Particle> myparticles;
        Cell[] neighbors;
        PVector origin;

        Cell(ParticleSystem particleSystem, float f, float f2) {
            this.sys = particleSystem;
            this.myparticles = new ArrayList();
            this.origin = new PVector(painthuffer.this.CELL_SIZE * f, painthuffer.this.CELL_SIZE * f2);
        }

        public void plan() {
            for (Particle particle : this.myparticles) {
                PVector pVector = this.repel(particle);
                Cell[] cellArray = this.neighbors;
                int n = this.neighbors.length;
                int n2 = 0;
                while (n2 < n) {
                    Cell cell = cellArray[n2];
                    if (cell != null) {
                        pVector.add(cell.repel(particle));
                    }
                    ++n2;
                }
                pVector.limit(1.0f + painthuffer.cos((float)((float)painthuffer.this.millis() * 0.001f)) * 0.7f);
                particle.plan(pVector);
            }
        }

        public void move() {
            int n = this.myparticles.size() - 1;
            while (n >= 0) {
                Particle particle = this.myparticles.get(n);
                particle.move();
                if (particle.death) {
                    this.remove(particle);
                    painthuffer.this.particles.particleDump.remove(particle);
                    return;
                }
                if (!this.contains(particle.origin.x, particle.origin.y)) {
                    this.remove(particle);
                    this.sys.place(particle);
                }
                --n;
            }
        }

        public void draw() {
            for (Particle particle : this.myparticles) {
                particle.draw();
            }
            this.debugDraw();
        }

        public void draw2() {
            for (Particle particle : this.myparticles) {
                particle.draw2();
            }
            this.debugDraw();
        }

        public void debugDraw() {
            if (!painthuffer.this.DEBUG) {
                return;
            }
            painthuffer.this.noFill();
            painthuffer.this.stroke(255.0f, 0.0f, 0.0f);
            painthuffer.this.strokeWeight(1.0f);
            painthuffer.this.rect(this.origin.x, this.origin.y, painthuffer.this.CELL_SIZE, painthuffer.this.CELL_SIZE);
        }

        public void add(Particle particle) {
            this.myparticles.add(particle);
        }

        public void remove(Particle particle) {
            this.myparticles.remove(particle);
        }

        public void removeAll() {
            this.myparticles.clear();
        }

        public PVector repel(Particle particle) {
            PVector pVector = new PVector(0.0f, 0.0f);
            for (Particle particle2 : this.myparticles) {
                float f;
                if (particle2 == particle || (f = PVector.dist((PVector)particle.origin, (PVector)particle2.origin)) > painthuffer.this.CELL_SIZE) continue;
                PVector pVector2 = PVector.sub((PVector)particle.origin, (PVector)particle2.origin);
                pVector2.normalize();
                f = painthuffer.norm((float)f, (float)0.0f, (float)painthuffer.this.CELL_SIZE);
                pVector2.mult(particle.mass * particle2.mass / (f * f));
                pVector.add(pVector2);
            }
            return pVector;
        }

        public boolean contains(float f, float f2) {
            float f3 = f - this.origin.x;
            if (f3 < 0.0f || f3 > painthuffer.this.CELL_SIZE) {
                return false;
            }
            float f4 = f2 - this.origin.y;
            return !(f4 < 0.0f) && !(f4 > painthuffer.this.CELL_SIZE);
        }
    }

    class Particle {
        PVector origin;
        PVector forces;
        PVector velocity;
        boolean death;
        float mass;
        float age;
        PImage img;

        Particle(float f, float f2, PImage pImage) {
            this.origin = new PVector(f, f2);
            this.mass = 1.5f;
            this.age = 0.0f;
            this.velocity = new PVector(0.0f, 0.0f);
            this.img = pImage;
            this.death = false;
        }

        public void plan(PVector pVector) {
            this.velocity.mult(0.99f);
            pVector.div(this.mass);
            this.velocity.add(pVector);
            this.age += 1.0f;
        }

        public void move() {
            this.origin.add(this.velocity);
            if (this.outOfBounds()) {
                this.death = true;
                return;
            }
            int n = painthuffer.floor((float)painthuffer.map((float)this.origin.x, (float)0.0f, (float)painthuffer.this.width, (float)0.0f, (float)this.img.width));
            int n2 = painthuffer.floor((float)painthuffer.map((float)this.origin.y, (float)0.0f, (float)painthuffer.this.height, (float)0.0f, (float)this.img.height));
            if (this.img.pixels.length == 0) {
                return;
            }
            int n3 = this.img.pixels[n2 * this.img.width + n];
            float f = painthuffer.this.CELL_SIZE * painthuffer.norm((float)painthuffer.this.brightness(n3), (float)256.0f, (float)0.0f);
            this.mass = f > this.mass ? painthuffer.min((float)(this.mass * 1.1f), (float)f) : painthuffer.max((float)(this.mass * 0.9f), (float)f);
        }

        public boolean outOfBounds() {
            if (this.origin.x < 0.0f || this.origin.x >= (float)painthuffer.this.width) {
                return true;
            }
            return this.origin.y < 0.0f || this.origin.y >= (float)painthuffer.this.height;
        }

        public void draw() {
            float f = painthuffer.norm((float)this.mass, (float)0.0f, (float)(painthuffer.this.CELL_SIZE * 2.0f));
            float f2 = painthuffer.this.CELL_SIZE * f * f;
            int n = painthuffer.floor((float)painthuffer.map((float)this.origin.x, (float)0.0f, (float)painthuffer.this.width, (float)0.0f, (float)this.img.width));
            int n2 = painthuffer.floor((float)painthuffer.map((float)this.origin.y, (float)0.0f, (float)painthuffer.this.height, (float)0.0f, (float)this.img.height));
            int n3 = 0;
            if (n2 < this.img.height && n < this.img.width) {
                n3 = this.img.pixels[n2 * this.img.width + n];
            }
            if (painthuffer.this.brightness(n3) > 192.0f && painthuffer.this.imageswap) {
                n3 = (int)((float)n3 + (float)painthuffer.this.millis() * 0.02f);
            }
            float f3 = 16.0f + painthuffer.abs((float)(painthuffer.sin((float)((float)painthuffer.this.millis() * 0.04f)) * 192.0f));
            painthuffer.this.random(32.0f, 192.0f);
            f3 = 92.0f;
            painthuffer.this.fill(n3, f3);
            painthuffer.this.random(0.1f, 1.1f);
            float f4 = 16.0f + f2 * 4.0f - painthuffer.abs((float)(painthuffer.cos((float)((float)painthuffer.this.millis() * 0.1f * f2)) * 8.0f));
            if (painthuffer.this.brightness(n3) < 32.0f) {
                painthuffer.this.fill(0, 255.0f);
            }
            painthuffer.this.ellipse(this.origin.x, this.origin.y, (f4 + 4.0f) / 2.0f, (f4 + 4.0f) / 8.0f);
        }

        public void draw2() {
            float f = painthuffer.norm((float)this.mass, (float)0.0f, (float)painthuffer.this.CELL_SIZE);
            float f2 = painthuffer.this.CELL_SIZE * f * f;
            int n = painthuffer.floor((float)painthuffer.map((float)this.origin.x, (float)0.0f, (float)painthuffer.this.width, (float)0.0f, (float)this.img.width));
            int n2 = painthuffer.floor((float)painthuffer.map((float)this.origin.y, (float)0.0f, (float)painthuffer.this.height, (float)0.0f, (float)this.img.height));
            int n3 = 0;
            if (n2 < this.img.height && n < this.img.width) {
                n3 = this.img.pixels[n2 * this.img.width + n];
            }
            if (painthuffer.this.brightness(n3) > 192.0f && painthuffer.this.imageswap) {
                n3 = (int)((float)n3 + (float)painthuffer.this.millis() * 0.02f);
            }
            painthuffer.abs((float)(painthuffer.sin((float)((float)painthuffer.this.millis() * 4.0E-5f)) * 92.0f));
            painthuffer.this.random(32.0f, 192.0f);
            painthuffer.this.fill(n3, 255.0f);
            painthuffer.this.random(0.1f, 1.1f);
            if (painthuffer.this.brightness(n3) < 32.0f) {
                painthuffer.this.fill(0, 255.0f);
            }
            float f3 = 16.0f + f2 * 4.0f - painthuffer.abs((float)(painthuffer.cos((float)((float)painthuffer.this.millis() * 0.1f * f2)) * 8.0f));
            painthuffer.this.ellipse(this.origin.x, this.origin.y, (f3 + 4.0f) / 4.0f, (f3 + 4.0f) / 4.0f);
        }
    }

    public class ParticleSystem {
        Cell[][] cells;
        ArrayList<Particle> particleDump;
        PImage img;
        PImage img2;
        int cellWidth;
        int cellHeight;

        ParticleSystem(PApplet pApplet, PImage pImage) {
            int n;
            this.cellWidth = painthuffer.this.width / (int)painthuffer.this.CELL_SIZE;
            this.cellHeight = painthuffer.this.height / (int)painthuffer.this.CELL_SIZE;
            this.img = pImage;
            this.particleDump = new ArrayList();
            this.cells = new Cell[this.cellWidth][this.cellHeight];
            int n2 = 0;
            while (n2 < this.cellWidth) {
                n = 0;
                while (n < this.cellHeight) {
                    this.cells[n2][n] = new Cell(this, n2, n);
                    ++n;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.cellWidth) {
                n = 0;
                while (n < this.cellHeight) {
                    this.cells[n2][n].neighbors = this.neighbors(n2, n);
                    ++n;
                }
                ++n2;
            }
        }

        public void setImage(PImage pImage) {
            this.img = pImage;
        }

        public void removeAll() {
            int n = 0;
            while (n < this.cellWidth) {
                int n2 = 0;
                while (n2 < this.cellHeight) {
                    this.cells[n][n2].removeAll();
                    ++n2;
                }
                ++n;
            }
        }

        public void plan() {
            int n = 0;
            while (n < this.cellWidth) {
                int n2 = 0;
                while (n2 < this.cellHeight) {
                    this.cells[n][n2].plan();
                    ++n2;
                }
                ++n;
            }
        }

        public void move() {
            Cell[][] cellArray = this.cells;
            int n = this.cells.length;
            int n2 = 0;
            while (n2 < n) {
                Cell[] cellArray2;
                Cell[] cellArray3 = cellArray2 = cellArray[n2];
                int n3 = cellArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Cell cell = cellArray3[n4];
                    cell.move();
                    ++n4;
                }
                ++n2;
            }
        }

        public void draw() {
            Cell[][] cellArray = this.cells;
            int n = this.cells.length;
            int n2 = 0;
            while (n2 < n) {
                Cell[] cellArray2;
                Cell[] cellArray3 = cellArray2 = cellArray[n2];
                int n3 = cellArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Cell cell = cellArray3[n4];
                    cell.draw();
                    ++n4;
                }
                ++n2;
            }
        }

        public void draw2() {
            Cell[][] cellArray = this.cells;
            int n = this.cells.length;
            int n2 = 0;
            while (n2 < n) {
                Cell[] cellArray2;
                Cell[] cellArray3 = cellArray2 = cellArray[n2];
                int n3 = cellArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Cell cell = cellArray3[n4];
                    cell.draw2();
                    ++n4;
                }
                ++n2;
            }
        }

        public void add(float f, float f2) {
            if (this.particleDump.size() >= painthuffer.this.maxParticles) {
                return;
            }
            Particle particle = new Particle(f, f2, this.img);
            this.place(particle);
            this.particleDump.add(particle);
        }

        public void place(Particle particle) {
            int n = painthuffer.floor((float)(particle.origin.x / painthuffer.this.CELL_SIZE));
            int n2 = painthuffer.floor((float)(particle.origin.y / painthuffer.this.CELL_SIZE));
            if (n < 0 || n >= this.cellWidth) {
                return;
            }
            if (n2 < 0 || n2 >= this.cellHeight) {
                return;
            }
            Cell cell = this.cells[n][n2];
            cell.add(particle);
        }

        public Cell[] neighbors(int n, int n2) {
            Cell[] cellArray = new Cell[]{this.getCell(n - 1, n2 - 1), this.getCell(n, n2 - 1), this.getCell(n + 1, n2 - 1), this.getCell(n - 1, n2), this.getCell(n + 1, n2), this.getCell(n - 1, n2 + 1), this.getCell(n, n2 + 1), this.getCell(n + 1, n2 + 1)};
            return cellArray;
        }

        public Cell getCell(int n, int n2) {
            if (n < 0 || n >= this.cellWidth || n2 < 0 || n2 >= this.cellHeight) {
                return null;
            }
            return this.cells[n][n2];
        }

        public int getColor(float f, float f2) {
            int n = painthuffer.floor((float)painthuffer.map((float)f, (float)0.0f, (float)painthuffer.this.width, (float)0.0f, (float)this.img.width));
            int n2 = painthuffer.floor((float)painthuffer.map((float)f2, (float)0.0f, (float)painthuffer.this.height, (float)0.0f, (float)this.img.height));
            return this.img.pixels[n2 * this.img.width + n];
        }
    }
}

