#version 150

#define M_PI 3.1415926535897932384626433832795

uniform sampler2D tex1, tex2;
uniform float time;

in vec2 uv;
in vec2 position;
out vec4 color;	

vec2 derivatives(vec2 v)
{
	float x2 = v.x * v.x;
	float y2 = v.y * v.y;
	return vec2(-v.y / (x2 + y2), v.x / (x2 + y2));
}

float tosrgb(float x)
{
	return pow(x, 1/2.2);
}

float tolinear(float x)
{
	return pow(x, 2.2);
}

void main()
{
	float rAngle = time;
	vec2 offset = vec2(0.0, -0.5);
	vec2 newposition = position + offset;
	vec2 posDerivatives = vec2(dFdx(newposition.x), dFdy(newposition.y));

	float angle;
	angle = atan(newposition.y, newposition.x);
	vec2 angleDerivatives = derivatives(newposition);
	angleDerivatives /= M_PI;

	float len = length(newposition);

	float offset1 = 0.25 / len + time * 0.7;
	float offset2 = (angle / M_PI) + time * 0.25;
	float offset4 = (angle / M_PI) + time * -0.25;
	float offset3 = 0.25 / len + time * -1.3;
	
	vec2 dx = vec2(dFdx(offset1), angleDerivatives.x * posDerivatives.x);
	vec2 dy = vec2(dFdy(offset1), angleDerivatives.y * posDerivatives.y);
	
	float mult = clamp(len, 0.0, 1.0);

	color = (textureGrad(tex1, vec2(offset1, offset2), dx, dy) + textureGrad(tex2, vec2(offset3, offset4), dx, dy).bgra) * tolinear(mult * (sin(time * 60.0) * 0.5 + 0.5));	
	if(time > 30) {
		color.rgba = color.gbra;
	}
}