var Jazz = function() {
	this.variables;
	this.animationLayers = {};
}

Jazz.prototype.addAnimation = function(animationDefinitions)
{
	this.animationLayers = addAnimation(this.animationLayers, animationDefinitions);
}

var handSyncDuration = 0.25;
Jazz.prototype.addHandSyncAnimation = function(basetime, layer)
{
	var handScale = 0.80;
	this.addAnimation([
	{
		 "start": basetime, "duration": handSyncDuration*2
		,"layer": layer, "image": "data/hand_1.png"
		,"color":[{"a":0},{"a":255,"duration":handSyncDuration},{"a":0,"duration":handSyncDuration}]
		,"scale":[{"x":handScale,"y":handScale}]
	},
	{
		 "start": basetime+handSyncDuration, "duration": handSyncDuration*2
		,"layer": layer, "image": "data/hand_2.png"
		,"color":[{"a":0},{"a":255,"duration":handSyncDuration},{"a":0,"duration":handSyncDuration}]
		,"scale":[{"x":handScale,"y":handScale}]
	},
	{
		 "start": basetime+handSyncDuration*2, "duration": handSyncDuration*2
		,"layer": layer, "image": "data/hand_3.png"
		,"color":[{"a":0},{"a":255,"duration":handSyncDuration},{"a":0,"duration":handSyncDuration}]
		,"scale":[{"x":handScale,"y":handScale}]
	}]);
}

Jazz.prototype.init = function()
{
	setResourceCount(43);
	//vinyl animation
	this.addAnimation([
	{
		 "start": "0:00", "duration": "0:30"
		,"layer": "00100", "image": "data/vinyl.png"
		,"scale": [
			 {"x":3,"y":3}
			,{"duration":"0:10"}
			,{"duration":"0:10","x":1.125,"y":1.125}
		]
		,"color": [
			 {"a":0}
			,{"duration":"0:01","a":255}
			,{"duration":"0:25"}
			,{"duration":"0:01","a":0}
		]
	}
	,{
		 "start": "0:00", "duration": "0:30"
		,"layer": "00100", "image": "data/vinyl_label.png"
		,"scale": [
			 {"x":3,"y":3}
			,{"duration":"0:10"}
			,{"duration":"0:10","x":1.125,"y":1.125}
		]
		,"color": [
			 {"a":0}
			,{"duration":"0:01","a":255}
			,{"duration":"0:25"}
			,{"duration":"0:01","a":0}
		]
		,"angle": [
			 {"degrees":0}
			,{"duration":"0:00.35","degrees":0}
			//scratch1
			,{"duration":"0:00.20","degrees":45}
			,{"duration":"0:00.20","degrees":5}
			,{"duration":"0:00.20","degrees":30}
			,{"duration":"0:00.75","degrees":30}
			//scratch2
			,{"duration":"0:00.20","degrees":-10}
			,{"duration":"0:00.20","degrees":10}
			,{"duration":"0:00.20","degrees":0}
			,{"duration":"0:01.50","degrees":0}
			//scratch1
			,{"duration":"0:00.20","degrees":45}
			,{"duration":"0:00.20","degrees":5}
			,{"duration":"0:00.20","degrees":30}
			,{"duration":"0:00.75","degrees":30}
			//scratch2
			,{"duration":"0:00.20","degrees":-10}
			,{"duration":"0:00.20","degrees":10}
			,{"duration":"0:00.20","degrees":0}
			//scratch1
			,{"start":"0:07.05","duration":"0:00.20","degrees":45}
			,{"duration":"0:00.20","degrees":5}
			,{"duration":"0:00.20","degrees":30}
			,{"duration":"0:00.75","degrees":390}
			,{"duration":"0:00.20","degrees":380}
			,{"duration":"0:00.20","degrees":400}
			,{"duration":"0:00.20","degrees":390}
			,{"duration":"0:25.00","degrees":390+360*7.5}
		]
	}
	]);

	//credits
	var credX = getScreenWidth()/2;
	var credY = getScreenHeight()/2;
	var credScale = 0.75;
	var credAlpha = 255;
	var credFadeDuration = 0.5;
	var credShowDuration = 4.0;
	this.addAnimation([
	{
		 "start": "0:28.1", "duration": credShowDuration-0.4
		,"layer": "00100", "image": "data/music_guy.png"
		,"position": [
			 {"x":credX, "y":credY}
		]
		,"scale": [{"x":credScale,"y":credScale}]
		,"color": [
			 {"r":0,"g":0,"b":0,"a":0}
			,{"duration":credFadeDuration,"a":credAlpha}
			,{"duration":credShowDuration-credFadeDuration*2-0.4}
			,{"duration":credFadeDuration,"a":0}
		]
	},
	{
		 "duration": credShowDuration-0.6
		,"layer": "00100", "image": "data/design_guy.png"
		,"position": [
			 {"x":credX, "y":credY}
		]
		,"scale": [{"x":credScale,"y":credScale}]
		,"color": [
			 {"r":0,"g":0,"b":0,"a":0}
			,{"duration":credFadeDuration,"a":credAlpha}
			,{"duration":credShowDuration-credFadeDuration*2-0.6}
			,{"duration":credFadeDuration,"a":0}
		]
	},
	{
		 "duration": credShowDuration
		,"layer": "00100", "image": "data/coder_guy.png"
		,"position": [
			 {"x":credX, "y":credY}
		]
		,"scale": [{"x":credScale,"y":credScale}]
		,"color": [
			 {"r":0,"g":0,"b":0,"a":0}
			,{"duration":credFadeDuration,"a":credAlpha}
			,{"duration":credShowDuration-credFadeDuration*2}
			,{"duration":credFadeDuration,"a":0}
		]
	}
	]);

	this.addAnimation([
	{
		 "start": "0:00", "duration": "2:03"
		,"layer": "00000"
		,"runFunction":"{randomizeGrid();}"
	}]);

	//disco
	this.addAnimation([
	{
		 "start": "0:10", "end": "1:11"
		,"layer": "00002", "fadeOutDuration":3
		,"runFunction":"{drawSpiral(animation);}"
	}]);
	this.addAnimation([
	{
		 "start": "0:10", "end": "0:58"
		,"layer": "00004", "fadeOutDuration":3
		,"runFunction":"{drawDiscoball(animation);}"
	}]);
	this.addAnimation([
	{
		 "start": "0:40.5", "end": "1:08"
		,"layer": "00003"
		,"initFunction":"{initStarParticles(animation);}"
		,"runFunction":"{drawStarParticles(animation);}"
	}]);
	
	//deformation
	var deformationStart = "1:08";
	var deformationDuration = "0:16";
	this.addAnimation([
	{
		 "start": deformationStart, "duration": deformationDuration
		,"layer": "00001"
		,"fbo":{"name":"fbo","action":"begin"}
	},
	{
		 "start": deformationStart, "duration": deformationDuration
		,"layer": "00001"
		,"initFunction":"{initColorTile();}"
		,"useFade":false
		,"runFunction":"{drawColorTile(animation);}"
	},
	{
		 "start": deformationStart, "duration": deformationDuration
		,"layer": "00001"
		,"fbo":{"name":"fbo","action":"end"}
		,"shader":{"name":"Deformation",
			"variables":[
				 {"name":"time","value":"{return getSceneTimeFromStart()/10.0;}"}
				,{"name":"effect","type":"int","value":4}
			]
		}
	}]);

	//color tiles
	this.addAnimation([
		{
			 "start": "1:21.30", "duration": "0:15"
			,"layer": "00001"
			,"useFade":true
			,"runFunction":"{drawColorTile(animation);}"
		},
		{
			 "start": "1:35","end": "2:05"
			,"layer": "00001"
			,"initFunction":"{initColorTile(0,0,false);}"
			,"showPictures":true
			,"useFade":true
			,"greets":true
			,"useFadeOut":true
			,"runFunction":"{drawColorTile(animation);}"
		}
	]);
	
	this.addAnimation([
		{
			 "start": "1:16.00", "duration": "0:18.5"
			,"layer": "00010", "image": "data/jah_question.png"
			,"initFunction":"{initJumalautaAgainstHumanity(animation);}"
			,"runFunction":"{drawJumalautaAgainstHumanity(animation);}"
			,"color": [
				 {"a":0}
				,{"duration":1,"a":255}
				,{"duration":16.5}
				,{"duration":1,"a":0}
			]
		},
	]);


	this.addAnimation([
	{
		 "start": "2:03", "duration": 10
		,"layer": "00000", "image": "data/end.png"
	}]);

	//hand 1-2-3 animations
	this.addHandSyncAnimation(26.60, "00100");
	this.addHandSyncAnimation(81.30, "00100");
	this.addHandSyncAnimation(95.00, "00100");
}

Jazz.prototype.run = function()
{
	drawAnimation(this.animationLayers);
}

var colorPalette = [
	{"r":255,"g":171,"b":171,"a":255},
	{"r":255,"g":218,"b":171,"a":255},
	{"r":221,"g":255,"b":171,"a":255},
	{"r":171,"g":228,"b":255,"a":255},
	{"r":217,"g":171,"b":255,"a":255}
];

var colorTileColors = [0,1,2,3,4,0,1,2,3,0,1,2,3,4,0,1];
var colorSpriralColor = 0;

var randomizeTime = 0;
var randomizeTime2 = 0;

var colorTileX = 5;
var colorTileY = 3;
var colorTileImages = new Array(colorTileX*colorTileY);
var colorTileImagesOld = new Array(colorTileX*colorTileY);
var colorTileFades = new Array(colorTileX*colorTileY);
var colorTileLoadedImages;
var colorTileGreetImages;
var colorTileGreetIterator = 0;

function initColorTileImage(images, startTime, durationTime, colorTileImage)
{
	colorTileImage.active = true;
	colorTileImage.imagesI = Math.floor(random()*(images.length));
	colorTileImage.tex = images[colorTileImage.imagesI];
	colorTileImage.angle = Math.floor(random()*4)*90;
	if (colorTileImage.angle == 180)
	{
		colorTileImage.angle = 0;
	}
	colorTileImage.color = colorPalette[Math.floor(random()*(colorPalette.length))];
	colorTileImage.start = startTime;
	colorTileImage.duration = durationTime;
	if (colorTileImage.start+colorTileImage.duration > 122)
	{
		colorTileImage.active = false;
	}
}

function initColorTile()
{
	colorTileLoadedImages = [
		imageLoadImage("data/fist_closed.png"),
		imageLoadImage("data/hand_1.png"),
		imageLoadImage("data/hand_2.png"),
		imageLoadImage("data/hand_3.png"),
		imageLoadImage("data/hand_5_left.png"),
		imageLoadImage("data/hand_5_right.png")
	];

	colorTileGreetImages = [
		imageLoadImage("data/greet_darklite.png"),
		imageLoadImage("data/greet_dekadence.png"),
		imageLoadImage("data/greet_epoch.png"),
		imageLoadImage("data/greet_f.png"),
		imageLoadImage("data/greet_iso.png"),
		imageLoadImage("data/greet_mercury.png"),
		imageLoadImage("data/greet_mfx.png"),
		imageLoadImage("data/greet_primitive.png")
	];

	for(var i = 0; i < colorTileFades.length; i++)
	{
		colorTileFades[i] = Math.floor(random()*2)*handSyncDuration+handSyncDuration;
	}

	for(var i = 0; i < colorTileImages.length; i++)
	{
		if (colorTileImages[i] === undefined)
		{
			colorTileImages[i] = {};
			colorTileImagesOld[i] = {};
			colorTileImagesOld[i].active = false;
		}
	}
	
	randomizeColorTileImages(0, 0, false);
}

function randomizeColorTileImages(startTime, durationTime, randomizeInit)
{
	for(var i = 0; i < colorTileImages.length; i++)
	{
		colorTileImagesOld[i] = JSON.parse(JSON.stringify(colorTileImages[i]));
		colorTileImagesOld[i].tex = colorTileLoadedImages[colorTileImages[i].imagesI];
		colorTileImagesOld[i].active = true;

		if (colorTileImages[i].start+colorTileImages[i].duration > 120)
		{
			colorTileImages[i].active = false;
			colorTileImagesOld[i].active = false;
		}

		if (randomizeInit)
		{
			var rand = random();
			/*if (rand > 0.8)
			{
				colorTileImages[i].active = false;
			}*/
			if (rand > 0.4)
			{
				continue;
			}
		}

		initColorTileImage(colorTileLoadedImages, startTime, durationTime, colorTileImages[i]);
	}
}

function randomizeGrid()
{
	var waitSeconds = 0.5;
	if (Math.abs(getSceneTimeFromStart()-randomizeTime) > waitSeconds)
	{
		var randomIndex = 0;
		for(var i=0; i<colorTileColors.length; i++)
		{
			if (i%3==0)
			{
				randomIndex = random()*colorPalette.length;
			}
			var index = Math.floor(i+randomIndex)%colorPalette.length;

			colorTileColors[i] = index;
		}
		
		randomizeTime=getSceneTimeFromStart();

		randomizeColorTileImages(randomizeTime, waitSeconds, true);
	}

	waitSeconds = 0.9;
	if (Math.abs(getSceneTimeFromStart()-randomizeTime2) > waitSeconds)
	{
		colorSpriralColor=(colorSpriralColor+3)%colorPalette.length;
		randomizeTime2=(getSceneTimeFromStart());
	}
}


function drawColorTile(animation)
{
	var time = getSceneTimeFromStart();
	var sizeH = getScreenHeight()/colorTileY;
	var sizeW = getScreenWidth()/colorTileX;
	var posX = -sizeW; 
	var posY = -sizeH;
	var spacing = getScreenHeight()/10.;
	
	var showPictures = animation.showPictures==true ? 1:0;
	var useFade = animation.useFade==true ? 1:0;
	var useFadeOut = animation.useFadeOut==true ? 1:0;
	var greets = animation.greets==true ? 1:0;
	
	if (greets)
	{
		var greetStart = animation.start+2;
		var greetProgress = (time-greetStart)/(animation.end-4-greetStart);
		if (time > greetStart && greetProgress >= 0 && greetProgress < 1)
		{
			if (colorTileGreetIterator == 0)
			{
				colorTileLoadedImages.push(colorTileGreetImages[0]);
				colorTileGreetIterator++;
			}
			colorTileLoadedImages[colorTileLoadedImages.length-1] = colorTileGreetImages[Math.floor(greetProgress*colorTileGreetImages.length)];
		}
	}
	
	var i=0;
	for(var yi=1; yi<=colorTileY; yi++)
	{
		for(var xi=1; xi<=colorTileX; xi++, i++)
		{
			var color = colorPalette[colorTileColors[i]];

			var fade = 1;
			if (useFade)
			{
				fade = 0;
				if (time-animation.start > colorTileFades[i])
				{
					fade = (time-animation.start)/2.0;
					if (fade > 1)
					{
						fade = 1;
					}
				}
			}

			if (useFadeOut && fade == 1)
			{
				if (time+1.0+colorTileFades[i] >= animation.end)
				{
					fade = animation.end-(time+1.0+colorTileFades[i])/(1.0);
					if (fade > 1)
					{
						fade = 1;
					}
					else if (fade < 0)
					{
						fade = 0;
					}
				}
			}
						
			var w = sizeW;
			var h = sizeH;
			var x = (xi)*w+posX;
			var y = (yi)*h+posY;

			perspective2dBegin(getScreenWidth(), getScreenHeight());
			glColor4ub(color.r, color.g, color.b, color.a*fade);
			glBegin(GL_QUADS);
			glVertex2f(x,y);
			glVertex2f(x+w,y);
			glVertex2f(x+w,y+h);
			glVertex2f(x,y+h);
			glEnd();
			perspective2dEnd();

			if (showPictures==1)
			{
				var image = colorTileImages[i];
				var imageOld = colorTileImagesOld[i];
				var p = (time-image.start)/image.duration;
				if (p > 1)
				{
					p = 1;
				}
				var alpha = p*255;
				var degrees = image.angle;

				if (imageOld.active === true)
				{
					var scaleX = h/imageOld.tex.h;
					var scaleY = h/imageOld.tex.h;
					var texX = x + w/2 - scaleX*imageOld.tex.w/2;
					var texY = y + h/2 - scaleY*imageOld.tex.h/2;

					color = imageOld.color;
					glColor4ub(
						interpolateLinear(p, image.color.r, color.r),
						interpolateLinear(p, image.color.g, color.g),
						interpolateLinear(p, image.color.b, color.b),
						(255-alpha)*fade);
					scaleTexture(imageOld.tex.ptr, scaleX, scaleY);
					setTexturePositionPixel(imageOld.tex.ptr, texX, texY);
					setTextureAngle(imageOld.tex.ptr, interpolateLinear(p, image.angle, imageOld.angle));
					showImage(imageOld.tex.ptr);
					setTextureDefaults(imageOld.tex.ptr);
				}
				
				if (image.active === true)
				{
					var scaleX = h/image.tex.h;
					var scaleY = h/image.tex.h;
					var texX = x + w/2 - scaleX*image.tex.w/2;
					var texY = y + h/2 - scaleY*image.tex.h/2;

					color = image.color;
					glColor4ub(color.r, color.g, color.b, alpha*fade);
					scaleTexture(image.tex.ptr, scaleX, scaleY);
					setTexturePositionPixel(image.tex.ptr, texX, texY);
					setTextureAngle(image.tex.ptr, image.angle);
					showImage(image.tex.ptr);
					setTextureDefaults(image.tex.ptr);
				}
			}
		}
	}
	
	glColor3ub(255,255,255);
}

var starOpen;
var star;
var starParticles = new Array(100);

function initParticle(animation, particle)
{
	if (Math.floor(random()*2) % 2)
	{
		particle.tex = starOpen;
	}
	else
	{
		particle.tex = star;
	}
	
	particle.scaleX = particle.scaleY = 0.1+random()*0.4;
	particle.startAngle = random()*360;
	particle.endAngle = random()*360*(random()*2-1);
	
	particle.x = getScreenWidth()/2-(star.w*particle.scaleX)/2;
	particle.y = getScreenHeight()/2-(star.h*particle.scaleY)/2;
	var precision = 720;
	var radius = getScreenWidth();
	var angle = (random()*precision+precision)*2*Math.PI/precision;
	particle.endX = Math.cos(angle) * radius;
	particle.endY = Math.sin(angle) * radius;
	var color = colorPalette[Math.floor(random()*colorPalette.length)];
	particle.color = color;

	var lifeSeconds = 3;	
	particle.startTime = getSceneTimeFromStart()+random()*lifeSeconds*2;
	particle.duration = lifeSeconds+random()*lifeSeconds;
	
	particle.active = 1;
	if (particle.startTime+particle.duration > animation.end)
	{
		particle.active = 0;
	}
}

function initStarParticles(animation)
{
	starOpen = imageLoadImage("data/star_open.png");
	star = imageLoadImage("data/star.png");

	for(var i = 0; i < starParticles.length; i++)
	{
		starParticles[i] = {};
		initParticle(animation, starParticles[i]);
	}
	//debugPrint(JSON.stringify(starParticles,null,2));
}

function drawStarParticles(animation)
{
	var time = getSceneTimeFromStart();
	for(var i = 0; i < starParticles.length; i++)
	{
		var particle = starParticles[i];
		var p = (time-particle.startTime)/particle.duration;
		if (particle.active == 1 && p >= 0.0)
		{
			if (p > 1.0)
			{
				initParticle(animation, particle);
				continue;
			}
			
			var alpha = 1;
			if (p < 0.1) { alpha = p*10; }
			
			var degrees = interpolateLinear(p,particle.startAngle,particle.endAngle);
			var x = interpolateLinear(p,particle.x,particle.endX);
			var y = interpolateLinear(p,particle.y,particle.endY);

			
			glColor4ub(particle.color.r,particle.color.g,particle.color.b,255*alpha);
			setTexturePositionPixel(particle.tex.ptr, x,y);
			scaleTexture(particle.tex.ptr, particle.scaleX, particle.scaleY);
			setTextureAngle(particle.tex.ptr, degrees);
			showImage(particle.tex.ptr);
			setTextureDefaults(particle.tex.ptr);
			glColor4ub(255,255,255,255);
		}
	}
}

function drawSpiral(animation)
{
	glPushMatrix();

	var precision = 20;
	var radius = getScreenWidth();
	var x = (getScreenWidth())/2.;
	var y = (getScreenHeight())/2.;
	
	var time = getSceneTimeFromStart();
	var fadeDuration = animation.fadeOutDuration;
	var fadeEnd1 = evaluateVariable(animation, animation.end);
	var fadeStart1 = fadeEnd1-fadeDuration;
	var fadeEnd2 = evaluateVariable(animation, animation.end);
	var fadeStart2 = fadeEnd2-fadeDuration;
	var posY = 0;
	var cp1 = 1;
	var cp2 = 1;
	if (time > fadeStart1)
	{
		cp1 = 1-(time-fadeStart1)/fadeDuration;
		if (cp1 < 0) {cp1 = 0;}
	}
	if (time > fadeStart2)
	{
		cp2 = 1-(time-fadeStart2)/fadeDuration;
		if (cp2 < 0) {cp2 = 0;}
	}

	perspective2dBegin(getScreenWidth(), getScreenHeight());
	glTranslatef(x,y,0);
	glRotatef(getSceneTimeFromStart()*45,0,0,-1);
	glTranslatef(-x,-y,0);
	for (var i=0; i < precision; i++)
	{
		var x1 = x;
		var y1 = y;
		var angle = (i+precision)*2*Math.PI/precision;
		var x2 = Math.cos(angle) * radius;
		var y2 = Math.sin(angle) * radius;
		angle = (i+1+precision)*2*Math.PI/precision;
		var x3 = Math.cos(angle) * radius;
		var y3 = Math.sin(angle) * radius;

		var colorIndex = colorSpriralColor;
		if (i%2)
		{
			colorIndex = (colorIndex+1)%(colorPalette.length);
			var color = colorPalette[colorIndex];
			glColor4ub(color.r, color.g, color.b,255*cp1);
			if (cp1 < 1)
			{
				x1 = interpolateLinear(1-cp1, x, (x2+x3)/2);
				y1 = interpolateLinear(1-cp1, y, (y2+y3)/2);
			}
		}
		else
		{
			var color = colorPalette[colorIndex];
			glColor4ub(color.r, color.g, color.b,255*cp2);
			if (cp2 < 1)
			{
				x1 = interpolateLinear(1-cp2, x, (x2+x3)/2);
				y1 = interpolateLinear(1-cp2, y, (y2+y3)/2);
			}
		}
		
		glBegin(GL_TRIANGLES);
		glVertex2f(x + x2, y + y2);
		glVertex2f(x1, y1);
		glVertex2f(x + x3, y + y3);
		glEnd();
	}
	perspective2dEnd();
	
	glPopMatrix();
}

function drawDiscoball(animation)
{
	var time = getSceneTimeFromStart();
	var fadeDuration = animation.fadeOutDuration;
	var fadeEnd = evaluateVariable(animation, animation.end);
	var fadeStart = fadeEnd-fadeDuration;

	var posY = 0;
	if (time > fadeStart)
	{
		var p = (time-fadeStart)/fadeDuration;
		posY = interpolateLinear(p,0,4);
	}
	
	glDisable(GL_TEXTURE_2D);
	glPushMatrix();
	glTranslatef(0,posY,-5);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glShadeModel(GL_FLAT);

	var colorIndex = colorSpriralColor;
	var color = colorPalette[colorIndex];

	setLight4ub(GL_LIGHT0, GL_AMBIENT, color.r,color.g,color.b,255);
	setLight4ub(GL_LIGHT0, GL_DIFFUSE, 255,255,255,255);
	setLight4ub(GL_LIGHT0, GL_SPECULAR, color.r,color.g,color.b,255);
	setLight4f(GL_LIGHT0, GL_POSITION, 0.6,0.2,1.0,0); 

	glColor4f(1,1,1,1);

	glRotatef(getSceneTimeFromStart()*30,0,-1,0);
	glRotatef(90,1,0,0);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	drawSphere(1,30,15);
	glDisable(GL_LIGHT0);
	glDisable(GL_LIGHTING);
	glEnable(GL_BLEND);
	glColor4f(1,1,1,1);
	
	glLineWidth(3);
	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
	var col = 0.25;
	glColor4f(col,col,col,0.15);
	drawSphere(1,30,15);
	glLineWidth(1);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glShadeModel(GL_SMOOTH);
	glPopMatrix();
}

var jahAnswerImages;
var jahAnswer1 = {};
var jahAnswer2 = {};
function initJumalautaAgainstHumanity(animation)
{
	jahAnswerImages = [
		imageLoadImage("data/jah_answer_01.png"),
		imageLoadImage("data/jah_answer_02.png"),
		imageLoadImage("data/jah_answer_04.png"),
		imageLoadImage("data/jah_answer_06.png"),
		imageLoadImage("data/jah_answer_07.png"),
		imageLoadImage("data/jah_answer_08.png"),
		imageLoadImage("data/jah_answer_09.png"),
		imageLoadImage("data/jah_answer_10.png"),
		imageLoadImage("data/jah_answer_11.png"),
		imageLoadImage("data/jah_answer_12.png"),
		imageLoadImage("data/jah_answer_13.png"),
		imageLoadImage("data/jah_answer_14.png"),
		imageLoadImage("data/jah_answer_15.png"),
		imageLoadImage("data/jah_answer_16.png"),
		imageLoadImage("data/jah_answer_17.png"),
		imageLoadImage("data/jah_answer_18.png"),
		imageLoadImage("data/jah_answer_19.png"),
		imageLoadImage("data/jah_answer_20.png")
	];
}

var jahWaitSeconds = 2;
function setJahAnswer(animation, jahAnswer)
{
	if (jahAnswerImages.length < 1)
	{
		return;
	}

	var selectedAnswer = Math.floor(Math.random()*jahAnswerImages.length);
	jahAnswer.ref = JSON.parse(JSON.stringify(jahAnswerImages[selectedAnswer]));
	jahAnswer.ref.ptr = jahAnswerImages[selectedAnswer].ptr;
	jahAnswerImages.splice(selectedAnswer,1);
	
	jahAnswer.start = getSceneTimeFromStart();
	jahAnswer.duration = jahWaitSeconds;
	if (jahAnswer.start+jahAnswer.duration > animation.end)
	{
		jahAnswer.duration = animation.end-jahAnswer.start-0.5;
	}
}

function drawJahAnswer(animation, jahAnswer, y)
{
	if (jahAnswer.ref === undefined)
	{
		return;
	}

	var time = getSceneTimeFromStart();

	var fadeDuration = 0.5;
	var fadeP = 0;
	fadeP = (time-jahAnswer.start)/fadeDuration;
	if (fadeP > 1)
	{
		fadeP = 1;
		if (time-jahAnswer.start > jahAnswer.duration-fadeDuration)
		{
			fadeP = 1-(time-jahAnswer.start-(jahAnswer.duration-fadeDuration))/fadeDuration;
		}
	}

	glColor4ub(255,255,255,255*fadeP);
	scaleTexture(jahAnswer.ref.ptr, 1, 1);
	setTexturePositionPixel(jahAnswer.ref.ptr, 0, y);
	showImage(jahAnswer.ref.ptr);
	setTextureDefaults(jahAnswer.ref.ptr);
	glColor4ub(255,255,255,255);
}

var jahTime=0;
function drawJumalautaAgainstHumanity(animation)
{
	var time = getSceneTimeFromStart();

	if (time > 82.5 && time < animation.start+animation.duration-1.5)
	{
		if (Math.abs(time-jahTime) > jahWaitSeconds)
		{
			setJahAnswer(animation, jahAnswer1);
			setJahAnswer(animation, jahAnswer2);

			jahTime=time;
		}

	}

	drawJahAnswer(animation, jahAnswer1, 170);
	drawJahAnswer(animation, jahAnswer2, 370);
}
