/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.kananen.miska.emissions;

import com.gmail.kananen.miska.emissions.BackgroundSoundTask;
import com.gmail.kananen.miska.emissions.BlastWaveTask;
import com.gmail.kananen.miska.emissions.Cover;
import com.gmail.kananen.miska.emissions.EmissionDamageTask;
import com.gmail.kananen.miska.emissions.PlayerCoverInformationTask;
import com.gmail.kananen.miska.emissions.PlayerDamageListener;
import com.gmail.kananen.miska.emissions.PlayerRespawnListener;
import com.gmail.kananen.miska.emissions.SafeArea;
import com.gmail.kananen.miska.emissions.ThunderTask;
import com.gmail.kananen.miska.emissions.TimeFreezeTask;
import com.gmail.kananen.miska.emissions.TimeSpeedupTask;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class Emissions
extends JavaPlugin {
    public World currentWorld;
    public Server server;
    public boolean isEmissionActive = false;
    public boolean isDamageActive = false;
    public ArrayList<SafeArea> safeAreas = new ArrayList();
    private Location pos1;
    private Location pos2;
    public Cover cover;
    public long timeWhenEmissionStarted;
    public final int EMISSION_TIME_FREEZE = 22900;
    private int minTimeBetweenEmissions = 0;
    private int maxTimeBetweenEmissions = 1;
    private int firstBlastWaveIgnitionChance = 0;
    private int secondBlastWaveIgnitionChance = 3;
    private BukkitTask thunderTask1;
    private BukkitTask damageTask;
    private BukkitTask backgroundRumbleTask;
    private BukkitTask coverInfoTask;
    private PlayerDamageListener dmgListener;
    private PlayerRespawnListener respawnListener;

    public void onEnable() {
        this.server = this.getServer();
        this.loadConfiguration();
        this.scheduleEmission(this.minTimeBetweenEmissions, this.maxTimeBetweenEmissions);
    }

    public void onDisable() {
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("emission")) {
            Player caller;
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("start")) {
                    if (sender instanceof Player) {
                        Player caller2 = (Player)sender;
                        if (this.isEmissionActive) {
                            this.sendMessage(caller2, "Emission is already incoming.");
                            return true;
                        }
                        this.currentWorld = caller2.getWorld();
                        this.sendMessage(caller2, "Emission called to world: " + this.currentWorld.getName());
                        this.callEmission(caller2.getWorld());
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("cancel") && sender instanceof Player) {
                    caller = (Player)sender;
                    if (this.isEmissionActive) {
                        this.cancelEmission();
                        this.sendMessage(caller, "Emission canceled.");
                    } else {
                        this.sendMessage(caller, "Nothing to cancel, no ongoing emissions.");
                    }
                }
                if ((args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) && sender instanceof Player) {
                    caller = (Player)sender;
                    this.sendMessage(caller, "/emission start - Starts an emission immediately");
                    this.sendMessage(caller, "/emission cancel - Cancels an ongoing emission.");
                    this.sendMessage(caller, "/emission pos1 - Select first corner");
                    this.sendMessage(caller, "/emission pos2 - Select second corner");
                    this.sendMessage(caller, "/emission addcover <name> - Define a safe place using selected corner positions");
                    this.sendMessage(caller, "/emission setworld - Selects the world where emissions occur.");
                    return true;
                }
                if (args[0].equalsIgnoreCase("pos1") && sender instanceof Player) {
                    caller = (Player)sender;
                    this.pos1 = caller.getTargetBlock(null, 256).getLocation();
                    this.sendMessage(caller, "Selected first corner");
                    return true;
                }
                if (args[0].equalsIgnoreCase("pos2") && sender instanceof Player) {
                    caller = (Player)sender;
                    this.pos2 = caller.getTargetBlock(null, 256).getLocation();
                    this.sendMessage(caller, "Selected second corner");
                    return true;
                }
                if (args[0].equalsIgnoreCase("addcover")) {
                    if (args.length > 1) {
                        if (sender instanceof Player) {
                            caller = (Player)sender;
                            if (this.pos1 == null || this.pos2 == null) {
                                this.sendMessage(caller, "Couldn't define cover, no corners selected.");
                                this.sendMessage(caller, "Use /emissions <pos1/pos2> to select an area.");
                            }
                            SafeArea sa = new SafeArea(this.pos1, this.pos2, args[1]);
                            this.safeAreas.add(sa);
                            this.saveSafeArea(sa);
                            this.sendMessage(caller, "Defined new cover: " + args[1]);
                            this.pos1 = null;
                            this.pos2 = null;
                            return true;
                        }
                    } else if (sender instanceof Player) {
                        caller = (Player)sender;
                        this.sendMessage(caller, "Usage: /emission addcover <name>");
                    }
                }
                if (args[0].equalsIgnoreCase("setworld") && sender instanceof Player) {
                    caller = (Player)sender;
                    this.getConfig().set("world", (Object)caller.getWorld().getName());
                    this.currentWorld = caller.getWorld();
                    this.sendMessage(caller, "World \"" + caller.getWorld().getName() + "\" enabled for emissions.");
                }
            }
            if (sender instanceof Player) {
                caller = (Player)sender;
                this.sendMessage(caller, "/emission help - Shows help for Emissions");
            }
            return true;
        }
        return false;
    }

    public void callEmission(World world) {
        if (this.isEmissionActive) {
            this.getLogger().info("[Emissions] Emission is already incoming!");
        }
        this.isEmissionActive = true;
        if (this.currentWorld == null) {
            this.getLogger().info("[Emissions] Couldn't start emission, no world defined.");
            return;
        }
        this.timeWhenEmissionStarted = world.getTime();
        this.server.getScheduler().cancelAllTasks();
        this.safeAreas.clear();
        this.loadSafeAreas();
        if (world.hasStorm()) {
            world.setStorm(false);
        }
        if (world.isThundering()) {
            world.setThundering(false);
        }
        this.darkenWeather();
        this.playCustomSoundToAllPlayers("blowout.start", 16);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.emissionFirstWarningPhase();
            }
        }.runTaskLater((Plugin)this, 500L);
    }

    public void cancelEmission() {
        this.server.getScheduler().cancelAllTasks();
        this.currentWorld.setTime(this.timeWhenEmissionStarted);
        this.isEmissionActive = false;
        this.isDamageActive = false;
        this.scheduleEmission(this.minTimeBetweenEmissions, this.maxTimeBetweenEmissions);
    }

    public void scheduleEmission(int minTicks, int maxTicks) {
        int ticksToStart = this.nextRandomInt(minTicks, maxTicks);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.callEmission(Emissions.this.currentWorld);
            }
        }.runTaskLater((Plugin)this, (long)ticksToStart);
    }

    private void emissionFirstWarningPhase() {
        this.sendMessageToAllPlayers("Attention Stalkers, an emission is approaching!", ChatColor.DARK_RED);
        this.playCustomSoundToAllPlayers("blowout.firstwarning", 4);
        this.cover = new Cover(this);
        this.coverInfoTask = new PlayerCoverInformationTask(this).runTaskTimer((Plugin)this, 0L, 20L);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.sendMessageToAllPlayers("Seek cover immediately!", ChatColor.DARK_RED);
                Emissions.this.shootFireworkFromAllSafeAreas(Color.YELLOW);
                Emissions.this.playCustomSoundToAllPlayers("blowout.siren", 16);
            }
        }.runTaskLater((Plugin)this, 80L);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.emissionFirstThunderStrike();
            }
        }.runTaskLater((Plugin)this, 300L);
    }

    private void emissionFirstThunderStrike() {
        Location[] thunderLocs;
        Location[] locationArray = thunderLocs = this.getEffectCenters(64.0);
        int n = thunderLocs.length;
        int n2 = 0;
        while (n2 < n) {
            Location fl = locationArray[n2];
            Location l = this.getRandomLocationCloseTo(fl, 20, 40);
            this.currentWorld.strikeLightningEffect(new Location(this.currentWorld, l.getX(), (double)this.currentWorld.getHighestBlockYAt(l), l.getZ()));
            ++n2;
        }
        this.backgroundRumbleTask = new BackgroundSoundTask(this, "blowout.rumble", 4).runTaskTimer((Plugin)this, 0L, 100L);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.emissionConstantThunder();
            }
        }.runTaskLater((Plugin)this, 100L);
    }

    private void emissionConstantThunder() {
        this.thunderTask1 = new ThunderTask(this, 10, 50).runTaskTimer((Plugin)this, 0L, 100L);
        BukkitTask thunderTask2 = new ThunderTask(this, 10, 50).runTaskTimer((Plugin)this, 0L, 140L);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.emissionFinalWarning();
            }
        }.runTaskLater((Plugin)this, 600L);
    }

    private void emissionFinalWarning() {
        this.sendMessageToAllPlayers("Attention Stalkers, an emission will start any minute now!", ChatColor.DARK_RED);
        this.shootFireworkFromAllSafeAreas(Color.RED);
        this.playCustomSoundToAllPlayers("blowout.secondwarning", 4);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.sendMessageToAllPlayers("Find cover if you want to live!", ChatColor.DARK_RED);
            }
        }.runTaskLater((Plugin)this, 80L);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.emissionStartDamage();
            }
        }.runTaskLater((Plugin)this, 400L);
    }

    private void emissionStartDamage() {
        this.damageTask = new EmissionDamageTask(this).runTaskTimer((Plugin)this, 0L, 20L);
        this.dmgListener = new PlayerDamageListener(this);
        this.respawnListener = new PlayerRespawnListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.dmgListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.respawnListener, (Plugin)this);
        this.isDamageActive = true;
        new BukkitRunnable(){

            public void run() {
                Emissions.this.emissionFirstBlastWave();
            }
        }.runTaskLater((Plugin)this, 300L);
    }

    private void emissionFirstBlastWave() {
        this.playCustomSoundToAllPlayers("blowout.particlewave", 8);
        Location[] centers = this.getEffectCenters(64.0);
        float waveSize = 8.0f;
        int speed = 3;
        Location[] locationArray = centers;
        int n = centers.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            new BlastWaveTask(this, l, 48, 48, waveSize, speed, this.firstBlastWaveIgnitionChance).runTaskTimer((Plugin)this, 0L, 10L);
            ++n2;
        }
        new BukkitRunnable(){

            public void run() {
                Emissions.this.emissionSecondBlastWave();
            }
        }.runTaskLater((Plugin)this, 900L);
    }

    private void emissionSecondBlastWave() {
        this.playCustomSoundToAllPlayers("blowout.particlewave", 8);
        Location[] centers = this.getEffectCenters(64.0);
        float waveSize = 10.0f;
        int speed = 4;
        Location[] locationArray = centers;
        int n = centers.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            new BlastWaveTask(this, l, 48, 48, waveSize, speed, this.secondBlastWaveIgnitionChance).runTaskTimer((Plugin)this, 0L, 10L);
            ++n2;
        }
        new BukkitRunnable(){

            public void run() {
                Emissions.this.emissionOver();
            }
        }.runTaskLater((Plugin)this, 500L);
    }

    private void emissionOver() {
        this.sendMessageToAllPlayers("Stalkers, the emission is finally over.", ChatColor.DARK_RED);
        this.playCustomSoundToAllPlayers("blowout.over", 4);
        this.playCustomSoundToAllPlayers("blowout.outro", 16);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.sendMessageToAllPlayers("I hope you're all in one piece.", ChatColor.DARK_RED);
            }
        }.runTaskLater((Plugin)this, 80L);
        this.damageTask.cancel();
        this.thunderTask1.cancel();
        this.backgroundRumbleTask.cancel();
        this.coverInfoTask.cancel();
        this.isDamageActive = false;
        EntityDamageEvent.getHandlerList().unregister((Listener)this.dmgListener);
        PlayerRespawnEvent.getHandlerList().unregister((Listener)this.respawnListener);
        new BukkitRunnable(){

            public void run() {
                Emissions.this.restoreLighting();
            }
        }.runTaskLater((Plugin)this, 400L);
    }

    private void restoreLighting() {
        this.server.getScheduler().cancelAllTasks();
        if (this.timeWhenEmissionStarted > 14500L && this.timeWhenEmissionStarted < 21800L) {
            this.currentWorld.setTime(12000L);
            new TimeSpeedupTask(this, 14500L, 4, false, false, 0L).runTaskTimer((Plugin)this, 0L, 1L);
        } else {
            new TimeSpeedupTask(this, 6000L, 4, false, false, 0L).runTaskTimer((Plugin)this, 0L, 1L);
        }
        this.currentWorld.setStorm(true);
        this.isEmissionActive = false;
        this.scheduleEmission(this.minTimeBetweenEmissions, this.maxTimeBetweenEmissions);
    }

    public void darkenWeather() {
        int EMISSION_START_TIME = 21800;
        int SPEED_MULTIPLIER = 4;
        long currentTime = this.currentWorld.getTime();
        if (currentTime > 14500L && currentTime < 21800L) {
            this.currentWorld.setTime(21800L);
            this.freezeTime();
        }
        if (currentTime > 0L && currentTime < 11250L) {
            this.currentWorld.setTime(11250L);
            new TimeSpeedupTask(this, 14500L, 4, false, true, 21800L).runTaskTimer((Plugin)this, 0L, 1L);
        }
        if (currentTime > 11250L && currentTime < 14500L) {
            new TimeSpeedupTask(this, 14500L, 4, false, true, 21800L).runTaskTimer((Plugin)this, 0L, 1L);
        }
        if (currentTime > 21800L && currentTime < 24000L) {
            new TimeSpeedupTask(this, 21800L, 4, true, false, 0L).runTaskTimer((Plugin)this, 0L, 1L);
        }
    }

    public void freezeTime() {
        BukkitTask timeFreezeTask = new TimeFreezeTask(this, 22900L, 2).runTaskTimer((Plugin)this, 0L, 2L);
    }

    public int nextRandomInt(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public void playCustomSoundToAllPlayers(String sound, int range) {
        for (Entity e : this.currentWorld.getEntities()) {
            if (!(e instanceof Player)) continue;
            Player p = (Player)e;
            p.playSound(p.getLocation(), sound, (float)range, 1.0f);
        }
    }

    public void sendMessage(Player p, String message, ChatColor color) {
        p.sendMessage(color + "[Emissions] " + message);
    }

    public void sendMessage(Player p, String message) {
        p.sendMessage("[Emissions] " + message);
    }

    public void sendMessageToAllPlayers(String message, ChatColor color) {
        Bukkit.broadcastMessage((String)(color + "[Emissions] " + message));
    }

    public void sendMessageToAllPlayers(String message) {
        Bukkit.broadcastMessage((String)("[Emissions] " + message));
    }

    public void shootFireworkFromAllSafeAreas(Color c) {
        for (SafeArea sa : this.safeAreas) {
            Location pos = this.getCenterTop(sa);
            Location finalPos = new Location(pos.getWorld(), (double)pos.getBlockX(), (double)(pos.getBlockY() + 2), (double)pos.getBlockZ());
            Firework fw = (Firework)this.currentWorld.spawnEntity(finalPos, EntityType.FIREWORK);
            FireworkMeta fwm = fw.getFireworkMeta();
            fwm.setPower(2);
            FireworkEffect effect = FireworkEffect.builder().flicker(false).withColor(c).with(FireworkEffect.Type.BALL_LARGE).trail(true).build();
            fwm.addEffect(effect);
            fw.setFireworkMeta(fwm);
        }
    }

    public Location getRandomLocationCloseTo(Location location, int minDistance, int maxDistance) {
        Location random = new Location(this.currentWorld, location.getX(), location.getY(), location.getZ());
        int xChange = this.nextRandomInt(minDistance, maxDistance);
        int yChange = this.nextRandomInt(minDistance, maxDistance);
        int zChange = this.nextRandomInt(minDistance, maxDistance);
        int xPosNeg = this.nextRandomInt(0, 2);
        int yPosNeg = this.nextRandomInt(0, 2);
        int zPosNeg = this.nextRandomInt(0, 2);
        if (xPosNeg == 0) {
            random.setX(random.getX() + (double)xChange);
        } else {
            random.setX(random.getX() - (double)xChange);
        }
        if (yPosNeg == 0) {
            random.setY(random.getY() + (double)yChange);
        } else {
            random.setY(random.getY() - (double)yChange);
        }
        if (zPosNeg == 0) {
            random.setZ(random.getZ() + (double)zChange);
        } else {
            random.setZ(random.getZ() - (double)zChange);
        }
        return random;
    }

    public Location getRandomLocationCloseTo(Location location, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        Location random = new Location(this.currentWorld, location.getX(), location.getY(), location.getZ());
        int xChange = this.nextRandomInt(minX, maxX);
        int yChange = this.nextRandomInt(minY, maxY);
        int zChange = this.nextRandomInt(minZ, maxZ);
        int xPosNeg = this.nextRandomInt(0, 2);
        int yPosNeg = this.nextRandomInt(0, 2);
        int zPosNeg = this.nextRandomInt(0, 2);
        if (xPosNeg == 0) {
            random.setX(random.getX() + (double)xChange);
        } else {
            random.setX(random.getX() - (double)xChange);
        }
        if (yPosNeg == 0) {
            random.setY(random.getY() + (double)yChange);
        } else {
            random.setY(random.getY() - (double)yChange);
        }
        if (zPosNeg == 0) {
            random.setZ(random.getZ() + (double)zChange);
        } else {
            random.setZ(random.getZ() - (double)zChange);
        }
        return random;
    }

    public Object[] getUnobstructedPosInArea(SafeArea area) {
        Location loc = new Location(this.currentWorld, 0.0, 0.0, 0.0);
        int startingX = Math.min(area.getFirstCorner().getBlockX(), area.getSecondCorner().getBlockX());
        int startingY = Math.min(area.getFirstCorner().getBlockY(), area.getSecondCorner().getBlockY());
        int startingZ = Math.min(area.getFirstCorner().getBlockZ(), area.getSecondCorner().getBlockZ());
        int endingX = Math.max(area.getFirstCorner().getBlockX(), area.getSecondCorner().getBlockX());
        int endingY = Math.max(area.getFirstCorner().getBlockY(), area.getSecondCorner().getBlockY());
        int endingZ = Math.max(area.getFirstCorner().getBlockZ(), area.getSecondCorner().getBlockZ());
        Boolean found = false;
        int y = startingY;
        while (y <= endingY) {
            int z = startingZ;
            while (z <= endingZ) {
                int x = startingX;
                while (x <= endingX) {
                    loc = new Location(this.currentWorld, (double)x, (double)y, (double)z);
                    if (this.currentWorld.getBlockAt(loc).getType() == Material.AIR && this.currentWorld.getBlockAt(new Location(this.currentWorld, (double)loc.getBlockX(), (double)(loc.getBlockY() + 1), (double)loc.getBlockZ())).getType() == Material.AIR) {
                        found = true;
                        loc = new Location(this.currentWorld, (double)loc.getBlockX() + 0.5, (double)loc.getBlockY(), (double)loc.getBlockZ() + 0.5);
                        break;
                    }
                    ++x;
                }
                if (found.booleanValue()) break;
                ++z;
            }
            if (found.booleanValue()) break;
            ++y;
        }
        if (!found.booleanValue()) {
            loc = this.getCenterTop(area);
            Object[] ret = new Object[]{loc, false};
            return ret;
        }
        Object[] ret = new Object[]{loc, true};
        return ret;
    }

    public Location getCenterTop(SafeArea area) {
        double averageX = (area.getFirstCorner().getBlockX() + area.getSecondCorner().getBlockX()) / 2;
        double averageZ = (area.getFirstCorner().getBlockZ() + area.getSecondCorner().getBlockZ()) / 2;
        double topY = this.currentWorld.getHighestBlockYAt((int)averageX, (int)averageZ);
        return new Location(this.currentWorld, averageX, topY, averageZ);
    }

    public Location getCenter(SafeArea area) {
        double averageX = (area.getFirstCorner().getBlockX() + area.getSecondCorner().getBlockX()) / 2;
        double averageZ = (area.getFirstCorner().getBlockZ() + area.getSecondCorner().getBlockZ()) / 2;
        double averageY = (area.getFirstCorner().getBlockY() + area.getSecondCorner().getBlockY()) / 2;
        return new Location(this.currentWorld, averageX, averageY, averageZ);
    }

    public Location[] getEffectCenters(double minimumDistance) {
        ArrayList playersClose = new ArrayList();
        for (Entity e : this.currentWorld.getEntities()) {
            if (!(e instanceof Player)) continue;
            Player p = (Player)e;
            if (playersClose.size() == 0) {
                playersClose.add(new ArrayList());
                ((ArrayList)playersClose.get(0)).add(p.getLocation());
                continue;
            }
            int i = 0;
            while (i < playersClose.size()) {
                ArrayList locList = (ArrayList)playersClose.get(i);
                if (p.getLocation().distance((Location)locList.get(0)) < minimumDistance) {
                    locList.add(p.getLocation());
                } else if (playersClose.indexOf(locList) == playersClose.size() - 1) {
                    playersClose.add(new ArrayList());
                    ((ArrayList)playersClose.get(playersClose.size() - 1)).add(p.getLocation());
                }
                ++i;
            }
        }
        if (playersClose.size() == 0) {
            Location[] emptyLocs = new Location[]{new Location(this.currentWorld, 0.0, 64.0, 0.0)};
        }
        ArrayList<Location> effectCenters = new ArrayList<Location>();
        for (ArrayList arrayList : playersClose) {
            Location average = new Location(((Location)arrayList.get(0)).getWorld(), 0.0, 0.0, 0.0);
            int summedTogether = 0;
            for (Location loc : arrayList) {
                average.add(loc);
                ++summedTogether;
            }
            if (summedTogether == 0) continue;
            effectCenters.add(new Location(average.getWorld(), average.getX() / (double)summedTogether, average.getY() / (double)summedTogether, average.getZ() / (double)summedTogether));
        }
        return effectCenters.toArray(new Location[effectCenters.size()]);
    }

    public void loadConfiguration() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        if (this.getConfig().getString("world") != "") {
            this.currentWorld = this.server.getWorld(this.getConfig().getString("world"));
        }
        this.minTimeBetweenEmissions = this.getConfig().getInt("min-time-between-emissions");
        this.maxTimeBetweenEmissions = this.getConfig().getInt("max-time-between-emissions");
        this.firstBlastWaveIgnitionChance = this.getConfig().getInt("first-blastwave-ignition-chance");
        this.secondBlastWaveIgnitionChance = this.getConfig().getInt("second-blastwave-ignition-chance");
    }

    public void saveSafeArea(SafeArea area) {
        this.getConfig().set("safeareas." + area.getName() + ".firstcorner.x", (Object)area.getFirstCorner().getBlockX());
        this.getConfig().set("safeareas." + area.getName() + ".firstcorner.y", (Object)area.getFirstCorner().getBlockY());
        this.getConfig().set("safeareas." + area.getName() + ".firstcorner.z", (Object)area.getFirstCorner().getBlockZ());
        this.getConfig().set("safeareas." + area.getName() + ".secondcorner.x", (Object)area.getSecondCorner().getBlockX());
        this.getConfig().set("safeareas." + area.getName() + ".secondcorner.y", (Object)area.getSecondCorner().getBlockY());
        this.getConfig().set("safeareas." + area.getName() + ".secondcorner.z", (Object)area.getSecondCorner().getBlockZ());
        this.saveConfig();
    }

    public void loadSafeAreas() {
        ConfigurationSection keySection = this.getConfig().getConfigurationSection("safeareas.");
        if (keySection == null) {
            return;
        }
        Set keys = keySection.getKeys(false);
        if (keys == null) {
            return;
        }
        for (String currentArea : keys) {
            int x1 = this.getConfig().getInt("safeareas." + currentArea + ".firstcorner.x");
            int y1 = this.getConfig().getInt("safeareas." + currentArea + ".firstcorner.y");
            int z1 = this.getConfig().getInt("safeareas." + currentArea + ".firstcorner.z");
            int x2 = this.getConfig().getInt("safeareas." + currentArea + ".secondcorner.x");
            int y2 = this.getConfig().getInt("safeareas." + currentArea + ".secondcorner.y");
            int z2 = this.getConfig().getInt("safeareas." + currentArea + ".secondcorner.z");
            Location loc1 = new Location(this.currentWorld, (double)x1, (double)y1, (double)z1);
            Location loc2 = new Location(this.currentWorld, (double)x2, (double)y2, (double)z2);
            SafeArea sa = new SafeArea(loc1, loc2, currentArea);
            this.safeAreas.add(sa);
        }
    }
}

