precision lowp float;
uniform sampler2D mixerTex;
uniform float iGlobalTime;
uniform vec2 iResolution;
vec2 iMouse = vec2(sin(iGlobalTime*0.1),0.7);struct polygon{
    vec2 A, B, C;
};
float roundBox(vec2 coord, vec2 pos, vec2 b ){
  return length(max(abs(coord-pos)-b,0.0));
}
float box(vec2 coord, vec2 pos, vec2 size){
    if((coord.x<(pos.x+size.x)) &&
       (coord.x>(pos.x-size.x)) &&
       (coord.y<(pos.y+size.y)) && 
       (coord.y>(pos.y-size.y)) ) 
        return 1.0;
    return 0.0;
}
float sun(vec2 coord, vec2 pos, float size){
    if(length(coord-pos)<size)
        return 1.0;
    return 0.0;
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float sign(vec2 p1, vec2 p2, vec2 p3){
  return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
}

mat2 rotate(float Angle)
{
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float sdCapsule( vec2 p, vec2 a, vec2 b, float r ){
    vec2 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return min(floor(length( pa - ba*h ) - r),0.);
}
float triangle( vec2 coord, vec2 pos, float angle, float thick, float size){
    vec2 original_coord = coord;
    coord += pos;
    coord *= rotate(angle);
    float collision = 0.0;
    collision += sdCapsule( coord, vec2( 0.0, 0.333)*size, vec2( 0.3,-0.2)*size, thick );
    collision += sdCapsule( coord, vec2( 0.0, 0.333)*size, vec2(-0.3,-0.2)*size, thick );
    collision += sdCapsule( coord, vec2( 0.3,-0.2)*size, vec2(-0.3,-0.2)*size, thick );
    collision += 3.0*texture2D( mixerTex, original_coord * 0.6 + vec2(iGlobalTime*0.02) ).b * 0.6;
    collision += 2.5*texture2D( mixerTex, original_coord * 0.1 + vec2(iGlobalTime*0.001) ).b * 0.4;
    return -min(max(-collision,0.0),1.0);
}




float smin( float a, float b, float k ){
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
mat3 rotY(in float a) {
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}
float udRoundBox( vec3 p, vec3 b, float r ){
  return length(max(abs(p)-b,0.0))-r;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float sdBox( vec3 p, vec3 b ){
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float sdCapsule( vec3 p, vec3 a, vec3 b, float r ){
    vec3 pa = p - a , ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
float sdPlane( vec3 p, vec4 n )
{
  // n must be normalized
  return dot(p,n.xyz) + n.w;
}

void objectGroup0(in vec3 p, out vec3 color, out float reflectiveValue, out float finalDistance){
    vec3 p2=p;
    p2*=rotY(-0.7+iGlobalTime/33.);
    vec4 tex = texture2D(mixerTex,vec2(atan(p2.x,p2.z)*3.1415*1.5,p2.y/4.+0.3)*0.09*3.141+vec2(0.14));

    reflectiveValue = 0.8;
    color = tex.brg;  
    
    finalDistance= min(finalDistance,sdSphere( p2, 7.8+tex.r*0.02));
    
    
    
}


float calculateDistance(in vec3 p, out vec3 color, out float reflectiveValue) {
    float finalDistance = 10000000.;
    
    objectGroup0(p,color,reflectiveValue,finalDistance);
    return finalDistance;
}

float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource){
    vec3 ro = rayPosition + normalVector*0.001;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.01;
    float k = 1.6;
    float res = 1.0;
    for( int i=0; i<32; i++ )
    {
        vec3 C;
        float dummy;
        float h = calculateDistance(ro + rd*t, C, dummy);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.001 ) break;
            if( length(ro + rd*t)>11.) break;
    }
    return clamp(res,0.1,1.0);
}

vec3 tracer(vec3 rayStartPosition, vec3 rayDirection) {
    const float epsilon = 0.004;
    
    vec3 rayPosition = rayStartPosition;

    vec3 normalVector;
    float dist = 0.0;
    vec3 returnColor = vec3(0.0);
    vec3 finalColor = vec3(0.0);
    vec3 lightSource = 22.0*vec3(sin(2.*iGlobalTime/12.),1.0,cos(2.*iGlobalTime/12.)) ;
    float reflectiveValue = 1.0;
    float reflectionNow = 0.0;
    float finalLight = 1.0;
    
    float possibleFogLight = 1.0;
    
    for(float k=0.; k<3.; k++) {
        for(float i=0.; i<66.; i++) {
            vec3 color;
            float stepable = calculateDistance(rayPosition, color, reflectiveValue);
            dist += stepable;
            rayPosition = rayStartPosition + dist * rayDirection;
            
            if( length(rayPosition)>11.){

                vec3 lightDir = (lightSource-rayStartPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(rayDirection, lightDir);
                returnColor+=max( pow(directLight,15.1) * vec3(1.7,1.1,.9) * 2.8, 0.0);
                
                return returnColor;
            }
           
                vec3 lightDir = (lightSource-rayStartPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(rayDirection, lightDir);
                returnColor+=max(0.1*max( pow(directLight,15.1) * vec3(1.7,1.1,.9) * 1.8, 0.0),vec3(0.0002));
            
            if( abs(stepable) <= epsilon){
                vec3 C;
                float dummy = 0.0;
                normalVector = vec3(    calculateDistance(rayPosition+vec3(epsilon,0,0),C,dummy)-calculateDistance(rayPosition+vec3(-epsilon,0,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,epsilon,0),C,dummy)-calculateDistance(rayPosition+vec3(0,-epsilon,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,0,epsilon),C,dummy)-calculateDistance(rayPosition+vec3(0,0,-epsilon),C,dummy));
                normalVector = normalize(normalVector);
                float light = traceToLight(rayPosition, normalVector, lightSource);
                finalLight = min(finalLight, light);
                float lightDistance = distance(rayStartPosition,lightSource);
                
                finalColor = color * vec3(dot(normalVector, -rayDirection));
                
                
                vec3 lightDir = (lightSource-rayPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(normalVector, lightDir);
                reflectionNow = max(reflectionNow,reflectiveValue);
                
                
                returnColor += ( vec3(finalLight*max(1.5*directLight*vec3(1.7,1.1,0.9),0.01)) / (k*0.8/reflectionNow + 1.0)) * finalColor;
               
                break;
                
            }
        }
        dist = 0.0;
        rayStartPosition = rayPosition + normalVector;
        rayPosition = rayStartPosition;
        rayDirection = reflect(rayDirection, normalVector);
    } 
                vec3 lightDir = (lightSource-rayStartPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(rayDirection, lightDir);
                returnColor+=max( pow(directLight,12.1) * vec3(1.7,1.1,.9) * 2.8, 0.0);
                
    return returnColor;
}

vec3 piip() {
    vec3 cameraPosition = vec3( 0., 0., -18.+2.*iGlobalTime/10.);
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    
    float aspect = iResolution.x / iResolution.y;
        vec3 direction = normalize(vec3(.5 * uv * vec2(aspect, 1.0), 1. ));
        direction.yxz *= rotY(0.4-2.*iGlobalTime/75.);
        cameraPosition *= rotY(-2.*iGlobalTime/48.);
        direction *= rotY(-2.*iGlobalTime/48.);
        return tracer(cameraPosition, direction);
}











void main( ){
    
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.x / iResolution.y;
        gl_FragColor = vec4(min(iGlobalTime/8.,1.)*piip()/1.4,1.);
}

