/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PShape;
import processing.opengl.PShader;

public class gluster_graffathon_2015
extends PApplet {
    int CANVAS_WIDTH = 1280;
    int CANVAS_HEIGHT = 720;
    float ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
    float TEMPO = 123.0f;
    float BEAT_DURATION = 60.0f / this.TEMPO;
    int SKIP_DURATION = gluster_graffathon_2015.round((float)(4000.0f * this.BEAT_DURATION));
    float PREDELAY_DURATION = 0.0f;
    Timeline timeline;
    boolean predelay = true;

    public float beatsToSecs(float f) {
        return f * this.BEAT_DURATION;
    }

    public void setup() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        this.timeline = new Timeline((Object)this, "data/Vector Space Odyssey.mp3");
        this.timeline.addScene(new SnowflakeScene(64.0f, false));
        this.timeline.addScene(new CylinderScene(32.0f, false));
        this.timeline.addScene(new StairsScene2(32.0f));
        this.timeline.addScene(new ShadertoyScene(64.0f, "data/tunnel.frag"));
        this.timeline.addScene(new RobotikScene(32.0f, false));
        this.timeline.addScene(new RotatingObjectScene(36.0f));
        this.timeline.addScene(new RobotikScene(32.0f, true));
        this.timeline.addScene(new CylinderScene(32.0f, true));
        this.timeline.addScene(new GreezScene(32.0f));
        this.timeline.addScene(new CreditsScene(32.0f));
        this.timeline.addScene(new SnowflakeScene(64.0f, true));
        this.frameRate(60.0f);
        this.background(0);
        this.fill(255);
        this.smooth();
    }

    public void keyPressed() {
        if (this.predelay) {
            return;
        }
        if (this.key == '\uffff') {
            boolean bl;
            boolean bl2 = this.keyCode == 37;
            boolean bl3 = bl = this.keyCode == 39;
            if (bl2 || bl) {
                this.timeline.song.skip((bl2 ? -1 : 1) * this.SKIP_DURATION);
            }
        } else if (this.key == ' ') {
            if (this.timeline.song.isPlaying()) {
                this.timeline.song.pause();
            } else {
                this.timeline.song.play();
            }
        }
    }

    public void draw() {
        if (this.predelay) {
            if (0.001f * (float)this.millis() < this.PREDELAY_DURATION) {
                return;
            }
            this.predelay = false;
            float f = 0.0f;
            this.timeline.song.play(gluster_graffathon_2015.round((float)(f * 1000.0f * this.BEAT_DURATION)));
        }
        this.timeline.drawScene();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "gluster_graffathon_2015"};
        if (stringArray != null) {
            PApplet.main((String[])gluster_graffathon_2015.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class BlankScene
    extends Scene {
        public BlankScene(float f) {
            super(f);
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.background(0);
        }
    }

    class CreditsScene
    extends Scene {
        public PShader shader;

        public CreditsScene(float f) {
            super(f);
            gluster_graffathon_2015.this.resetShader();
            this.shader = gluster_graffathon_2015.this.loadShader("noise.glsl");
            this.shader.set("iResolution", PApplet.parseFloat((int)gluster_graffathon_2015.this.CANVAS_WIDTH), PApplet.parseFloat((int)gluster_graffathon_2015.this.CANVAS_HEIGHT));
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.noStroke();
            gluster_graffathon_2015.this.fill(255);
            gluster_graffathon_2015.this.smooth();
        }

        public void effectMatrix(int n) {
            String[] stringArray = new String[]{"Credits", "", "code", "{", "Kitai", "ahihi", "Lumian", "}", "", "music", "{", "ahihi", "}", "", "@ Graffathon 2015"};
            float[] fArray = new float[]{1.0f, 0.0f, 1.5f, 1.25f, 1.0f, 1.5f, 1.0f, 1.25f, 0.0f, 1.5f, 1.25f, 1.5f, 1.25f, 1.0f, 1.0f};
            gluster_graffathon_2015.this.pushMatrix();
            gluster_graffathon_2015.this.scale(0.003f);
            gluster_graffathon_2015.this.rotateX(gluster_graffathon_2015.radians((float)180.0f));
            gluster_graffathon_2015.this.fill(255.0f, 255.0f, 255.0f, 80.0f + 50.0f * gluster_graffathon_2015.sin((float)((float)n * 0.001f)));
            gluster_graffathon_2015.this.noStroke();
            gluster_graffathon_2015.this.textSize(40.0f);
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3 = 0;
                while (n3 < stringArray[n2].length()) {
                    float f = gluster_graffathon_2015.this.random(10.0f);
                    if (f < 7.0f) {
                        gluster_graffathon_2015.this.text(stringArray[n2].charAt(n3), (float)(n2 * 50) + gluster_graffathon_2015.sin((float)((float)n * 0.001f)), (float)(n3 * 40 - 300) + 300.0f * gluster_graffathon_2015.sin((float)((float)n * 1.0E-4f * fArray[n2])), 0.0f);
                    } else {
                        gluster_graffathon_2015.this.text((char)PApplet.parseInt((float)gluster_graffathon_2015.this.random(33.0f, 127.0f)), (float)(n2 * 50) + gluster_graffathon_2015.sin((float)((float)n * 0.001f)), (float)(n3 * 40 - 300) + 300.0f * gluster_graffathon_2015.sin((float)((float)n * 1.0E-4f * fArray[n2])), 0.0f);
                    }
                    ++n3;
                }
                ++n2;
            }
            gluster_graffathon_2015.this.popMatrix();
        }

        @Override
        public void draw(float f) {
            gluster_graffathon_2015.this.clear();
            gluster_graffathon_2015.this.pushMatrix();
            gluster_graffathon_2015.this.translate(0.0f, (float)gluster_graffathon_2015.this.CANVAS_HEIGHT / 2.0f, -800.0f);
            gluster_graffathon_2015.this.scale(1.5f * ((float)gluster_graffathon_2015.this.CANVAS_WIDTH / 2.0f) / gluster_graffathon_2015.this.ASPECT_RATIO, (float)(-gluster_graffathon_2015.this.CANVAS_HEIGHT) / 2.0f);
            this.effectMatrix((int)(f * 1000.0f));
            this.shader.set("iGlobalTime", gluster_graffathon_2015.this.beatsToSecs(f));
            gluster_graffathon_2015.this.shader(this.shader);
            gluster_graffathon_2015.this.rectMode(3);
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
            gluster_graffathon_2015.this.resetShader();
            gluster_graffathon_2015.this.popMatrix();
        }
    }

    class CylinderScene
    extends Scene {
        PShader stardust;
        PShape cylinder;
        PImage texture;
        boolean shakeIt;

        public CylinderScene(float f, boolean bl) {
            super(f);
            this.stardust = gluster_graffathon_2015.this.loadShader("stardust.glsl");
            this.stardust.set("iResolution", (float)gluster_graffathon_2015.this.width, (float)gluster_graffathon_2015.this.height);
            this.cylinder = gluster_graffathon_2015.this.loadShape("AbstractSylinder.obj");
            this.texture = gluster_graffathon_2015.this.loadImage("sheetmetal.jpg");
            this.shakeIt = bl;
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.noStroke();
            gluster_graffathon_2015.this.textureWrap(1);
            gluster_graffathon_2015.this.textureMode(1);
        }

        @Override
        public void draw(float f) {
            float f2 = gluster_graffathon_2015.this.beatsToSecs(f);
            gluster_graffathon_2015.this.pushMatrix();
            gluster_graffathon_2015.this.clear();
            gluster_graffathon_2015.this.rectMode(0);
            gluster_graffathon_2015.this.shader(this.stardust);
            this.stardust.set("iGlobalTime", f2);
            gluster_graffathon_2015.this.hint(2);
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.width, gluster_graffathon_2015.this.height);
            gluster_graffathon_2015.this.hint(-2);
            gluster_graffathon_2015.this.resetShader();
            gluster_graffathon_2015.this.beginCamera();
            gluster_graffathon_2015.this.camera(0.0f, 0.0f, 14.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            float f3 = 1.0471976f;
            float f4 = (float)gluster_graffathon_2015.this.height / 2.0f / gluster_graffathon_2015.tan((float)(f3 / 2.0f));
            gluster_graffathon_2015.this.perspective(f3, PApplet.parseFloat((int)gluster_graffathon_2015.this.width) / PApplet.parseFloat((int)gluster_graffathon_2015.this.height), f4 / 100.0f, f4 * 10.0f);
            gluster_graffathon_2015.this.directionalLight(126.0f, 126.0f, 126.0f, 0.0f, 0.0f, -1.0f);
            gluster_graffathon_2015.this.ambientLight(102.0f, 102.0f, 102.0f);
            gluster_graffathon_2015.this.pushMatrix();
            if (this.shakeIt) {
                gluster_graffathon_2015.this.translate(0.0f, gluster_graffathon_2015.sin((float)(f2 * 150.0f)) * 0.1f, 0.0f);
            }
            if (this.shakeIt && f2 > 5.0f && f2 < 6.0f) {
                gluster_graffathon_2015.this.translate(gluster_graffathon_2015.sin((float)(f2 * 200.0f)) * 0.5f, 0.0f, 0.0f);
            }
            if (this.shakeIt && f2 > 10.0f && f2 < 12.0f) {
                gluster_graffathon_2015.this.translate(gluster_graffathon_2015.sin((float)(f2 * 200.0f)) * 0.5f, 0.0f, gluster_graffathon_2015.sin((float)(f2 * 200.0f)) * 0.25f);
            }
            if (this.shakeIt && f2 > 12.0f) {
                gluster_graffathon_2015.this.translate(gluster_graffathon_2015.sin((float)(f2 * 200.0f)) * 0.7f, gluster_graffathon_2015.sin((float)(f2 * 200.0f)) * 0.5f, gluster_graffathon_2015.sin((float)(f2 * 200.0f)) * 0.3f);
            }
            gluster_graffathon_2015.this.rotateZ(1.5707964f);
            gluster_graffathon_2015.this.rotateX(-5.8f);
            gluster_graffathon_2015.this.rotateY(f2 * 0.5f);
            gluster_graffathon_2015.this.beginShape();
            gluster_graffathon_2015.this.texture(this.texture);
            gluster_graffathon_2015.this.tint(0.0f, 153.0f, 204.0f);
            gluster_graffathon_2015.this.shape(this.cylinder);
            gluster_graffathon_2015.this.endShape();
            gluster_graffathon_2015.this.popMatrix();
            gluster_graffathon_2015.this.endCamera();
            gluster_graffathon_2015.this.popMatrix();
            if (!this.shakeIt) {
                float f5 = gluster_graffathon_2015.max((float)0.0f, (float)gluster_graffathon_2015.min((float)1.0f, (float)(1.0f - f / 8.0f)));
                gluster_graffathon_2015.this.fill(0.0f, 0.0f, 0.0f, f5 * 255.0f);
                gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
            }
        }
    }

    class GreezScene
    extends Scene {
        PShader sprunge;

        public GreezScene(float f) {
            super(f);
            this.sprunge = gluster_graffathon_2015.this.loadShader("sprunge.glsl");
            this.sprunge.set("iResolution", (float)gluster_graffathon_2015.this.width, (float)gluster_graffathon_2015.this.height);
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.rectMode(0);
            gluster_graffathon_2015.this.stroke(0);
        }

        @Override
        public void draw(float f) {
            boolean bl;
            gluster_graffathon_2015.this.clear();
            gluster_graffathon_2015.this.shader(this.sprunge);
            String[] stringArray = new String[]{"Peisik", "REN", "Epoch", "pants^", "Paraguay", "Mercury", "firebug\nsooda", "DOT"};
            int n = gluster_graffathon_2015.floor((float)(0.25f * f));
            boolean bl2 = 0.0f <= f && f < 2.0f;
            boolean bl3 = bl = f % 4.0f >= 3.0f;
            if (bl) {
                this.sprunge.set("iSaturation", 0.0f);
            } else {
                this.sprunge.set("iSaturation", 1.0f);
            }
            this.sprunge.set("iGlobalTime", gluster_graffathon_2015.this.beatsToSecs(f));
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.width, gluster_graffathon_2015.this.height);
            gluster_graffathon_2015.this.resetShader();
            int cfr_ignored_0 = stringArray.length;
            gluster_graffathon_2015.this.fill(255.0f, 0.0f, 100.0f);
            gluster_graffathon_2015.this.textSize(32.0f);
            gluster_graffathon_2015.this.textAlign(3, 3);
            String string = "";
            if (bl) {
                string = stringArray[n];
            } else if (bl2) {
                string = "<3";
                gluster_graffathon_2015.this.fill(200);
            }
            gluster_graffathon_2015.this.text(string, (float)gluster_graffathon_2015.this.width / 2.0f, (float)gluster_graffathon_2015.this.height / 2.0f, 0.0f);
        }
    }

    class RobotikScene
    extends ShadertoyScene {
        public boolean rotate;

        public RobotikScene(float f, boolean bl) {
            super(f, "data/robotik.frag");
            this.rotate = bl;
        }

        @Override
        public void draw(float f) {
            gluster_graffathon_2015.this.clear();
            gluster_graffathon_2015.this.shader(this.shader);
            this.shader.set("iResolution", PApplet.parseFloat((int)gluster_graffathon_2015.this.CANVAS_WIDTH), PApplet.parseFloat((int)gluster_graffathon_2015.this.CANVAS_HEIGHT));
            this.shader.set("iBeats", f);
            this.shader.set("iGlobalTime", gluster_graffathon_2015.this.beatsToSecs(f));
            this.shader.set("iRotate", this.rotate);
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
            gluster_graffathon_2015.this.resetShader();
        }
    }

    class RotatingObjectScene
    extends Scene {
        PShader shader;
        PShader shader2;
        PShape metalObject;

        public RotatingObjectScene(float f) {
            super(f);
            gluster_graffathon_2015.this.resetShader();
            this.metalObject = gluster_graffathon_2015.this.loadShape("metalObject.obj");
            this.shader = gluster_graffathon_2015.this.loadShader("lines.glsl");
            this.shader2 = gluster_graffathon_2015.this.loadShader("shaderLumian.glsl");
            this.shader.set("iResolution", (float)gluster_graffathon_2015.this.CANVAS_WIDTH, (float)gluster_graffathon_2015.this.CANVAS_HEIGHT);
            this.shader2.set("iResolution", (float)gluster_graffathon_2015.this.CANVAS_WIDTH, (float)gluster_graffathon_2015.this.CANVAS_HEIGHT);
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.noStroke();
        }

        @Override
        public void draw(float f) {
            gluster_graffathon_2015.this.clear();
            int n = gluster_graffathon_2015.round((float)(gluster_graffathon_2015.this.beatsToSecs(f) * 1000.0f));
            gluster_graffathon_2015.this.pushMatrix();
            gluster_graffathon_2015.this.translate(gluster_graffathon_2015.this.CANVAS_WIDTH / 2, gluster_graffathon_2015.this.CANVAS_HEIGHT / 2, -0.5f * (float)gluster_graffathon_2015.this.CANVAS_WIDTH);
            gluster_graffathon_2015.this.lights();
            if (f % 2.0f < 1.0f) {
                gluster_graffathon_2015.this.scale(24.0f);
            } else {
                gluster_graffathon_2015.this.scale(20.0f);
            }
            this.shader.set("iGlobalTime", gluster_graffathon_2015.this.beatsToSecs(f));
            this.shader2.set("iGlobalTime", gluster_graffathon_2015.this.beatsToSecs(f));
            gluster_graffathon_2015.this.rotateX(gluster_graffathon_2015.sin((float)((float)n * 0.001f)));
            gluster_graffathon_2015.this.rotateY(gluster_graffathon_2015.cos((float)((float)n * 1.0E-4f)));
            gluster_graffathon_2015.this.rotateZ(gluster_graffathon_2015.sin((float)((float)n * 1.0E-4f)) * gluster_graffathon_2015.cos((float)((float)n * 0.001f)));
            gluster_graffathon_2015.this.translate(30.0f * gluster_graffathon_2015.sin((float)((float)n * 0.001f)), 30.0f * gluster_graffathon_2015.cos((float)((float)n * 0.001f)), 0.7f * gluster_graffathon_2015.sin((float)((float)n * 0.01f)));
            gluster_graffathon_2015.this.shader(this.shader2);
            gluster_graffathon_2015.this.shape(this.metalObject, 0.0f, 0.0f);
            gluster_graffathon_2015.this.resetShader();
            gluster_graffathon_2015.this.popMatrix();
            gluster_graffathon_2015.this.shader(this.shader);
            gluster_graffathon_2015.this.fill(100.0f, 100.0f, 100.0f, 0.5f);
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
            gluster_graffathon_2015.this.resetShader();
        }
    }

    abstract class Scene {
        public float duration;

        public Scene(float f) {
            this.duration = f;
        }

        public void setup() {
        }

        public void draw(float f) {
        }
    }

    class ShadertoyScene
    extends Scene {
        public PShader shader;

        public ShadertoyScene(float f, String string) {
            super(f);
            this.shader = gluster_graffathon_2015.this.loadShader(string);
            gluster_graffathon_2015.this.shader(this.shader);
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.fill(255);
            gluster_graffathon_2015.this.rectMode(0);
        }

        @Override
        public void draw(float f) {
            gluster_graffathon_2015.this.clear();
            gluster_graffathon_2015.this.shader(this.shader);
            this.shader.set("iResolution", PApplet.parseFloat((int)gluster_graffathon_2015.this.CANVAS_WIDTH), PApplet.parseFloat((int)gluster_graffathon_2015.this.CANVAS_HEIGHT));
            this.shader.set("iBeats", f);
            this.shader.set("iGlobalTime", gluster_graffathon_2015.this.beatsToSecs(f));
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
        }
    }

    class SnowflakeScene
    extends Scene {
        PShader shader;
        boolean reverse;

        public SnowflakeScene(float f, boolean bl) {
            super(f);
            this.reverse = bl;
            this.shader = gluster_graffathon_2015.this.loadShader("clouds.glsl");
            this.shader.set("iResolution", (float)gluster_graffathon_2015.this.CANVAS_WIDTH, (float)gluster_graffathon_2015.this.CANVAS_HEIGHT);
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.noStroke();
        }

        public void tree(int n, int n2, int n3, float f, float f2, float f3, boolean bl) {
            if (n2 < 0) {
                return;
            }
            float f4 = f + (float)n2 * 0.1f * gluster_graffathon_2015.sin((float)f3) * (1.0f + 0.1f * gluster_graffathon_2015.sin((float)((float)n * 5.0E-4f * (float)(n2 + 1))));
            float f5 = f2 + (float)n2 * 0.1f * gluster_graffathon_2015.cos((float)f3) * (1.0f + 0.1f * gluster_graffathon_2015.sin((float)((float)n * 5.0E-4f * (float)(n2 + 1))));
            if (!bl) {
                gluster_graffathon_2015.this.stroke(255.0f, 255.0f, 255.0f, 20.0f + 10.0f * gluster_graffathon_2015.sin((float)((float)n * 0.001f)));
                gluster_graffathon_2015.this.strokeWeight((float)n2 / 5.0f + 0.1f);
                gluster_graffathon_2015.this.line(f, f2, f4, f5);
                gluster_graffathon_2015.this.stroke(255.0f, 255.0f, 255.0f, 30.0f + 30.0f * gluster_graffathon_2015.sin((float)((float)n * 0.001f)));
                gluster_graffathon_2015.this.strokeWeight((float)n2 / 15.0f + 0.1f);
                gluster_graffathon_2015.this.line(f, f2, f4, f5);
                gluster_graffathon_2015.this.stroke(255.0f, 255.0f, 255.0f, 100.0f + 50.0f * gluster_graffathon_2015.sin((float)((float)n * 0.001f)));
                gluster_graffathon_2015.this.strokeWeight((float)n2 / 30.0f + 0.1f);
                gluster_graffathon_2015.this.line(f, f2, f4, f5);
            }
            if (!bl) {
                this.tree(n, n2 - 1, n3, f4, f5, gluster_graffathon_2015.radians((float)0.0f) + f3, false);
                this.tree(n, n2 - 1, n3, f4, f5, gluster_graffathon_2015.radians((float)40.0f) + f3, false);
                this.tree(n, n2 - 1, n3, f4, f5, gluster_graffathon_2015.radians((float)-40.0f) + f3, false);
            } else {
                int n4 = 0;
                while (n4 < n3) {
                    this.tree(n, n2 - 1, n3, f4, f5, gluster_graffathon_2015.radians((float)(n4 * 360 / n3)) + f3, false);
                    ++n4;
                }
            }
        }

        public void effectTree(int n, int n2, float f) {
            if (n2 == 0) {
                return;
            }
            gluster_graffathon_2015.this.pushMatrix();
            gluster_graffathon_2015.this.fill(255.0f, 255.0f, 255.0f, 80.0f + 50.0f * gluster_graffathon_2015.sin((float)((float)n * 0.001f)));
            float f2 = 0.25f;
            gluster_graffathon_2015.this.scale(f2);
            gluster_graffathon_2015.this.stroke(255);
            gluster_graffathon_2015.this.strokeWeight(1.0f);
            this.createFallingSnowFlake(n, n2, 5, 0.0f, -1.0f, 0.0f, true);
            this.createFallingSnowFlake(n, n2 - 1, 6, -2.0f, 0.0f, 0.0f, true);
            this.createFallingSnowFlake(n, n2, 5, 1.0f, 3.0f, 0.0f, true);
            this.createFallingSnowFlake(n, n2 - 1, 6, 5.0f, -3.0f, 0.0f, true);
            this.createFallingSnowFlake(n, n2 - 1, 6, -4.0f, 1.0f, 0.0f, true);
            this.createFallingSnowFlake(n, n2 - 1, 6, 3.5f, -1.0f, 0.0f, true);
            this.createFallingSnowFlake(n, n2 - 1, 5, 2.0f, 5.0f, 0.0f, true);
            this.createFallingSnowFlake(n, n2 - 1, 5, -1.0f, -3.0f, 0.0f, true);
            this.createFallingSnowFlake(n, n2, 6, -1.0f, -1.5f, 0.0f, true);
            this.createFallingSnowFlake(n, n2 - 2, 6, -2.0f, 4.0f, 0.0f, true);
            gluster_graffathon_2015.this.scale(0.03f);
            gluster_graffathon_2015.this.translate(0.0f, -5.0f, 0.0f);
            gluster_graffathon_2015.this.rotateX(gluster_graffathon_2015.radians((float)180.0f));
            gluster_graffathon_2015.this.popMatrix();
        }

        public void createFallingSnowFlake(int n, int n2, int n3, float f, float f2, float f3, boolean bl) {
            gluster_graffathon_2015.this.pushMatrix();
            float f4 = (this.reverse ? 1.0f : -1.0f) * (20.0f - (float)n * (5.0E-4f + 5.0E-4f * gluster_graffathon_2015.abs((float)f2) / 2.0f) % 40.0f);
            gluster_graffathon_2015.this.translate(f - 1.0f + 2.0f * gluster_graffathon_2015.sin((float)((float)n * 5.0E-4f + f)), f4);
            gluster_graffathon_2015.this.rotateZ(gluster_graffathon_2015.radians((float)((float)n * 0.005f)));
            this.tree(n, n2, n3, f, f2, f3, true);
            gluster_graffathon_2015.this.popMatrix();
        }

        @Override
        public void draw(float f) {
            gluster_graffathon_2015.this.rectMode(0);
            gluster_graffathon_2015.this.pushMatrix();
            gluster_graffathon_2015.this.translate((float)gluster_graffathon_2015.this.CANVAS_WIDTH / 2.0f, gluster_graffathon_2015.this.CANVAS_HEIGHT / 2, -800.0f);
            gluster_graffathon_2015.this.scale((float)gluster_graffathon_2015.this.CANVAS_WIDTH / 2.0f / gluster_graffathon_2015.this.ASPECT_RATIO, (float)(-gluster_graffathon_2015.this.CANVAS_HEIGHT) / 2.0f);
            gluster_graffathon_2015.this.clear();
            gluster_graffathon_2015.this.background(0);
            float f2 = f * 1000.0f;
            this.effectTree((int)f2, 5, 0.0f);
            gluster_graffathon_2015.this.popMatrix();
            float f3 = 0.0f;
            if (!this.reverse) {
                f3 = gluster_graffathon_2015.pow((float)gluster_graffathon_2015.min((float)1.0f, (float)(1.0f - f / 32.0f)), (float)2.0f);
            }
            this.shader.set("iFade", f3);
            this.shader.set("iBeats", f);
            this.shader.set("iGlobalTime", f);
            gluster_graffathon_2015.this.shader(this.shader);
            gluster_graffathon_2015.this.fill(100.0f, 100.0f, 100.0f, 0.5f);
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
            gluster_graffathon_2015.this.resetShader();
            float f4 = 0.0f;
            f4 = !this.reverse ? gluster_graffathon_2015.max((float)0.0f, (float)gluster_graffathon_2015.min((float)1.0f, (float)(f < 16.0f ? 1.0f - f / 16.0f : (f - 56.0f) / 8.0f))) : gluster_graffathon_2015.max((float)0.0f, (float)gluster_graffathon_2015.min((float)1.0f, (float)((f - 24.0f) / 40.0f)));
            gluster_graffathon_2015.this.fill(0.0f, 0.0f, 0.0f, 255.0f * f4);
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
        }
    }

    class StairsScene
    extends Scene {
        PShader shader;

        public StairsScene(float f) {
            super(f);
            this.shader = gluster_graffathon_2015.this.loadShader("clouds.glsl");
            this.shader.set("iResolution", (float)gluster_graffathon_2015.this.CANVAS_WIDTH, (float)gluster_graffathon_2015.this.CANVAS_HEIGHT);
            this.shader.set("iFade", 0.0f);
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.noStroke();
            gluster_graffathon_2015.this.background(10.0f, 2.0f, 12.0f);
        }

        @Override
        public void draw(float f) {
            gluster_graffathon_2015.this.clear();
            int n = gluster_graffathon_2015.round((float)(gluster_graffathon_2015.this.beatsToSecs(f) * 1000.0f));
            this.shader.set("iGlobalTime", gluster_graffathon_2015.sin((float)((float)n * 0.001f)));
            gluster_graffathon_2015.this.pushMatrix();
            gluster_graffathon_2015.this.translate(gluster_graffathon_2015.this.CANVAS_WIDTH / 2, gluster_graffathon_2015.this.CANVAS_HEIGHT / 2, -0.3f * (float)gluster_graffathon_2015.this.CANVAS_WIDTH);
            gluster_graffathon_2015.this.lights();
            gluster_graffathon_2015.this.rotateY((float)(-n) * 5.0E-4f);
            gluster_graffathon_2015.this.translate(0.0f, (float)n * 0.1f, 0.0f);
            gluster_graffathon_2015.this.fill(36.0f, 36.0f, 67.0f);
            float f2 = gluster_graffathon_2015.this.CANVAS_WIDTH / 4;
            int n2 = 5 * gluster_graffathon_2015.this.CANVAS_HEIGHT;
            gluster_graffathon_2015.this.translate(0.0f, -1.5f * (float)gluster_graffathon_2015.this.CANVAS_HEIGHT, 0.0f);
            gluster_graffathon_2015.this.shader(this.shader);
            gluster_graffathon_2015.this.box(f2, n2, f2);
            gluster_graffathon_2015.this.resetShader();
            int n3 = 5;
            float f3 = f2 / (float)n3;
            float f4 = gluster_graffathon_2015.this.CANVAS_WIDTH / 100;
            float f5 = f2 / 10.0f;
            float f6 = (int)(1.7f * f4);
            gluster_graffathon_2015.this.translate(-0.5f * f2, 1.1f * (float)gluster_graffathon_2015.this.CANVAS_HEIGHT, (f2 + f5) / 2.0f);
            int n4 = 0;
            while (n4 < 25) {
                int n5 = 0;
                while (n5 < n3) {
                    gluster_graffathon_2015.this.fill(10.0f, 2.0f, 12.0f);
                    if (f % 2.0f < 1.0f && (float)n5 % 3.0f * (float)n * 0.001f < 1.0f) {
                        gluster_graffathon_2015.this.fill(152.0f, 146.0f, 193.0f);
                        gluster_graffathon_2015.this.fill(36.0f, 36.0f, 67.0f);
                        gluster_graffathon_2015.this.fill(30.0f, 6.0f, 36.0f);
                    }
                    if (f % 4.0f < 1.0f && (float)(n5 * n4 + n5) * 0.1f * f % 2.0f < 1.0f) {
                        gluster_graffathon_2015.this.fill(191.0f, 189.0f, 191.0f);
                        gluster_graffathon_2015.this.fill(152.0f, 146.0f, 193.0f);
                    }
                    gluster_graffathon_2015.this.translate(f3, -f6, 0.0f);
                    gluster_graffathon_2015.this.box(f3, f4, f5);
                    ++n5;
                }
                gluster_graffathon_2015.this.rotateY(1.5707964f);
                gluster_graffathon_2015.this.translate(f5 / 2.0f, 0.0f, f5 / 2.0f);
                ++n4;
            }
            gluster_graffathon_2015.this.popMatrix();
            gluster_graffathon_2015.this.resetShader();
        }
    }

    class StairsScene2
    extends Scene {
        PShader shader;
        PShader shader2;

        public StairsScene2(float f) {
            super(f);
            this.shader = gluster_graffathon_2015.this.loadShader("lines2.glsl");
            this.shader.set("iResolution", (float)gluster_graffathon_2015.this.CANVAS_WIDTH, (float)gluster_graffathon_2015.this.CANVAS_HEIGHT);
            this.shader2 = gluster_graffathon_2015.this.loadShader("lines3.glsl");
            this.shader2.set("iResolution", (float)gluster_graffathon_2015.this.CANVAS_WIDTH, (float)gluster_graffathon_2015.this.CANVAS_HEIGHT);
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.resetShader();
            gluster_graffathon_2015.this.noStroke();
        }

        @Override
        public void draw(float f) {
            gluster_graffathon_2015.this.clear();
            int n = gluster_graffathon_2015.round((float)(gluster_graffathon_2015.this.beatsToSecs(f) * 1000.0f));
            this.shader.set("iGlobalTime", (float)n * 0.001f);
            this.shader2.set("iGlobalTime", (float)n * 0.001f);
            gluster_graffathon_2015.this.pushMatrix();
            gluster_graffathon_2015.this.translate(gluster_graffathon_2015.this.CANVAS_WIDTH / 2, gluster_graffathon_2015.this.CANVAS_HEIGHT / 2, -0.3f * (float)gluster_graffathon_2015.this.CANVAS_WIDTH);
            gluster_graffathon_2015.this.lights();
            gluster_graffathon_2015.this.rotateY(2.3561945f + (float)(-n) * 5.0E-4f);
            gluster_graffathon_2015.this.translate(0.0f, (float)n * 0.1f, 0.0f);
            gluster_graffathon_2015.this.fill(36.0f, 36.0f, 67.0f);
            float f2 = gluster_graffathon_2015.this.CANVAS_WIDTH / 3;
            gluster_graffathon_2015.this.translate(0.0f, -2.0f * (float)gluster_graffathon_2015.this.CANVAS_HEIGHT, 0.0f);
            int n2 = 5;
            float f3 = f2 / (float)n2;
            float f4 = gluster_graffathon_2015.this.CANVAS_WIDTH / 100;
            float f5 = f3;
            float f6 = (int)(3.0f * f4);
            gluster_graffathon_2015.this.translate(-0.5f * f2, 1.1f * (float)gluster_graffathon_2015.this.CANVAS_HEIGHT, (f2 + f5) / 2.0f);
            int n3 = 0;
            while (n3 < 30) {
                int n4 = 0;
                while (n4 < n2) {
                    gluster_graffathon_2015.this.fill(36.0f, 36.0f, 67.0f);
                    if (f % 2.0f < 1.0f && ((float)(n4 + n3) + (float)n * 0.001f) % 3.0f < 1.0f) {
                        gluster_graffathon_2015.this.fill(152.0f, 146.0f, 193.0f);
                    }
                    gluster_graffathon_2015.this.translate(f3, -f6, 0.0f);
                    gluster_graffathon_2015.this.box(f3, f4, f5);
                    ++n4;
                }
                gluster_graffathon_2015.this.rotateY(1.5707964f);
                ++n3;
            }
            gluster_graffathon_2015.this.popMatrix();
            gluster_graffathon_2015.this.shader(this.shader);
            gluster_graffathon_2015.this.fill(100.0f, 100.0f, 100.0f, 0.5f);
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
            gluster_graffathon_2015.this.shader(this.shader2);
            gluster_graffathon_2015.this.fill(100.0f, 100.0f, 100.0f, 0.5f);
            gluster_graffathon_2015.this.rect(0.0f, 0.0f, gluster_graffathon_2015.this.CANVAS_WIDTH, gluster_graffathon_2015.this.CANVAS_HEIGHT);
            gluster_graffathon_2015.this.resetShader();
        }
    }

    class TestScene
    extends Scene {
        public boolean green;

        public TestScene(float f, boolean bl) {
            super(f);
            this.green = bl;
        }

        @Override
        public void setup() {
            gluster_graffathon_2015.this.resetShader();
            gluster_graffathon_2015.this.textSize(32.0f);
            gluster_graffathon_2015.this.noStroke();
            gluster_graffathon_2015.this.fill(255);
        }

        @Override
        public void draw(float f) {
            if (this.green) {
                gluster_graffathon_2015.this.background(0.0f, 255.0f, 0.0f);
            } else {
                gluster_graffathon_2015.this.background(255.0f, 0.0f, 0.0f);
            }
            gluster_graffathon_2015.this.text("" + f, 10.0f, 0.5f * (float)gluster_graffathon_2015.this.CANVAS_HEIGHT);
        }
    }

    class Timeline {
        public Minim minim;
        public AudioPlayer song;
        public int currentScene;
        public float currentStartTime;
        public float currentEndTime;
        public ArrayList<Scene> scenes;

        public Timeline(Object object, String string) {
            this.minim = new Minim(object);
            this.song = this.minim.loadFile(string);
            this.currentScene = -1;
            this.scenes = new ArrayList();
        }

        public void addScene(Scene scene) {
            this.scenes.add(scene);
        }

        public void drawScene() {
            float f = 0.001f * (float)this.song.position() / gluster_graffathon_2015.this.BEAT_DURATION;
            Scene scene = null;
            boolean bl = false;
            if (this.currentScene >= 0 && this.currentStartTime <= f && f < this.currentEndTime) {
                scene = this.scenes.get(this.currentScene);
            }
            boolean bl2 = false;
            float f2 = 0.0f;
            int n = 0;
            while (n < this.scenes.size()) {
                scene = this.scenes.get(n);
                float f3 = f2 + scene.duration;
                if (f2 <= f && f < f3) {
                    bl2 = true;
                    bl = n != this.currentScene;
                    this.currentScene = n;
                    this.currentStartTime = f2;
                    this.currentEndTime = f3;
                    break;
                }
                f2 += scene.duration;
                ++n;
            }
            if (!bl2) {
                this.currentScene = -1;
            }
            if (this.currentScene < 0) {
                gluster_graffathon_2015.this.background(0);
                return;
            }
            if (bl) {
                scene.setup();
            }
            scene.draw(f - this.currentStartTime);
        }
    }
}

