/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.core;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.DOMObjectFactory;
import sun.plugin.dom.DOMObjectHelper;
import sun.plugin.dom.core.Attr;
import sun.plugin.dom.core.Node;
import sun.plugin.dom.exception.PluginNotSupportedException;
import sun.plugin.dom.html.HTMLDocument;

public abstract class Element
extends Node
implements org.w3c.dom.Element {
    private static final String ATTR_TAGNAME = "tagName";

    protected Element(DOMObject dOMObject, Document document) {
        super(dOMObject, document);
    }

    public String getTagName() {
        return this.getAttribute(ATTR_TAGNAME);
    }

    public String getAttribute(String string) {
        return DOMObjectHelper.getStringMemberNoEx(this.obj, string);
    }

    public void setAttribute(String string, String string2) throws DOMException {
        DOMObjectHelper.setStringMember(this.obj, string, string2);
    }

    public void removeAttribute(String string) throws DOMException {
        throw new PluginNotSupportedException("Element.removeAttribute() is not supported");
    }

    public org.w3c.dom.Attr getAttributeNode(String string) {
        return DOMObjectFactory.createAttr(this.obj.call("getAttributeNode", new Object[]{string}), this.getOwnerDocument());
    }

    public org.w3c.dom.Attr setAttributeNode(org.w3c.dom.Attr attr) throws DOMException {
        return DOMObjectFactory.createAttr(this.obj.call("setAttributeNode", new Object[]{((Attr)attr).getDOMObject()}), this.getOwnerDocument());
    }

    public org.w3c.dom.Attr removeAttributeNode(org.w3c.dom.Attr attr) throws DOMException {
        return DOMObjectFactory.createAttr(this.obj.call("removeAttributeNode", new Object[]{((Attr)attr).getDOMObject()}), this.getOwnerDocument());
    }

    public NodeList getElementsByTagName(String string) {
        return DOMObjectFactory.createNodeList(this.obj.call("getElementsByTagName", new Object[]{string}), (HTMLDocument)this.getOwnerDocument());
    }

    public String getAttributeNS(String string, String string2) {
        try {
            return (String)this.obj.call("getAttributeNS", new Object[]{string, string2});
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.obj.call("setAttributeNS", new Object[]{string, string2, string3});
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.obj.call("removeAttributeNS", new Object[]{string, string2});
    }

    public org.w3c.dom.Attr getAttributeNodeNS(String string, String string2) {
        return DOMObjectFactory.createAttr(this.obj.call("getAttributeNodeNS", new Object[]{string, string2}), this.getOwnerDocument());
    }

    public org.w3c.dom.Attr setAttributeNodeNS(org.w3c.dom.Attr attr) throws DOMException {
        return DOMObjectFactory.createAttr(this.obj.call("setAttributeNodeNS", new Object[]{((Attr)attr).getDOMObject()}), this.getOwnerDocument());
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return DOMObjectFactory.createNodeList(this.obj.call("getElementsByTagNameNS", new Object[]{string, string2}), (HTMLDocument)this.getOwnerDocument());
    }

    public boolean hasAttribute(String string) {
        return this.getAttribute(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        try {
            return (Boolean)this.obj.call("hasAttributeNS", new Object[]{string, string2});
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getNodeValue() throws DOMException {
        throw new PluginNotSupportedException("Element.getNodeValue() is not supported");
    }

    public void setNodeValue(String string) throws DOMException {
        throw new PluginNotSupportedException("Element.setNodeValue() is not supported");
    }

    public void setIdAttribute(String string, boolean bl) throws DOMException {
        throw new PluginNotSupportedException("Element.setIdAttribute() is not supported");
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
        throw new PluginNotSupportedException("Element.setIdAttributeNS() is not supported");
    }

    public void setIdAttributeNode(org.w3c.dom.Attr attr, boolean bl) throws DOMException {
        throw new PluginNotSupportedException("Element.setIdAttributeNode() is not supported");
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new PluginNotSupportedException("Element.getSchemaTypeInfo is not supported");
    }
}

