/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.resources.ResourceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityLevel {
    private static final List SLIDER_LIST = new ArrayList();
    private static final Map LEVEL_MAP = new HashMap();
    private final String configKey;
    private final String name;
    private final int sliderSetting;
    private final String description;
    public static final SecurityLevel Medium = SecurityLevel.createLevel("MEDIUM", 0);
    public static final SecurityLevel High = SecurityLevel.createLevel("HIGH", 1);
    public static final SecurityLevel VeryHigh = SecurityLevel.createLevel("VERY_HIGH", 2);

    private static SecurityLevel createLevel(String string, int n) {
        SecurityLevel securityLevel = new SecurityLevel(string, n);
        SLIDER_LIST.add(n, securityLevel);
        LEVEL_MAP.put(string, securityLevel);
        return securityLevel;
    }

    private SecurityLevel(String string, int n) {
        this.configKey = string;
        String string2 = "deployment.security.slider." + string;
        this.description = ResourceManager.getMessage(string2 + ".description");
        this.name = ResourceManager.getMessage(string2);
        this.sliderSetting = n;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getDescription() {
        return this.description;
    }

    public int getSliderSetting() {
        return this.sliderSetting;
    }

    public static SecurityLevel getSliderSetting(int n) {
        return (SecurityLevel)SLIDER_LIST.get(n);
    }

    public static SecurityLevel getLevel(String string) {
        if (LEVEL_MAP.get(string) != null) {
            return (SecurityLevel)LEVEL_MAP.get(string);
        }
        return High;
    }

    public static List values() {
        return Collections.unmodifiableList(SLIDER_LIST);
    }
}

