/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.MsgLevel;
import oracle.jrockit.jfr.Options;

@Deprecated
final class Repository {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private final Logger logger;
    private final String pid;
    private static final int MAX_REPO_CREATION_RETRIES = 1000;
    private File path;

    public Repository(JFR jFR, Options options, Logger logger) throws Exception {
        this.logger = logger;
        this.pid = String.valueOf(jFR.getpid());
        this.create(options.repository());
    }

    private String create(String string) throws Exception {
        String string2;
        String string3 = string;
        if (string3 == null) {
            string3 = System.getProperty("java.io.tmpdir");
        }
        assert (string3 != null);
        File file = new File(string3);
        if (file.exists() && !file.canWrite()) {
            throw new Exception("JFR repository directory (" + file.getCanonicalFile().getPath() + ") exists, but isn't writable.");
        }
        File file2 = null;
        String string4 = string2 = this.repositoryName();
        int n = 0;
        while (n < 1000 && !this.tryToUseAsRepository(file2 = new File(file.getCanonicalFile().getPath(), string4))) {
            string4 = string2 + "_" + n++;
        }
        if (n == 1000) {
            throw new Exception("Unable to create JFR repository directory using base location (" + string3 + ").");
        }
        this.path = file2;
        this.logger.log(MsgLevel.INFO, "Using %s as Flight Recorder repository.", this.path.getCanonicalFile().getPath());
        return this.path.getPath();
    }

    private boolean tryToUseAsRepository(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    file.getCanonicalFile().getParentFile().mkdirs();
                    if (file.exists()) {
                        return false;
                    }
                    if (!file.mkdir()) {
                        return false;
                    }
                    if (!file.exists()) {
                        return false;
                    }
                    return true;
                }
                catch (Exception exception) {
                    Repository.this.logger.log(MsgLevel.WARN, exception, "Could not open %s as repository.", file);
                    return false;
                }
            }
        });
    }

    final String filenameBase() {
        return this.sdf.format(new Date()) + "_" + this.pid;
    }

    public final File getPath() {
        return this.path;
    }

    private final String repositoryName() {
        return this.filenameBase();
    }

    public void destroy() {
        this.logger.info("Deleting Flight Recorder repository");
        if (!this.path.delete()) {
            this.logger.error("Repository could not be removed at shutdown: " + this.path.getAbsoluteFile());
        }
    }
}

