/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.PKIXExtensions;

public class CertificateIssuerExtension
extends Extension
implements CertAttrSet<String> {
    public static final String NAME = "CertificateIssuer";
    public static final String ISSUER = "issuer";
    private GeneralNames names;

    private void encodeThis() throws IOException {
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.names.encode(derOutputStream);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public CertificateIssuerExtension(GeneralNames generalNames) throws IOException {
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = true;
        this.names = generalNames;
        this.encodeThis();
    }

    public CertificateIssuerExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        this.names = new GeneralNames(derValue);
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(ISSUER)) {
            if (!(object instanceof GeneralNames)) {
                throw new IOException("Attribute value must be of type GeneralNames");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuer");
        }
        this.names = (GeneralNames)object;
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(ISSUER)) {
            return this.names;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuer");
    }

    @Override
    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(ISSUER)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateIssuer");
        }
        this.names = null;
        this.encodeThis();
    }

    @Override
    public String toString() {
        return super.toString() + "Certificate Issuer [\n" + String.valueOf(this.names) + "]\n";
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CertificateIssuer_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(ISSUER);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

