/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.util.Date;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class Krb5InitCredential
extends KerberosTicket
implements Krb5CredElement {
    private static final long serialVersionUID = 7723415700837898232L;
    private Krb5NameElement name;
    private Credentials krb5Credentials;

    private Krb5InitCredential(Krb5NameElement krb5NameElement, byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws GSSException {
        super(byArray, kerberosPrincipal, kerberosPrincipal2, byArray2, n, blArray, date, date2, date3, date4, inetAddressArray);
        this.name = krb5NameElement;
        try {
            this.krb5Credentials = new Credentials(byArray, kerberosPrincipal.getName(), kerberosPrincipal2.getName(), byArray2, n, blArray, date, date2, date3, date4, inetAddressArray);
        }
        catch (KrbException krbException) {
            throw new GSSException(13, -1, krbException.getMessage());
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.getMessage());
        }
    }

    private Krb5InitCredential(Krb5NameElement krb5NameElement, Credentials credentials, byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws GSSException {
        super(byArray, kerberosPrincipal, kerberosPrincipal2, byArray2, n, blArray, date, date2, date3, date4, inetAddressArray);
        this.name = krb5NameElement;
        this.krb5Credentials = credentials;
    }

    static Krb5InitCredential getInstance(GSSCaller gSSCaller, Krb5NameElement krb5NameElement, int n) throws GSSException {
        KerberosTicket kerberosTicket = Krb5InitCredential.getTgt(gSSCaller, krb5NameElement, n);
        if (kerberosTicket == null) {
            throw new GSSException(13, -1, "Failed to find any Kerberos tgt");
        }
        if (krb5NameElement == null) {
            String string = kerberosTicket.getClient().getName();
            krb5NameElement = Krb5NameElement.getInstance(string, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        return new Krb5InitCredential(krb5NameElement, kerberosTicket.getEncoded(), kerberosTicket.getClient(), kerberosTicket.getServer(), kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
    }

    static Krb5InitCredential getInstance(Krb5NameElement krb5NameElement, Credentials credentials) throws GSSException {
        EncryptionKey encryptionKey = credentials.getSessionKey();
        PrincipalName principalName = credentials.getClient();
        PrincipalName principalName2 = credentials.getServer();
        KerberosPrincipal kerberosPrincipal = null;
        KerberosPrincipal kerberosPrincipal2 = null;
        Krb5NameElement krb5NameElement2 = null;
        if (principalName != null) {
            String string = principalName.getName();
            krb5NameElement2 = Krb5NameElement.getInstance(string, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
            kerberosPrincipal = new KerberosPrincipal(string);
        }
        if (principalName2 != null) {
            kerberosPrincipal2 = new KerberosPrincipal(principalName2.getName(), 2);
        }
        return new Krb5InitCredential(krb5NameElement2, credentials, credentials.getEncoded(), kerberosPrincipal, kerberosPrincipal2, encryptionKey.getBytes(), encryptionKey.getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
    }

    @Override
    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        int n = 0;
        n = (int)(this.getEndTime().getTime() - new Date().getTime());
        return n / 1000;
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return 0;
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return true;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return false;
    }

    @Override
    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    Credentials getKrb5Credentials() {
        return this.krb5Credentials;
    }

    @Override
    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            GSSException gSSException = new GSSException(11, -1, "Could not destroy credentials - " + destroyFailedException.getMessage());
            gSSException.initCause(destroyFailedException);
        }
    }

    private static KerberosTicket getTgt(GSSCaller gSSCaller, Krb5NameElement krb5NameElement, int n) throws GSSException {
        Object object;
        String string;
        String string2 = null;
        final String string3 = null;
        if (krb5NameElement != null) {
            string = krb5NameElement.getKrb5PrincipalName().getName();
            string2 = krb5NameElement.getKrb5PrincipalName().getRealmAsString();
        } else {
            string = null;
            try {
                object = Config.getInstance();
                string2 = ((Config)object).getDefaultRealm();
            }
            catch (KrbException krbException) {
                GSSException gSSException = new GSSException(13, -1, "Attempt to obtain INITIATE credentials failed! (" + krbException.getMessage() + ")");
                gSSException.initCause(krbException);
                throw gSSException;
            }
        }
        object = AccessController.getContext();
        try {
            final GSSCaller gSSCaller2 = gSSCaller == GSSCaller.CALLER_UNKNOWN ? GSSCaller.CALLER_INITIATE : gSSCaller;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>((AccessControlContext)object){
                final /* synthetic */ AccessControlContext val$acc;
                {
                    this.val$acc = accessControlContext;
                }

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getTicket(gSSCaller2, string, string3, this.val$acc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            GSSException gSSException = new GSSException(13, -1, "Attempt to obtain new INITIATE credentials failed! (" + privilegedActionException.getMessage() + ")");
            gSSException.initCause(privilegedActionException.getException());
            throw gSSException;
        }
    }
}

