/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.Block;
import sun.org.mozilla.javascript.internal.ast.Loop;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class ForLoop
extends Loop {
    private AstNode initializer;
    private AstNode condition;
    private AstNode increment;

    public ForLoop() {
        this.type = 119;
    }

    public ForLoop(int n) {
        super(n);
        this.type = 119;
    }

    public ForLoop(int n, int n2) {
        super(n, n2);
        this.type = 119;
    }

    public AstNode getInitializer() {
        return this.initializer;
    }

    public void setInitializer(AstNode astNode) {
        this.assertNotNull(astNode);
        this.initializer = astNode;
        astNode.setParent(this);
    }

    public AstNode getCondition() {
        return this.condition;
    }

    public void setCondition(AstNode astNode) {
        this.assertNotNull(astNode);
        this.condition = astNode;
        astNode.setParent(this);
    }

    public AstNode getIncrement() {
        return this.increment;
    }

    public void setIncrement(AstNode astNode) {
        this.assertNotNull(astNode);
        this.increment = astNode;
        astNode.setParent(this);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("for (");
        stringBuilder.append(this.initializer.toSource(0));
        stringBuilder.append("; ");
        stringBuilder.append(this.condition.toSource(0));
        stringBuilder.append("; ");
        stringBuilder.append(this.increment.toSource(0));
        stringBuilder.append(") ");
        if (this.body instanceof Block) {
            stringBuilder.append(this.body.toSource(n).trim()).append("\n");
        } else {
            stringBuilder.append("\n").append(this.body.toSource(n + 1));
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.initializer.visit(nodeVisitor);
            this.condition.visit(nodeVisitor);
            this.increment.visit(nodeVisitor);
            this.body.visit(nodeVisitor);
        }
    }
}

