/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedWatchEventModifier;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractPoller;
import sun.nio.fs.AbstractWatchKey;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsWatchService
extends AbstractWatchService {
    private final Unsafe unsafe = Unsafe.getUnsafe();
    private final Poller poller;
    private static final int ALL_FILE_NOTIFY_EVENTS = 351;

    WindowsWatchService(WindowsFileSystem windowsFileSystem) throws IOException {
        long l = 0L;
        try {
            l = WindowsNativeDispatcher.CreateIoCompletionPort(-1L, 0L, 0);
        }
        catch (WindowsException windowsException) {
            throw new IOException(windowsException.getMessage());
        }
        this.poller = new Poller(windowsFileSystem, this, l);
        this.poller.start();
    }

    @Override
    WatchKey register(Path path, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        return this.poller.register(path, kindArray, modifierArray);
    }

    @Override
    void implClose() throws IOException {
        this.poller.close();
    }

    private static class FileKey {
        private final int volSerialNumber;
        private final int fileIndexHigh;
        private final int fileIndexLow;

        FileKey(int n, int n2, int n3) {
            this.volSerialNumber = n;
            this.fileIndexHigh = n2;
            this.fileIndexLow = n3;
        }

        public int hashCode() {
            return this.volSerialNumber ^ this.fileIndexHigh ^ this.fileIndexLow;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof FileKey)) {
                return false;
            }
            FileKey fileKey = (FileKey)object;
            if (this.volSerialNumber != fileKey.volSerialNumber) {
                return false;
            }
            if (this.fileIndexHigh != fileKey.fileIndexHigh) {
                return false;
            }
            return this.fileIndexLow == fileKey.fileIndexLow;
        }
    }

    private class Poller
    extends AbstractPoller {
        private static final short SIZEOF_DWORD = 4;
        private static final short SIZEOF_OVERLAPPED = 32;
        private static final short OFFSETOF_NEXTENTRYOFFSET = 0;
        private static final short OFFSETOF_ACTION = 4;
        private static final short OFFSETOF_FILENAMELENGTH = 8;
        private static final short OFFSETOF_FILENAME = 12;
        private static final int CHANGES_BUFFER_SIZE = 16384;
        private final WindowsFileSystem fs;
        private final WindowsWatchService watcher;
        private final long port;
        private final Map<Integer, WindowsWatchKey> int2key;
        private final Map<FileKey, WindowsWatchKey> fk2key;
        private int lastCompletionKey;

        Poller(WindowsFileSystem windowsFileSystem, WindowsWatchService windowsWatchService2, long l) {
            this.fs = windowsFileSystem;
            this.watcher = windowsWatchService2;
            this.port = l;
            this.int2key = new HashMap<Integer, WindowsWatchKey>();
            this.fk2key = new HashMap<FileKey, WindowsWatchKey>();
            this.lastCompletionKey = 0;
        }

        @Override
        void wakeup() throws IOException {
            try {
                WindowsNativeDispatcher.PostQueuedCompletionStatus(this.port, 0);
            }
            catch (WindowsException windowsException) {
                throw new IOException(windowsException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object implRegister(Path path, Set<? extends WatchEvent.Kind<?>> set, WatchEvent.Modifier ... modifierArray) {
            WindowsPath windowsPath = (WindowsPath)path;
            boolean bl = false;
            for (WatchEvent.Modifier object : modifierArray) {
                if (object == ExtendedWatchEventModifier.FILE_TREE) {
                    bl = true;
                    continue;
                }
                if (object == null) {
                    return new NullPointerException();
                }
                if (object instanceof SensitivityWatchEventModifier) continue;
                return new UnsupportedOperationException("Modifier not supported");
            }
            long l = -1L;
            try {
                l = WindowsNativeDispatcher.CreateFile(windowsPath.getPathForWin32Calls(), 1, 7, 3, 0x42000000);
            }
            catch (WindowsException windowsException) {
                return windowsException.asIOException(windowsPath);
            }
            int n = 0;
            try {
                WindowsWatchKey windowsWatchKey;
                int n2;
                WindowsFileAttributes windowsFileAttributes;
                Object var9_12 = null;
                try {
                    windowsFileAttributes = WindowsFileAttributes.readAttributes(l);
                }
                catch (WindowsException fileKey) {
                    IOException iOException = fileKey.asIOException(windowsPath);
                    if (n == 0) {
                        WindowsNativeDispatcher.CloseHandle(l);
                    }
                    return iOException;
                }
                if (!windowsFileAttributes.isDirectory()) {
                    NotDirectoryException notDirectoryException = new NotDirectoryException(windowsPath.getPathForExceptionMessage());
                    return notDirectoryException;
                }
                FileKey fileKey = new FileKey(windowsFileAttributes.volSerialNumber(), windowsFileAttributes.fileIndexHigh(), windowsFileAttributes.fileIndexLow());
                WindowsWatchKey windowsWatchKey2 = this.fk2key.get(fileKey);
                if (windowsWatchKey2 != null && bl == windowsWatchKey2.watchSubtree()) {
                    windowsWatchKey2.setEvents(set);
                    WindowsWatchKey windowsWatchKey3 = windowsWatchKey2;
                    return windowsWatchKey3;
                }
                ++this.lastCompletionKey;
                if ((n2 = this.lastCompletionKey++) == 0) {
                    n2 = this.lastCompletionKey;
                }
                try {
                    WindowsNativeDispatcher.CreateIoCompletionPort(l, this.port, n2);
                }
                catch (WindowsException windowsException) {
                    IOException iOException = new IOException(windowsException.getMessage());
                    if (n == 0) {
                        WindowsNativeDispatcher.CloseHandle(l);
                    }
                    return iOException;
                }
                int n3 = 16420;
                NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(n3);
                long l2 = nativeBuffer.address();
                long l3 = l2 + (long)n3 - 32L;
                long l4 = l3 - 4L;
                try {
                    WindowsNativeDispatcher.ReadDirectoryChangesW(l, l2, 16384, bl, 351, l4, l3);
                }
                catch (WindowsException windowsException) {
                    nativeBuffer.release();
                    IOException iOException = new IOException(windowsException.getMessage());
                    if (n == 0) {
                        WindowsNativeDispatcher.CloseHandle(l);
                    }
                    return iOException;
                }
                if (windowsWatchKey2 == null) {
                    windowsWatchKey = new WindowsWatchKey(windowsPath, this.watcher, fileKey).init(l, set, bl, nativeBuffer, l4, l3, n2);
                    this.fk2key.put(fileKey, windowsWatchKey);
                } else {
                    this.int2key.remove(windowsWatchKey2.completionKey());
                    windowsWatchKey2.releaseResources();
                    windowsWatchKey = windowsWatchKey2.init(l, set, bl, nativeBuffer, l4, l3, n2);
                }
                this.int2key.put(n2, windowsWatchKey);
                n = 1;
                WindowsWatchKey windowsWatchKey4 = windowsWatchKey;
                return windowsWatchKey4;
            }
            finally {
                if (n == 0) {
                    WindowsNativeDispatcher.CloseHandle(l);
                }
            }
        }

        @Override
        void implCancelKey(WatchKey watchKey) {
            WindowsWatchKey windowsWatchKey = (WindowsWatchKey)watchKey;
            if (windowsWatchKey.isValid()) {
                this.fk2key.remove(windowsWatchKey.fileKey());
                this.int2key.remove(windowsWatchKey.completionKey());
                windowsWatchKey.invalidate();
            }
        }

        @Override
        void implCloseAll() {
            for (Map.Entry<Integer, WindowsWatchKey> entry : this.int2key.entrySet()) {
                entry.getValue().invalidate();
            }
            this.fk2key.clear();
            this.int2key.clear();
            WindowsNativeDispatcher.CloseHandle(this.port);
        }

        private WatchEvent.Kind<?> translateActionToEvent(int n) {
            switch (n) {
                case 3: {
                    return StandardWatchEventKinds.ENTRY_MODIFY;
                }
                case 1: 
                case 5: {
                    return StandardWatchEventKinds.ENTRY_CREATE;
                }
                case 2: 
                case 4: {
                    return StandardWatchEventKinds.ENTRY_DELETE;
                }
            }
            return null;
        }

        private void processEvents(WindowsWatchKey windowsWatchKey, int n) {
            int n2;
            long l = windowsWatchKey.buffer().address();
            do {
                int n3 = WindowsWatchService.this.unsafe.getInt(l + 4L);
                WatchEvent.Kind<?> kind = this.translateActionToEvent(n3);
                if (windowsWatchKey.events().contains(kind)) {
                    int n4 = WindowsWatchService.this.unsafe.getInt(l + 8L);
                    if (n4 % 2 != 0) {
                        throw new AssertionError((Object)"FileNameLength.FileNameLength is not a multiple of 2");
                    }
                    char[] cArray = new char[n4 / 2];
                    WindowsWatchService.this.unsafe.copyMemory(null, l + 12L, cArray, Unsafe.ARRAY_CHAR_BASE_OFFSET, n4);
                    WindowsPath windowsPath = WindowsPath.createFromNormalizedPath(this.fs, new String(cArray));
                    windowsWatchKey.signalEvent(kind, windowsPath);
                }
                n2 = WindowsWatchService.this.unsafe.getInt(l + 0L);
                l += (long)n2;
            } while (n2 != 0);
        }

        @Override
        public void run() {
            while (true) {
                WindowsNativeDispatcher.CompletionStatus completionStatus = null;
                try {
                    completionStatus = WindowsNativeDispatcher.GetQueuedCompletionStatus(this.port);
                }
                catch (WindowsException windowsException) {
                    windowsException.printStackTrace();
                    return;
                }
                if (completionStatus.completionKey() == 0) {
                    boolean bl = this.processRequests();
                    if (!bl) continue;
                    return;
                }
                WindowsWatchKey windowsWatchKey = this.int2key.get(completionStatus.completionKey());
                if (windowsWatchKey == null) continue;
                if (completionStatus.error() != 0) {
                    if (completionStatus.error() == 1022) {
                        windowsWatchKey.signalEvent(StandardWatchEventKinds.OVERFLOW, null);
                        continue;
                    }
                    this.implCancelKey(windowsWatchKey);
                    windowsWatchKey.signal();
                    continue;
                }
                if (completionStatus.bytesTransferred() > 0) {
                    this.processEvents(windowsWatchKey, completionStatus.bytesTransferred());
                } else {
                    windowsWatchKey.signalEvent(StandardWatchEventKinds.OVERFLOW, null);
                }
                try {
                    WindowsNativeDispatcher.ReadDirectoryChangesW(windowsWatchKey.handle(), windowsWatchKey.buffer().address(), 16384, windowsWatchKey.watchSubtree(), 351, windowsWatchKey.countAddress(), windowsWatchKey.overlappedAddress());
                    continue;
                }
                catch (WindowsException windowsException) {
                    this.implCancelKey(windowsWatchKey);
                    windowsWatchKey.signal();
                    continue;
                }
                break;
            }
        }
    }

    private class WindowsWatchKey
    extends AbstractWatchKey {
        private FileKey fileKey;
        private volatile long handle;
        private Set<? extends WatchEvent.Kind<?>> events;
        private boolean watchSubtree;
        private NativeBuffer buffer;
        private long countAddress;
        private long overlappedAddress;
        private int completionKey;

        WindowsWatchKey(Path path, AbstractWatchService abstractWatchService, FileKey fileKey) {
            super(path, abstractWatchService);
            this.handle = -1L;
            this.fileKey = fileKey;
        }

        WindowsWatchKey init(long l, Set<? extends WatchEvent.Kind<?>> set, boolean bl, NativeBuffer nativeBuffer, long l2, long l3, int n) {
            this.handle = l;
            this.events = set;
            this.watchSubtree = bl;
            this.buffer = nativeBuffer;
            this.countAddress = l2;
            this.overlappedAddress = l3;
            this.completionKey = n;
            return this;
        }

        long handle() {
            return this.handle;
        }

        Set<? extends WatchEvent.Kind<?>> events() {
            return this.events;
        }

        void setEvents(Set<? extends WatchEvent.Kind<?>> set) {
            this.events = set;
        }

        boolean watchSubtree() {
            return this.watchSubtree;
        }

        NativeBuffer buffer() {
            return this.buffer;
        }

        long countAddress() {
            return this.countAddress;
        }

        long overlappedAddress() {
            return this.overlappedAddress;
        }

        FileKey fileKey() {
            return this.fileKey;
        }

        int completionKey() {
            return this.completionKey;
        }

        void releaseResources() {
            WindowsNativeDispatcher.CloseHandle(this.handle);
            this.buffer.cleaner().clean();
        }

        void invalidate() {
            this.releaseResources();
            this.handle = -1L;
            this.buffer = null;
            this.countAddress = 0L;
            this.overlappedAddress = 0L;
        }

        @Override
        public boolean isValid() {
            return this.handle != -1L;
        }

        @Override
        public void cancel() {
            if (this.isValid()) {
                WindowsWatchService.this.poller.cancel(this);
            }
        }
    }
}

