/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

public abstract class LRUCache<N, V> {
    private V[] oa = null;
    private final int size;

    public LRUCache(int n) {
        this.size = n;
    }

    protected abstract V create(N var1);

    protected abstract boolean hasName(V var1, N var2);

    public static void moveToFront(Object[] objectArray, int n) {
        Object object = objectArray[n];
        for (int i = n; i > 0; --i) {
            objectArray[i] = objectArray[i - 1];
        }
        objectArray[0] = object;
    }

    public V forName(N n) {
        if (this.oa == null) {
            this.oa = new Object[this.size];
        } else {
            for (int i = 0; i < this.oa.length; ++i) {
                V v = this.oa[i];
                if (v == null || !this.hasName(v, n)) continue;
                if (i > 0) {
                    LRUCache.moveToFront(this.oa, i);
                }
                return v;
            }
        }
        V v = this.create(n);
        this.oa[this.oa.length - 1] = v;
        LRUCache.moveToFront(this.oa, this.oa.length - 1);
        return v;
    }
}

