/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontStrike;
import sun.font.FontUtilities;
import sun.font.StrikeMetrics;
import sun.font.SunFontManager;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public final class FontDesignMetrics
extends FontMetrics {
    static final long serialVersionUID = 4480069578560887773L;
    private static final float UNKNOWN_WIDTH = -1.0f;
    private static final int CURRENT_VERSION = 1;
    private static float roundingUpValue = 0.95f;
    private Font font;
    private float ascent;
    private float descent;
    private float leading;
    private float maxAdvance;
    private double[] matrix;
    private int[] cache;
    private int serVersion = 0;
    private boolean isAntiAliased;
    private boolean usesFractionalMetrics;
    private AffineTransform frcTx;
    private transient float[] advCache;
    private transient int height = -1;
    private transient FontRenderContext frc;
    private transient double[] devmatrix = null;
    private transient FontStrike fontStrike;
    private static FontRenderContext DEFAULT_FRC = null;
    private static final ConcurrentHashMap<Object, KeyReference> metricsCache = new ConcurrentHashMap();
    private static final int MAXRECENT = 5;
    private static final FontDesignMetrics[] recentMetrics = new FontDesignMetrics[5];
    private static int recentIndex = 0;

    private static FontRenderContext getDefaultFrc() {
        if (DEFAULT_FRC == null) {
            AffineTransform affineTransform = GraphicsEnvironment.isHeadless() ? new AffineTransform() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
            DEFAULT_FRC = new FontRenderContext(affineTransform, false, false);
        }
        return DEFAULT_FRC;
    }

    public static FontDesignMetrics getMetrics(Font font) {
        return FontDesignMetrics.getMetrics(font, FontDesignMetrics.getDefaultFrc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static FontDesignMetrics getMetrics(Font font, FontRenderContext fontRenderContext) {
        Object object;
        KeyReference keyReference;
        SunFontManager sunFontManager = SunFontManager.getInstance();
        if (sunFontManager.maybeUsingAlternateCompositeFonts() && FontUtilities.getFont2D(font) instanceof CompositeFont) {
            return new FontDesignMetrics(font, fontRenderContext);
        }
        FontDesignMetrics fontDesignMetrics = null;
        boolean bl = fontRenderContext.equals(FontDesignMetrics.getDefaultFrc());
        if (bl) {
            keyReference = metricsCache.get(font);
        } else {
            object = MetricsKey.class;
            // MONITORENTER : sun.font.FontDesignMetrics$MetricsKey.class
            MetricsKey.key.init(font, fontRenderContext);
            keyReference = metricsCache.get(MetricsKey.key);
            // MONITOREXIT : object
        }
        if (keyReference != null) {
            fontDesignMetrics = (FontDesignMetrics)keyReference.get();
        }
        if (fontDesignMetrics == null) {
            fontDesignMetrics = new FontDesignMetrics(font, fontRenderContext);
            if (bl) {
                metricsCache.put(font, new KeyReference(font, fontDesignMetrics));
            } else {
                object = new MetricsKey(font, fontRenderContext);
                metricsCache.put(object, new KeyReference(object, fontDesignMetrics));
            }
        }
        for (int i = 0; i < recentMetrics.length; ++i) {
            if (recentMetrics[i] != fontDesignMetrics) continue;
            return fontDesignMetrics;
        }
        FontDesignMetrics[] fontDesignMetricsArray = recentMetrics;
        // MONITORENTER : recentMetrics
        FontDesignMetrics.recentMetrics[FontDesignMetrics.recentIndex++] = fontDesignMetrics;
        if (recentIndex == 5) {
            recentIndex = 0;
        }
        // MONITOREXIT : fontDesignMetricsArray
        return fontDesignMetrics;
    }

    private FontDesignMetrics(Font font) {
        this(font, FontDesignMetrics.getDefaultFrc());
    }

    private FontDesignMetrics(Font font, FontRenderContext fontRenderContext) {
        super(font);
        this.font = font;
        this.frc = fontRenderContext;
        this.isAntiAliased = fontRenderContext.isAntiAliased();
        this.usesFractionalMetrics = fontRenderContext.usesFractionalMetrics();
        this.frcTx = fontRenderContext.getTransform();
        this.matrix = new double[4];
        this.initMatrixAndMetrics();
        this.initAdvCache();
    }

    private void initMatrixAndMetrics() {
        Font2D font2D = FontUtilities.getFont2D(this.font);
        this.fontStrike = font2D.getStrike(this.font, this.frc);
        StrikeMetrics strikeMetrics = this.fontStrike.getFontMetrics();
        this.ascent = strikeMetrics.getAscent();
        this.descent = strikeMetrics.getDescent();
        this.leading = strikeMetrics.getLeading();
        this.maxAdvance = strikeMetrics.getMaxAdvance();
        this.devmatrix = new double[4];
        this.frcTx.getMatrix(this.devmatrix);
    }

    private void initAdvCache() {
        this.advCache = new float[256];
        for (int i = 0; i < 256; ++i) {
            this.advCache[i] = -1.0f;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serVersion != 1) {
            this.frc = FontDesignMetrics.getDefaultFrc();
            this.isAntiAliased = this.frc.isAntiAliased();
            this.usesFractionalMetrics = this.frc.usesFractionalMetrics();
            this.frcTx = this.frc.getTransform();
        } else {
            this.frc = new FontRenderContext(this.frcTx, this.isAntiAliased, this.usesFractionalMetrics);
        }
        this.height = -1;
        this.cache = null;
        this.initMatrixAndMetrics();
        this.initAdvCache();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.cache = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.cache[i] = -1;
        }
        this.serVersion = 1;
        objectOutputStream.defaultWriteObject();
        this.cache = null;
    }

    private float handleCharWidth(int n) {
        return this.fontStrike.getCodePointAdvance(n);
    }

    private float getLatinCharWidth(char c) {
        float f = this.advCache[c];
        if (f == -1.0f) {
            this.advCache[c] = f = this.handleCharWidth(c);
        }
        return f;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    @Override
    public int charWidth(char c) {
        float f = c < '\u0100' ? this.getLatinCharWidth(c) : this.handleCharWidth(c);
        return (int)(0.5 + (double)f);
    }

    @Override
    public int charWidth(int n) {
        if (!Character.isValidCodePoint(n)) {
            n = 65535;
        }
        float f = this.handleCharWidth(n);
        return (int)(0.5 + (double)f);
    }

    @Override
    public int stringWidth(String string) {
        float f = 0.0f;
        if (this.font.hasLayoutAttributes()) {
            if (string == null) {
                throw new NullPointerException("str is null");
            }
            if (string.length() == 0) {
                return 0;
            }
            f = new TextLayout(string, this.font, this.frc).getAdvance();
        } else {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c < '\u0100') {
                    f += this.getLatinCharWidth(c);
                    continue;
                }
                if (FontUtilities.isNonSimpleChar(c)) {
                    f = new TextLayout(string, this.font, this.frc).getAdvance();
                    break;
                }
                f += this.handleCharWidth(c);
            }
        }
        return (int)(0.5 + (double)f);
    }

    @Override
    public int charsWidth(char[] cArray, int n, int n2) {
        float f = 0.0f;
        if (this.font.hasLayoutAttributes()) {
            if (n2 == 0) {
                return 0;
            }
            String string = new String(cArray, n, n2);
            f = new TextLayout(string, this.font, this.frc).getAdvance();
        } else {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("len=" + n2);
            }
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if (c < '\u0100') {
                    f += this.getLatinCharWidth(c);
                    continue;
                }
                if (FontUtilities.isNonSimpleChar(c)) {
                    String string = new String(cArray, n, n2);
                    f = new TextLayout(string, this.font, this.frc).getAdvance();
                    break;
                }
                f += this.handleCharWidth(c);
            }
        }
        return (int)(0.5 + (double)f);
    }

    @Override
    public int[] getWidths() {
        int[] nArray = new int[256];
        for (int n = 0; n < 256; n = (int)((char)(n + 1))) {
            float f = this.advCache[n];
            if (f == -1.0f) {
                f = this.advCache[n] = this.handleCharWidth(n);
            }
            nArray[n] = (int)(0.5 + (double)f);
        }
        return nArray;
    }

    @Override
    public int getMaxAdvance() {
        return (int)(0.99f + this.maxAdvance);
    }

    @Override
    public int getAscent() {
        return (int)(roundingUpValue + this.ascent);
    }

    @Override
    public int getDescent() {
        return (int)(roundingUpValue + this.descent);
    }

    @Override
    public int getLeading() {
        return (int)(roundingUpValue + this.descent + this.leading) - (int)(roundingUpValue + this.descent);
    }

    @Override
    public int getHeight() {
        if (this.height < 0) {
            this.height = this.getAscent() + (int)(roundingUpValue + this.descent + this.leading);
        }
        return this.height;
    }

    private static class KeyReference
    extends SoftReference
    implements DisposerRecord,
    Disposer.PollDisposable {
        static ReferenceQueue queue = Disposer.getQueue();
        Object key;

        KeyReference(Object object, Object object2) {
            super(object2, queue);
            this.key = object;
            Disposer.addReference(this, this);
        }

        @Override
        public void dispose() {
            if (metricsCache.get(this.key) == this) {
                metricsCache.remove(this.key);
            }
        }
    }

    private static class MetricsKey {
        Font font;
        FontRenderContext frc;
        int hash;
        static final MetricsKey key = new MetricsKey();

        MetricsKey() {
        }

        MetricsKey(Font font, FontRenderContext fontRenderContext) {
            this.init(font, fontRenderContext);
        }

        void init(Font font, FontRenderContext fontRenderContext) {
            this.font = font;
            this.frc = fontRenderContext;
            this.hash = font.hashCode() + fontRenderContext.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MetricsKey)) {
                return false;
            }
            return this.font.equals(((MetricsKey)object).font) && this.frc.equals(((MetricsKey)object).frc);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

