/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class JPasswordField
extends JTextField {
    private static final String uiClassID = "PasswordFieldUI";
    private char echoChar;
    private boolean echoCharSet = false;

    public JPasswordField() {
        this(null, null, 0);
    }

    public JPasswordField(String string) {
        this(null, string, 0);
    }

    public JPasswordField(int n) {
        this(null, null, n);
    }

    public JPasswordField(String string, int n) {
        this(null, string, n);
    }

    public JPasswordField(Document document, String string, int n) {
        super(document, string, n);
        this.enableInputMethods(false);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (!this.echoCharSet) {
            this.echoChar = (char)42;
        }
        super.updateUI();
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
        this.echoCharSet = true;
        this.repaint();
        this.revalidate();
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    @Override
    public void cut() {
        if (this.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.cut();
        }
    }

    @Override
    public void copy() {
        if (this.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.copy();
        }
    }

    @Override
    @Deprecated
    public String getText() {
        return super.getText();
    }

    @Override
    @Deprecated
    public String getText(int n, int n2) throws BadLocationException {
        return super.getText(n, n2);
    }

    public char[] getPassword() {
        Document document = this.getDocument();
        Segment segment = new Segment();
        try {
            document.getText(0, document.getLength(), segment);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        char[] cArray = new char[segment.count];
        System.arraycopy(segment.array, segment.offset, cArray, 0, segment.count);
        return cArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",echoChar=" + this.echoChar;
    }

    boolean customSetUIProperty(String string, Object object) {
        if (string == "echoChar") {
            if (!this.echoCharSet) {
                this.setEchoChar(((Character)object).charValue());
                this.echoCharSet = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPasswordField();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJPasswordField
    extends JTextField.AccessibleJTextField {
        protected AccessibleJPasswordField() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PASSWORD_TEXT;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this;
        }

        private String getEchoString(String string) {
            if (string == null) {
                return null;
            }
            char[] cArray = new char[string.length()];
            Arrays.fill(cArray, JPasswordField.this.getEchoChar());
            return new String(cArray);
        }

        @Override
        public String getAtIndex(int n, int n2) {
            String string = null;
            if (n == 1) {
                string = super.getAtIndex(n, n2);
            } else {
                char[] cArray = JPasswordField.this.getPassword();
                if (cArray == null || n2 < 0 || n2 >= cArray.length) {
                    return null;
                }
                string = new String(cArray);
            }
            return this.getEchoString(string);
        }

        @Override
        public String getAfterIndex(int n, int n2) {
            if (n == 1) {
                String string = super.getAfterIndex(n, n2);
                return this.getEchoString(string);
            }
            return null;
        }

        @Override
        public String getBeforeIndex(int n, int n2) {
            if (n == 1) {
                String string = super.getBeforeIndex(n, n2);
                return this.getEchoString(string);
            }
            return null;
        }

        @Override
        public String getTextRange(int n, int n2) {
            String string = super.getTextRange(n, n2);
            return this.getEchoString(string);
        }

        @Override
        public AccessibleTextSequence getTextSequenceAt(int n, int n2) {
            if (n == 1) {
                AccessibleTextSequence accessibleTextSequence = super.getTextSequenceAt(n, n2);
                if (accessibleTextSequence == null) {
                    return null;
                }
                return new AccessibleTextSequence(accessibleTextSequence.startIndex, accessibleTextSequence.endIndex, this.getEchoString(accessibleTextSequence.text));
            }
            char[] cArray = JPasswordField.this.getPassword();
            if (cArray == null || n2 < 0 || n2 >= cArray.length) {
                return null;
            }
            String string = new String(cArray);
            return new AccessibleTextSequence(0, cArray.length - 1, this.getEchoString(string));
        }

        @Override
        public AccessibleTextSequence getTextSequenceAfter(int n, int n2) {
            if (n == 1) {
                AccessibleTextSequence accessibleTextSequence = super.getTextSequenceAfter(n, n2);
                if (accessibleTextSequence == null) {
                    return null;
                }
                return new AccessibleTextSequence(accessibleTextSequence.startIndex, accessibleTextSequence.endIndex, this.getEchoString(accessibleTextSequence.text));
            }
            return null;
        }

        @Override
        public AccessibleTextSequence getTextSequenceBefore(int n, int n2) {
            if (n == 1) {
                AccessibleTextSequence accessibleTextSequence = super.getTextSequenceBefore(n, n2);
                if (accessibleTextSequence == null) {
                    return null;
                }
                return new AccessibleTextSequence(accessibleTextSequence.startIndex, accessibleTextSequence.endIndex, this.getEchoString(accessibleTextSequence.text));
            }
            return null;
        }
    }
}

