/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.Serializable;
import javax.management.remote.TargetedNotification;

public class NotificationResult
implements Serializable {
    private static final long serialVersionUID = 1191800228721395279L;
    private final long earliestSequenceNumber;
    private final long nextSequenceNumber;
    private final TargetedNotification[] targetedNotifications;

    public NotificationResult(long l, long l2, TargetedNotification[] targetedNotificationArray) {
        if (targetedNotificationArray == null) {
            throw new IllegalArgumentException("Notifications null");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("Bad sequence numbers");
        }
        this.earliestSequenceNumber = l;
        this.nextSequenceNumber = l2;
        this.targetedNotifications = targetedNotificationArray.length == 0 ? targetedNotificationArray : (TargetedNotification[])targetedNotificationArray.clone();
    }

    public long getEarliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    public long getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    public TargetedNotification[] getTargetedNotifications() {
        return this.targetedNotifications.length == 0 ? this.targetedNotifications : (TargetedNotification[])this.targetedNotifications.clone();
    }

    public String toString() {
        return "NotificationResult: earliest=" + this.getEarliestSequenceNumber() + "; next=" + this.getNextSequenceNumber() + "; nnotifs=" + this.getTargetedNotifications().length;
    }
}

