/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class JumboEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private static final long serialVersionUID = 334349849919042784L;
    private long[] elements;
    private int size = 0;

    JumboEnumSet(Class<E> clazz, Enum[] enumArray) {
        super(clazz, enumArray);
        this.elements = new long[enumArray.length + 63 >>> 6];
    }

    @Override
    void addRange(E e, E e2) {
        int n;
        int n2 = ((Enum)e).ordinal() >>> 6;
        if (n2 == (n = ((Enum)e2).ordinal() >>> 6)) {
            this.elements[n2] = -1L >>> ((Enum)e).ordinal() - ((Enum)e2).ordinal() - 1 << ((Enum)e).ordinal();
        } else {
            this.elements[n2] = -1L << ((Enum)e).ordinal();
            for (int i = n2 + 1; i < n; ++i) {
                this.elements[i] = -1L;
            }
            this.elements[n] = -1L >>> 63 - ((Enum)e2).ordinal();
        }
        this.size = ((Enum)e2).ordinal() - ((Enum)e).ordinal() + 1;
    }

    @Override
    void addAll() {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = -1L;
        }
        int n = this.elements.length - 1;
        this.elements[n] = this.elements[n] >>> -this.universe.length;
        this.size = this.universe.length;
    }

    @Override
    void complement() {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = this.elements[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n = this.elements.length - 1;
        this.elements[n] = this.elements[n] & -1L >>> -this.universe.length;
        this.size = this.universe.length - this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new EnumSetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (clazz != this.elementType && clazz.getSuperclass() != this.elementType) {
            return false;
        }
        int n = ((Enum)object).ordinal();
        return (this.elements[n >>> 6] & 1L << n) != 0L;
    }

    @Override
    public boolean add(E e) {
        boolean bl;
        this.typeCheck(e);
        int n = ((Enum)e).ordinal();
        int n2 = n >>> 6;
        long l = this.elements[n2];
        int n3 = n2;
        this.elements[n3] = this.elements[n3] | 1L << n;
        boolean bl2 = bl = this.elements[n2] != l;
        if (bl) {
            ++this.size;
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (clazz != this.elementType && clazz.getSuperclass() != this.elementType) {
            return false;
        }
        int n = ((Enum)object).ordinal();
        int n2 = n >>> 6;
        long l = this.elements[n2];
        int n3 = n2;
        this.elements[n3] = this.elements[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
        boolean bl2 = bl = this.elements[n2] != l;
        if (bl) {
            --this.size;
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (!(collection instanceof JumboEnumSet)) {
            return super.containsAll(collection);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)collection;
        if (jumboEnumSet.elementType != this.elementType) {
            return jumboEnumSet.isEmpty();
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if ((jumboEnumSet.elements[i] & (this.elements[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (!(collection instanceof JumboEnumSet)) {
            return super.addAll(collection);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)collection;
        if (jumboEnumSet.elementType != this.elementType) {
            if (jumboEnumSet.isEmpty()) {
                return false;
            }
            throw new ClassCastException(jumboEnumSet.elementType + " != " + this.elementType);
        }
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] | jumboEnumSet.elements[i];
        }
        return this.recalculateSize();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (!(collection instanceof JumboEnumSet)) {
            return super.removeAll(collection);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)collection;
        if (jumboEnumSet.elementType != this.elementType) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] & (jumboEnumSet.elements[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this.recalculateSize();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (!(collection instanceof JumboEnumSet)) {
            return super.retainAll(collection);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)collection;
        if (jumboEnumSet.elementType != this.elementType) {
            boolean bl = this.size != 0;
            this.clear();
            return bl;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] & jumboEnumSet.elements[i];
        }
        return this.recalculateSize();
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, 0L);
        this.size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof JumboEnumSet)) {
            return super.equals(object);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)object;
        if (jumboEnumSet.elementType != this.elementType) {
            return this.size == 0 && jumboEnumSet.size == 0;
        }
        return Arrays.equals(jumboEnumSet.elements, this.elements);
    }

    private boolean recalculateSize() {
        int n = this.size;
        this.size = 0;
        for (long l : this.elements) {
            this.size += Long.bitCount(l);
        }
        return this.size != n;
    }

    @Override
    public EnumSet<E> clone() {
        JumboEnumSet jumboEnumSet = (JumboEnumSet)super.clone();
        jumboEnumSet.elements = (long[])jumboEnumSet.elements.clone();
        return jumboEnumSet;
    }

    private class EnumSetIterator<E extends Enum<E>>
    implements Iterator<E> {
        long unseen;
        int unseenIndex = 0;
        long lastReturned = 0L;
        int lastReturnedIndex = 0;

        EnumSetIterator() {
            this.unseen = JumboEnumSet.this.elements[0];
        }

        @Override
        public boolean hasNext() {
            while (this.unseen == 0L && this.unseenIndex < JumboEnumSet.this.elements.length - 1) {
                this.unseen = JumboEnumSet.this.elements[++this.unseenIndex];
            }
            return this.unseen != 0L;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.unseen & -this.unseen;
            this.lastReturnedIndex = this.unseenIndex;
            this.unseen -= this.lastReturned;
            return (E)JumboEnumSet.this.universe[(this.lastReturnedIndex << 6) + Long.numberOfTrailingZeros(this.lastReturned)];
        }

        @Override
        public void remove() {
            if (this.lastReturned == 0L) {
                throw new IllegalStateException();
            }
            long l = JumboEnumSet.this.elements[this.lastReturnedIndex];
            long[] lArray = JumboEnumSet.this.elements;
            int n = this.lastReturnedIndex;
            lArray[n] = lArray[n] & (this.lastReturned ^ 0xFFFFFFFFFFFFFFFFL);
            if (l != JumboEnumSet.this.elements[this.lastReturnedIndex]) {
                JumboEnumSet.this.size--;
            }
            this.lastReturned = 0L;
        }
    }
}

