/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLExtensible;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLExtension;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLObject;
import com.sun.xml.internal.ws.model.wsdl.AbstractObjectImpl;
import com.sun.xml.internal.ws.resources.UtilMessages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.xml.sax.Locator;

abstract class AbstractExtensibleImpl
extends AbstractObjectImpl
implements WSDLExtensible {
    protected final Set<WSDLExtension> extensions = new HashSet<WSDLExtension>();
    protected List<UnknownWSDLExtension> notUnderstoodExtensions = new ArrayList<UnknownWSDLExtension>();

    protected AbstractExtensibleImpl(XMLStreamReader xMLStreamReader) {
        super(xMLStreamReader);
    }

    protected AbstractExtensibleImpl(String string, int n) {
        super(string, n);
    }

    @Override
    public final Iterable<WSDLExtension> getExtensions() {
        return this.extensions;
    }

    @Override
    public final <T extends WSDLExtension> Iterable<T> getExtensions(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>(this.extensions.size());
        for (WSDLExtension wSDLExtension : this.extensions) {
            if (!clazz.isInstance(wSDLExtension)) continue;
            arrayList.add(clazz.cast(wSDLExtension));
        }
        return arrayList;
    }

    @Override
    public <T extends WSDLExtension> T getExtension(Class<T> clazz) {
        for (WSDLExtension wSDLExtension : this.extensions) {
            if (!clazz.isInstance(wSDLExtension)) continue;
            return (T)((WSDLExtension)clazz.cast(wSDLExtension));
        }
        return null;
    }

    @Override
    public void addExtension(WSDLExtension wSDLExtension) {
        if (wSDLExtension == null) {
            throw new IllegalArgumentException();
        }
        this.extensions.add(wSDLExtension);
    }

    public void addNotUnderstoodExtension(QName qName, Locator locator) {
        this.notUnderstoodExtensions.add(new UnknownWSDLExtension(qName, locator));
    }

    public boolean areRequiredExtensionsUnderstood() {
        if (this.notUnderstoodExtensions.size() != 0) {
            StringBuilder stringBuilder = new StringBuilder("Unknown WSDL extensibility elements:");
            for (UnknownWSDLExtension unknownWSDLExtension : this.notUnderstoodExtensions) {
                stringBuilder.append('\n').append(unknownWSDLExtension.toString());
            }
            throw new WebServiceException(stringBuilder.toString());
        }
        return true;
    }

    protected static class UnknownWSDLExtension
    implements WSDLExtension,
    WSDLObject {
        private final QName extnEl;
        private final Locator locator;

        public UnknownWSDLExtension(QName qName, Locator locator) {
            this.extnEl = qName;
            this.locator = locator;
        }

        @Override
        public QName getName() {
            return this.extnEl;
        }

        @Override
        @NotNull
        public Locator getLocation() {
            return this.locator;
        }

        public String toString() {
            return this.extnEl + " " + UtilMessages.UTIL_LOCATION(this.locator.getLineNumber(), this.locator.getSystemId());
        }
    }
}

