/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.org.glassfish.gmbal.ManagedObjectManager;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.internal.ws.api.config.management.ManagedEndpointFactory;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.internal.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.EndpointComponent;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.api.server.ServiceDefinition;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.server.EndpointFactory;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import org.xml.sax.EntityResolver;

public abstract class WSEndpoint<T> {
    @NotNull
    public abstract Codec createCodec();

    @NotNull
    public abstract QName getServiceName();

    @NotNull
    public abstract QName getPortName();

    @NotNull
    public abstract Class<T> getImplementationClass();

    @NotNull
    public abstract WSBinding getBinding();

    @NotNull
    public abstract Container getContainer();

    @Nullable
    public abstract WSDLPort getPort();

    public abstract void setExecutor(@NotNull Executor var1);

    public final void schedule(@NotNull Packet packet, @NotNull CompletionCallback completionCallback) {
        this.schedule(packet, completionCallback, null);
    }

    public abstract void schedule(@NotNull Packet var1, @NotNull CompletionCallback var2, @Nullable FiberContextSwitchInterceptor var3);

    public void process(@NotNull Packet packet, @NotNull CompletionCallback completionCallback, @Nullable FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        this.schedule(packet, completionCallback, fiberContextSwitchInterceptor);
    }

    @NotNull
    public abstract PipeHead createPipeHead();

    public abstract void dispose();

    @Nullable
    public abstract ServiceDefinition getServiceDefinition();

    @NotNull
    public abstract Set<EndpointComponent> getComponentRegistry();

    @Nullable
    public abstract SEIModel getSEIModel();

    public abstract PolicyMap getPolicyMap();

    @NotNull
    public abstract ManagedObjectManager getManagedObjectManager();

    public abstract void closeManagedObjectManager();

    @NotNull
    public abstract ServerTubeAssemblerContext getAssemblerContext();

    public static <T> WSEndpoint<T> create(@NotNull Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, @Nullable EntityResolver entityResolver, boolean bl2) {
        WSEndpoint<T> wSEndpoint = EndpointFactory.createEndpoint(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, entityResolver, bl2);
        wSEndpoint.getManagedObjectManager().resumeJMXRegistration();
        Iterator<ManagedEndpointFactory> iterator = ServiceFinder.find(ManagedEndpointFactory.class).iterator();
        if (iterator.hasNext()) {
            ManagedEndpointFactory managedEndpointFactory = iterator.next();
            EndpointCreationAttributes endpointCreationAttributes = new EndpointCreationAttributes(bl, invoker, entityResolver, bl2);
            return managedEndpointFactory.createEndpoint(wSEndpoint, endpointCreationAttributes);
        }
        return wSEndpoint;
    }

    @Deprecated
    public static <T> WSEndpoint<T> create(@NotNull Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, @Nullable EntityResolver entityResolver) {
        return WSEndpoint.create(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, entityResolver, false);
    }

    public static <T> WSEndpoint<T> create(@NotNull Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, @Nullable URL uRL) {
        return WSEndpoint.create(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, XmlUtil.createEntityResolver(uRL), false);
    }

    @NotNull
    public static QName getDefaultServiceName(Class clazz) {
        return EndpointFactory.getDefaultServiceName(clazz);
    }

    @NotNull
    public static QName getDefaultPortName(@NotNull QName qName, Class clazz) {
        return EndpointFactory.getDefaultPortName(qName, clazz);
    }

    public static interface CompletionCallback {
        public void onCompletion(@NotNull Packet var1);
    }

    public static interface PipeHead {
        @NotNull
        public Packet process(@NotNull Packet var1, @Nullable WebServiceContextDelegate var2, @Nullable TransportBackChannel var3);
    }
}

