/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.ctx;

import com.sun.jndi.toolkit.ctx.Continuation;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import javax.naming.spi.Resolver;

public abstract class PartialCompositeContext
implements Context,
Resolver {
    protected static final int _PARTIAL = 1;
    protected static final int _COMPONENT = 2;
    protected static final int _ATOMIC = 3;
    protected int _contextType = 1;
    static final CompositeName _EMPTY_NAME = new CompositeName();
    static CompositeName _NNS_NAME;

    protected PartialCompositeContext() {
    }

    protected abstract ResolveResult p_resolveToClass(Name var1, Class var2, Continuation var3) throws NamingException;

    protected abstract Object p_lookup(Name var1, Continuation var2) throws NamingException;

    protected abstract Object p_lookupLink(Name var1, Continuation var2) throws NamingException;

    protected abstract NamingEnumeration p_list(Name var1, Continuation var2) throws NamingException;

    protected abstract NamingEnumeration p_listBindings(Name var1, Continuation var2) throws NamingException;

    protected abstract void p_bind(Name var1, Object var2, Continuation var3) throws NamingException;

    protected abstract void p_rebind(Name var1, Object var2, Continuation var3) throws NamingException;

    protected abstract void p_unbind(Name var1, Continuation var2) throws NamingException;

    protected abstract void p_destroySubcontext(Name var1, Continuation var2) throws NamingException;

    protected abstract Context p_createSubcontext(Name var1, Continuation var2) throws NamingException;

    protected abstract void p_rename(Name var1, Name var2, Continuation var3) throws NamingException;

    protected abstract NameParser p_getNameParser(Name var1, Continuation var2) throws NamingException;

    protected Hashtable p_getEnvironment() throws NamingException {
        return this.getEnvironment();
    }

    @Override
    public ResolveResult resolveToClass(String string, Class<? extends Context> clazz) throws NamingException {
        return this.resolveToClass(new CompositeName(string), clazz);
    }

    @Override
    public ResolveResult resolveToClass(Name name, Class<? extends Context> clazz) throws NamingException {
        ResolveResult resolveResult;
        PartialCompositeContext partialCompositeContext = this;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        Name name2 = name;
        try {
            resolveResult = partialCompositeContext.p_resolveToClass(name2, clazz, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                resolveResult = partialCompositeContext.p_resolveToClass(name2, clazz, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            if (!(context instanceof Resolver)) {
                throw cannotProceedException;
            }
            resolveResult = ((Resolver)((Object)context)).resolveToClass(cannotProceedException.getRemainingName(), clazz);
        }
        return resolveResult;
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object object;
        PartialCompositeContext partialCompositeContext = this;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        Name name2 = name;
        try {
            object = partialCompositeContext.p_lookup(name2, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                object = partialCompositeContext.p_lookup(name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            object = context.lookup(cannotProceedException.getRemainingName());
        }
        return object;
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        PartialCompositeContext partialCompositeContext = this;
        Name name2 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            partialCompositeContext.p_bind(name2, object, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                partialCompositeContext.p_bind(name2, object, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            context.bind(cannotProceedException.getRemainingName(), object);
        }
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        PartialCompositeContext partialCompositeContext = this;
        Name name2 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            partialCompositeContext.p_rebind(name2, object, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                partialCompositeContext.p_rebind(name2, object, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            context.rebind(cannotProceedException.getRemainingName(), object);
        }
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        PartialCompositeContext partialCompositeContext = this;
        Name name2 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            partialCompositeContext.p_unbind(name2, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                partialCompositeContext.p_unbind(name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            context.unbind(cannotProceedException.getRemainingName());
        }
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        PartialCompositeContext partialCompositeContext = this;
        Name name3 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            partialCompositeContext.p_rename(name3, name2, continuation);
            while (continuation.isContinue()) {
                name3 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                partialCompositeContext.p_rename(name3, name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            if (cannotProceedException.getRemainingNewName() != null) {
                name2 = cannotProceedException.getRemainingNewName();
            }
            context.rename(cannotProceedException.getRemainingName(), name2);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        NamingEnumeration namingEnumeration;
        PartialCompositeContext partialCompositeContext = this;
        Name name2 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            namingEnumeration = partialCompositeContext.p_list(name2, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                namingEnumeration = partialCompositeContext.p_list(name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            namingEnumeration = context.list(cannotProceedException.getRemainingName());
        }
        return namingEnumeration;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.listBindings(new CompositeName(string));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        NamingEnumeration namingEnumeration;
        PartialCompositeContext partialCompositeContext = this;
        Name name2 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            namingEnumeration = partialCompositeContext.p_listBindings(name2, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                namingEnumeration = partialCompositeContext.p_listBindings(name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            namingEnumeration = context.listBindings(cannotProceedException.getRemainingName());
        }
        return namingEnumeration;
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(new CompositeName(string));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        PartialCompositeContext partialCompositeContext = this;
        Name name2 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            partialCompositeContext.p_destroySubcontext(name2, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                partialCompositeContext.p_destroySubcontext(name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            context.destroySubcontext(cannotProceedException.getRemainingName());
        }
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Context context;
        PartialCompositeContext partialCompositeContext = this;
        Name name2 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            context = partialCompositeContext.p_createSubcontext(name2, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                context = partialCompositeContext.p_createSubcontext(name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context2 = NamingManager.getContinuationContext(cannotProceedException);
            context = context2.createSubcontext(cannotProceedException.getRemainingName());
        }
        return context;
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(new CompositeName(string));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Object object;
        PartialCompositeContext partialCompositeContext = this;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        Name name2 = name;
        try {
            object = partialCompositeContext.p_lookupLink(name2, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                object = partialCompositeContext.p_lookupLink(name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            object = context.lookupLink(cannotProceedException.getRemainingName());
        }
        return object;
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser(new CompositeName(string));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        NameParser nameParser;
        PartialCompositeContext partialCompositeContext = this;
        Name name2 = name;
        Hashtable hashtable = this.p_getEnvironment();
        Continuation continuation = new Continuation(name, hashtable);
        try {
            nameParser = partialCompositeContext.p_getNameParser(name2, continuation);
            while (continuation.isContinue()) {
                name2 = continuation.getRemainingName();
                partialCompositeContext = PartialCompositeContext.getPCContext(continuation);
                nameParser = partialCompositeContext.p_getNameParser(name2, continuation);
            }
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            nameParser = context.getNameParser(cannotProceedException.getRemainingName());
        }
        return nameParser;
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        if (name == null) {
            return name3;
        }
        name3.addAll(name);
        String string = (String)this.p_getEnvironment().get("java.naming.provider.compose.elideEmpty");
        if (string == null || !string.equalsIgnoreCase("true")) {
            return name3;
        }
        int n = name2.size();
        if (!PartialCompositeContext.allEmpty(name2) && !PartialCompositeContext.allEmpty(name)) {
            if (name3.get(n - 1).equals("")) {
                name3.remove(n - 1);
            } else if (name3.get(n).equals("")) {
                name3.remove(n);
            }
        }
        return name3;
    }

    protected static boolean allEmpty(Name name) {
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected static PartialCompositeContext getPCContext(Continuation continuation) throws NamingException {
        Object object = continuation.getResolvedObj();
        Object var2_2 = null;
        if (object instanceof PartialCompositeContext) {
            return (PartialCompositeContext)object;
        }
        throw continuation.fillInException(new CannotProceedException());
    }

    static {
        try {
            _NNS_NAME = new CompositeName("/");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }
}

