/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

import com.sun.jmx.mbeanserver.Util;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class CacheMap<K, V>
extends WeakHashMap<K, V> {
    private final LinkedList<SoftReference<K>> cache = new LinkedList();
    private final int nSoftReferences;

    public CacheMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("nSoftReferences = " + n);
        }
        this.nSoftReferences = n;
    }

    @Override
    public V put(K k, V v) {
        this.cache(k);
        return super.put(k, v);
    }

    @Override
    public V get(Object object) {
        this.cache(Util.cast(object));
        return super.get(object);
    }

    private void cache(K k) {
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            SoftReference softReference = (SoftReference)iterator.next();
            Object t = softReference.get();
            if (t == null) {
                iterator.remove();
                continue;
            }
            if (!k.equals(t)) continue;
            iterator.remove();
            this.cache.add(0, softReference);
            return;
        }
        int n = this.cache.size();
        if (n == this.nSoftReferences) {
            if (n == 0) {
                return;
            }
            iterator.remove();
        }
        this.cache.add(0, new SoftReference<K>(k));
    }
}

