import moonlander.library.*;
import ddf.minim.*;

int CANVAS_WIDTH = 1280;
int CANVAS_HEIGHT = 720;
int radius;

ArrayList<Line> usedLines = new ArrayList<Line>();
ArrayList<Line> lines = new ArrayList<Line>(); 
int mils;
int newX, newY;

Moonlander moonlander;

void setup() {
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P3D);
  frameRate(60);
  radius = (int)(CANVAS_HEIGHT / 3);

  moonlander = Moonlander.initWithSoundtrack(this, "Catnip.mp3", 182, 8);

  moonlander.start();
  
  int count = 15;
  int kulma = (int)(360 / count);
  // Set up all the lines
  for (int s = 0; s < count; s++){
   coordinate start = new coordinate(returnX(0, radius, s * kulma), returnY(0, radius, s * kulma));   
   for (int e = 0; e < count; e++){
     if (e != s){      
       coordinate end = new coordinate(returnX(0, radius, e * kulma), returnY(0, radius, e * kulma));
        if (!amIThere(new Line(start, end))){       
         lines.add(new Line(start, end));
        }       
     }
   }
  }
}

void draw() {
  
  moonlander.update();
  int phase = (int)moonlander.getValue("phase");
  int speed = (int)moonlander.getValue("speed");
  int bgcolor = (int)moonlander.getValue("bgcolor");
  int zAxis = (int)moonlander.getValue("z");
  float volume = (float)moonlander.getValue("volume");
  int moveMe = (int)moonlander.getValue("move");
  background(bgcolor);
  
  translate(CANVAS_WIDTH / 2, CANVAS_HEIGHT / 2, 0);
   
  if (phase == 1){
    translate(0, 0, 0);
    if (millis() - speed > mils && lines.size() > 0){    
    //int random = floor(random(0, lines.size()));
    smooth();
    // draw random line
    Line l = lines.get(0);   
    line(l.getStart().getX(), l.getStart().getY(), l.getEnd().getX(), l.getEnd().getY());  
    strokeWeight(2);
    lines.remove(l);
    usedLines.add(l);   
    mils = millis();
  } 
    drawAll();  
    fill(0, 102, 153, 204);
  } else if (phase == 2){
    
     if (millis() - speed > mils && lines.size() > 0){
   pushMatrix();    
    //int random = floor(random(0, lines.size()));
    smooth();
    // draw random line
    Line l = lines.get(0);   
    line(l.getStart().getX(), l.getStart().getY(), l.getEnd().getX(), l.getEnd().getY());  
    strokeWeight(2);
    lines.remove(l);
    usedLines.add(l);   
    mils = millis();
    //text("Lines left: " + lines.size(), 0, 0);
    popMatrix();
  } 
    rotateZ(cos(millis() / 9500f) * 25);
    drawAll();
  } else if (phase == 3) {
    pushMatrix();
    translate(0, 0, moveMe);
    drawAll();
    popMatrix();
  } else if(phase == 4) {    
    //translate(0,0,moveMe);
    rotateY(cos(millis() / 10000f) * 25);
    drawAll();
  } else if(phase == 5) {
    pushMatrix();
    translate(0, 0, zAxis);
    fill(255);
    text("TEAM JUMIPALLO", 0, -30);
    textSize(32);
    textAlign(CENTER);
    textSize(24);
    text("proudly presents...", 0, 0);
    textSize(32);
    text("Sähköjänis", 0, 30);
    popMatrix();
  } else if (phase == 6) {    
    pushMatrix();
    translate(0, 0, moveMe);
    drawAll();
    popMatrix();
    pushMatrix();
    translate(0, 0, moveMe + 3000);
    fill(0);
    text("Thanks for watching", 0, -30);
    textSize(32);
    textAlign(CENTER);
    textSize(24);
    text("Music by: Pico Pico", 0, 0);
    popMatrix();
  } else if (phase == 7) {
     exit();
  }
}

void drawAll() {
  
  for(Line d: usedLines){
      smooth();
     stroke(255);
     line(d.getStart().getX(), d.getStart().getY(), d.getEnd().getX(), d.getEnd().getY());
  }
}

boolean amIThere (Line current){
 if (lines.size() > 0){
  for(Line l  : lines){
    int sX = l.getStart().getX();
    int sY = l.getStart().getY();
    int eX = l.getEnd().getX();
    int eY = l.getEnd().getY();
    if (eX == current.getStart().getX() && eY == current.getStart().getY() && sX == current.getEnd().getX() && sY == current.getEnd().getY()){
      return true;
    }
  }
 } 
 return false; 
}

int returnX (int x, int distance, int angle){
  return (int)(x + distance * Math.cos(radians(angle)));
}
int returnY (int y, int distance, int angle){
  return (int)(y + distance * Math.sin(radians(angle)));
}

public class coordinate{
  public int x;
  public int y;
  
  public coordinate(int x, int y){
    this.x = x;
    this.y = y; 
  }
  
  public int getX(){
    return this.x;
  }
  
  public int getY(){
    return this.y;
  }
}

class Line{
   coordinate start;   
   coordinate end;   
  
  public Line (coordinate start, coordinate end){
     this.start = start;
     this.end = end;
  } 
  
  public coordinate getStart(){
     return this.start; 
  }
  public coordinate getEnd(){
     return this.end; 
  }
}
