/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import sun.net.ResourceManager;

class TwoStacksPlainDatagramSocketImpl
extends AbstractPlainDatagramSocketImpl {
    private FileDescriptor fd1;
    private InetAddress anyLocalBoundAddr = null;
    private int fduse = -1;
    private int lastfd = -1;
    private final boolean exclusiveBind;
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;

    TwoStacksPlainDatagramSocketImpl(boolean bl) {
        this.exclusiveBind = bl;
    }

    @Override
    protected synchronized void create() throws SocketException {
        this.fd1 = new FileDescriptor();
        try {
            super.create();
        }
        catch (SocketException socketException) {
            this.fd1 = null;
            throw socketException;
        }
    }

    @Override
    protected synchronized void bind(int n, InetAddress inetAddress) throws SocketException {
        super.bind(n, inetAddress);
        if (inetAddress.isAnyLocalAddress()) {
            this.anyLocalBoundAddr = inetAddress;
        }
    }

    @Override
    protected synchronized void bind0(int n, InetAddress inetAddress) throws SocketException {
        this.bind0(n, inetAddress, this.exclusiveBind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        try {
            this.receive0(datagramPacket);
        }
        finally {
            this.fduse = -1;
        }
    }

    @Override
    public Object getOption(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        if (n == 15) {
            if (this.fd != null && this.fd1 != null) {
                return this.anyLocalBoundAddr;
            }
            return this.socketGetOption(n);
        }
        if (n == 4 && this.reuseAddressEmulated) {
            return this.isReuseAddress;
        }
        return super.getOption(n);
    }

    @Override
    protected void socketSetOption(int n, Object object) throws SocketException {
        if (n == 4 && this.exclusiveBind && this.localPort != 0) {
            this.reuseAddressEmulated = true;
            this.isReuseAddress = (Boolean)object;
        } else {
            this.socketNativeSetOption(n, object);
        }
    }

    @Override
    protected boolean isClosed() {
        return this.fd == null && this.fd1 == null;
    }

    @Override
    protected void close() {
        if (this.fd != null || this.fd1 != null) {
            this.datagramSocketClose();
            ResourceManager.afterUdpClose();
            this.fd = null;
            this.fd1 = null;
        }
    }

    protected synchronized native void bind0(int var1, InetAddress var2, boolean var3) throws SocketException;

    @Override
    protected native void send(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized native int peek(InetAddress var1) throws IOException;

    @Override
    protected synchronized native int peekData(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized native void receive0(DatagramPacket var1) throws IOException;

    @Override
    protected native void setTimeToLive(int var1) throws IOException;

    @Override
    protected native int getTimeToLive() throws IOException;

    @Override
    protected native void setTTL(byte var1) throws IOException;

    @Override
    protected native byte getTTL() throws IOException;

    @Override
    protected native void join(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void datagramSocketCreate() throws SocketException;

    @Override
    protected native void datagramSocketClose();

    protected native void socketNativeSetOption(int var1, Object var2) throws SocketException;

    @Override
    protected native Object socketGetOption(int var1) throws SocketException;

    @Override
    protected native void connect0(InetAddress var1, int var2) throws SocketException;

    @Override
    protected native void disconnect0(int var1);

    private static native void init();

    static {
        TwoStacksPlainDatagramSocketImpl.init();
    }
}

