/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioListener;
import ddf.minim.AudioSignal;
import ddf.minim.Minim;

public abstract class Oscillator
implements AudioSignal {
    protected static final float TWO_PI = (float)Math.PI * 2;
    private float freq;
    private float newFreq;
    private float srate;
    private float amp;
    private float newAmp;
    private float step;
    private float stepSize;
    private boolean port;
    private float portSpeed;
    private float portStep;
    private float pan;
    private float newPan;
    private float leftScale;
    private float rightScale;
    private AudioListener listener;
    private AudioSignal ampMod;
    private AudioSignal freqMod;
    private static float panAmpStep = 1.0E-4f;

    public Oscillator(float f, float f2, float f3) {
        this.newFreq = this.freq = f;
        this.newAmp = this.amp = f2;
        this.srate = f3;
        this.step = 0.0f;
        this.stepSize = this.freq / f3;
        this.port = false;
        this.portStep = 0.01f;
        this.pan = 0.0f;
        this.newPan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
        this.listener = null;
        this.ampMod = null;
        this.freqMod = null;
    }

    public final float sampleRate() {
        return this.srate;
    }

    public final void setFreq(float f) {
        this.newFreq = f;
        float f2 = (this.newFreq - this.freq) / this.portSpeed;
        float f3 = this.srate / 1000.0f;
        this.portStep = f2 / f3;
    }

    public final float frequency() {
        return this.freq;
    }

    public final void setAmp(float f) {
        this.newAmp = this.constrain(f, 0.0f, 1.0f);
    }

    public final float amplitude() {
        return this.amp;
    }

    public final void setPan(float f) {
        this.newPan = this.constrain(f, -1.0f, 1.0f);
    }

    public final void setPanNoGlide(float f) {
        this.setPan(f);
        this.pan = this.constrain(f, -1.0f, 1.0f);
    }

    public final float pan() {
        return this.pan;
    }

    public final void portamento(int n) {
        if (n <= 0) {
            Minim.error("Oscillator.portamento: The portamento speed must be greater than zero.");
        }
        this.port = true;
        this.portSpeed = n;
    }

    public final void noPortamento() {
        this.port = false;
    }

    private final void updateFreq() {
        if (this.freq != this.newFreq) {
            this.freq = this.port ? (Math.abs(this.freq - this.newFreq) < 0.1f ? this.newFreq : (this.freq += this.portStep)) : this.newFreq;
        }
        this.stepSize = this.freq / this.srate;
    }

    private final float generate(float f, float f2) {
        this.step += f;
        this.step -= (float)Math.floor(this.step);
        return this.amp * f2 * this.value(this.step);
    }

    @Override
    public final void generate(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        float[] fArray3 = new float[fArray.length];
        if (this.freqMod != null) {
            this.freqMod.generate(fArray2);
        }
        if (this.ampMod != null) {
            this.ampMod.generate(fArray3);
        }
        for (int i = 0; i < fArray.length; ++i) {
            this.updateFreq();
            fArray[i] = this.ampMod != null ? this.generate(fArray2[i], fArray3[i]) : this.generate(fArray2[i], 1.0f);
            this.monoStep();
        }
        if (this.listener != null) {
            this.listener.samples(fArray);
        }
    }

    @Override
    public final void generate(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length];
        float[] fArray4 = new float[fArray2.length];
        if (this.freqMod != null) {
            this.freqMod.generate(fArray3);
        }
        if (this.ampMod != null) {
            this.ampMod.generate(fArray4);
        }
        int n = 0;
        while (n < fArray.length) {
            this.updateFreq();
            fArray[n] = this.ampMod != null ? this.generate(fArray3[n], fArray4[n]) : this.generate(fArray3[n], 1.0f);
            fArray2[n] = fArray[n];
            int n2 = n;
            fArray[n2] = fArray[n2] * this.leftScale;
            int n3 = n++;
            fArray2[n3] = fArray2[n3] * this.rightScale;
            this.stereoStep();
        }
        if (this.listener != null) {
            this.listener.samples(fArray, fArray2);
        }
    }

    public final void setAudioListener(AudioListener audioListener) {
        this.listener = audioListener;
    }

    final void setAmplitudeModulator(AudioSignal audioSignal) {
        this.ampMod = audioSignal;
    }

    final void setFrequencyModulator(AudioSignal audioSignal) {
        this.freqMod = audioSignal;
    }

    private void monoStep() {
        this.stepStep();
        this.stepAmp();
    }

    private void stereoStep() {
        this.stepStep();
        this.stepAmp();
        this.calcLRScale();
        this.stepPan();
    }

    private void stepStep() {
        this.step += this.stepSize;
        this.step -= (float)Math.floor(this.step);
    }

    private void calcLRScale() {
        if (this.pan <= 0.0f) {
            this.rightScale = this.pan + 1.0f;
            this.leftScale = 1.0f;
        }
        if (this.pan >= 0.0f) {
            this.leftScale = 1.0f - this.pan;
            this.rightScale = 1.0f;
        }
        if (this.pan == 0.0f) {
            this.rightScale = 1.0f;
            this.leftScale = 1.0f;
        }
    }

    private void stepPan() {
        if (this.pan != this.newPan) {
            this.pan = this.pan < this.newPan ? (this.pan += panAmpStep) : (this.pan -= panAmpStep);
            if (Math.abs(this.pan - this.newPan) < panAmpStep) {
                this.pan = this.newPan;
            }
        }
    }

    private void stepAmp() {
        if (this.amp != this.newAmp) {
            this.amp = this.amp < this.newAmp ? (this.amp += panAmpStep) : (this.amp -= panAmpStep);
            if (Math.abs(this.amp - this.newAmp) < panAmpStep) {
                this.pan = this.newPan;
            }
        }
    }

    public final float period() {
        return 1.0f / this.freq;
    }

    protected abstract float value(float var1);

    float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }
}

