/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioInput;
import ddf.minim.AudioOutput;
import ddf.minim.AudioPlayer;
import ddf.minim.AudioRecorder;
import ddf.minim.AudioSample;
import ddf.minim.AudioSnippet;
import ddf.minim.AudioSource;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.Recordable;
import ddf.minim.javasound.JSMinim;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioRecording;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.AudioStream;
import ddf.minim.spi.MinimServiceProvider;
import ddf.minim.spi.SampleRecorder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Mixer;

public class Minim {
    public static final int MONO = 1;
    public static final int STEREO = 2;
    public static final int LOOP_CONTINUOUSLY = -1;
    public static AudioFileFormat.Type WAV = AudioFileFormat.Type.WAVE;
    public static AudioFileFormat.Type AIFF = AudioFileFormat.Type.AIFF;
    public static AudioFileFormat.Type AIFC = AudioFileFormat.Type.AIFC;
    public static AudioFileFormat.Type AU = AudioFileFormat.Type.AU;
    public static AudioFileFormat.Type SND = AudioFileFormat.Type.SND;
    private static boolean DEBUG = false;
    private MinimServiceProvider mimp = null;
    private ArrayList<AudioSource> sources = new ArrayList();
    private ArrayList<AudioStream> streams = new ArrayList();

    public Minim(Object object) {
        this((MinimServiceProvider)new JSMinim(object));
        Class<?> clazz = object.getClass().getSuperclass();
        if (clazz.getName() == "processing.core.PApplet") {
            try {
                Method method = clazz.getMethod("registerMethod", String.class, Object.class);
                method.invoke(object, "dispose", this);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public Minim(MinimServiceProvider minimServiceProvider) {
        this.mimp = minimServiceProvider;
        this.mimp.start();
    }

    public static void error(String string) {
        System.out.println("=== Minim Error ===");
        System.out.println("=== " + string);
        System.out.println();
    }

    public static void debug(String string) {
        if (DEBUG) {
            String[] stringArray = string.split("\n");
            System.out.println("=== Minim Debug ===");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("=== " + stringArray[i]);
            }
            System.out.println();
        }
    }

    public void debugOn() {
        DEBUG = true;
        if (this.mimp != null) {
            this.mimp.debugOn();
        }
    }

    public void debugOff() {
        DEBUG = false;
        if (this.mimp != null) {
            this.mimp.debugOff();
        }
    }

    public void dispose() {
        this.stop();
    }

    public void stop() {
        Minim.debug("Stopping Minim...");
        for (AudioSource object : this.sources) {
            object.parent = null;
            object.close();
        }
        this.sources.clear();
        for (AudioStream audioStream : this.streams) {
            audioStream.close();
        }
        this.mimp.stop();
    }

    void addSource(AudioSource audioSource) {
        this.sources.add(audioSource);
        audioSource.parent = this;
    }

    void removeSource(AudioSource audioSource) {
        this.sources.remove(audioSource);
    }

    @Deprecated
    public void setInputMixer(Mixer mixer) {
        if (this.mimp instanceof JSMinim) {
            ((JSMinim)this.mimp).setInputMixer(mixer);
        }
    }

    @Deprecated
    public void setOutputMixer(Mixer mixer) {
        if (this.mimp instanceof JSMinim) {
            ((JSMinim)this.mimp).setOutputMixer(mixer);
        }
    }

    public AudioSample createSample(float[] fArray, AudioFormat audioFormat) {
        return this.createSample(fArray, audioFormat, 1024);
    }

    public AudioSample createSample(float[] fArray, AudioFormat audioFormat, int n) {
        AudioSample audioSample = this.mimp.getAudioSample(fArray, audioFormat, n);
        this.addSource(audioSample);
        return audioSample;
    }

    public AudioSample createSample(float[] fArray, float[] fArray2, AudioFormat audioFormat) {
        return this.createSample(fArray, fArray2, audioFormat, 1024);
    }

    public AudioSample createSample(float[] fArray, float[] fArray2, AudioFormat audioFormat, int n) {
        AudioSample audioSample = this.mimp.getAudioSample(fArray, fArray2, audioFormat, n);
        this.addSource(audioSample);
        return audioSample;
    }

    public AudioSample loadSample(String string) {
        return this.loadSample(string, 1024);
    }

    public AudioSample loadSample(String string, int n) {
        AudioSample audioSample = this.mimp.getAudioSample(string, n);
        this.addSource(audioSample);
        return audioSample;
    }

    @Deprecated
    public AudioSnippet loadSnippet(String string) {
        AudioRecording audioRecording = this.mimp.getAudioRecording(string);
        if (audioRecording != null) {
            return new AudioSnippet(audioRecording);
        }
        Minim.error("Couldn't load the file " + string);
        return null;
    }

    public AudioPlayer loadFile(String string) {
        return this.loadFile(string, 1024);
    }

    public AudioPlayer loadFile(String string, int n) {
        AudioPlayer audioPlayer = null;
        AudioRecordingStream audioRecordingStream = this.mimp.getAudioRecordingStream(string, n, false);
        if (audioRecordingStream != null) {
            AudioFormat audioFormat = audioRecordingStream.getFormat();
            AudioOut audioOut = this.mimp.getAudioOutput(audioFormat.getChannels(), n, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits());
            if (audioOut != null) {
                audioPlayer = new AudioPlayer(audioRecordingStream, audioOut);
            } else {
                audioRecordingStream.close();
            }
        }
        if (audioPlayer != null) {
            this.addSource(audioPlayer);
        } else {
            Minim.error("Couldn't load the file " + string);
        }
        return audioPlayer;
    }

    public AudioRecordingStream loadFileStream(String string, int n, boolean bl) {
        AudioRecordingStream audioRecordingStream = this.mimp.getAudioRecordingStream(string, n, bl);
        this.streams.add(audioRecordingStream);
        return audioRecordingStream;
    }

    public float loadFileIntoBuffer(String string, MultiChannelBuffer multiChannelBuffer) {
        float f = 0.0f;
        AudioRecordingStream audioRecordingStream = this.mimp.getAudioRecordingStream(string, 4096, false);
        if (audioRecordingStream != null) {
            audioRecordingStream.play();
            f = audioRecordingStream.getFormat().getSampleRate();
            int n = audioRecordingStream.getFormat().getChannels();
            MultiChannelBuffer multiChannelBuffer2 = new MultiChannelBuffer(n, 4096);
            multiChannelBuffer.setChannelCount(n);
            long l = audioRecordingStream.getSampleFrameLength();
            multiChannelBuffer.setBufferSize((int)l);
            for (long i = 0L; i < l; i += (long)multiChannelBuffer2.getBufferSize()) {
                if (l - i < 4096L) {
                    multiChannelBuffer2.setBufferSize((int)(l - i));
                }
                audioRecordingStream.read(multiChannelBuffer2);
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < multiChannelBuffer2.getBufferSize(); ++k) {
                        multiChannelBuffer.setSample(j, (int)i + k, multiChannelBuffer2.getSample(j, k));
                    }
                }
            }
            audioRecordingStream.close();
        } else {
            Minim.debug("Unable to load an AudioRecordingStream for " + string);
        }
        return f;
    }

    public AudioRecorder createRecorder(Recordable recordable, String string) {
        return this.createRecorder(recordable, string, false);
    }

    public AudioRecorder createRecorder(Recordable recordable, String string, boolean bl) {
        SampleRecorder sampleRecorder = this.mimp.getSampleRecorder(recordable, string, bl);
        if (sampleRecorder != null) {
            return new AudioRecorder(recordable, sampleRecorder);
        }
        Minim.error("Couldn't create an AudioRecorder for " + string + ".");
        return null;
    }

    public AudioInput getLineIn() {
        return this.getLineIn(2);
    }

    public AudioInput getLineIn(int n) {
        return this.getLineIn(n, 1024, 44100.0f, 16);
    }

    public AudioInput getLineIn(int n, int n2) {
        return this.getLineIn(n, n2, 44100.0f, 16);
    }

    public AudioInput getLineIn(int n, int n2, float f) {
        return this.getLineIn(n, n2, f, 16);
    }

    public AudioInput getLineIn(int n, int n2, float f, int n3) {
        AudioInput audioInput = null;
        AudioStream audioStream = this.mimp.getAudioInput(n, n2, f, n3);
        if (audioStream != null) {
            AudioOut audioOut = this.mimp.getAudioOutput(n, n2, f, n3);
            if (audioOut != null) {
                audioInput = new AudioInput(audioStream, audioOut);
            } else {
                audioStream.close();
            }
        }
        if (audioInput != null) {
            this.addSource(audioInput);
        } else {
            Minim.error("Minim.getLineIn: attempt failed, could not secure an AudioInput.");
        }
        return audioInput;
    }

    public AudioStream getInputStream(int n, int n2, float f, int n3) {
        AudioStream audioStream = this.mimp.getAudioInput(n, n2, f, n3);
        this.streams.add(audioStream);
        return audioStream;
    }

    public AudioOutput getLineOut() {
        return this.getLineOut(2);
    }

    public AudioOutput getLineOut(int n) {
        return this.getLineOut(n, 1024, 44100.0f, 16);
    }

    public AudioOutput getLineOut(int n, int n2) {
        return this.getLineOut(n, n2, 44100.0f, 16);
    }

    public AudioOutput getLineOut(int n, int n2, float f) {
        return this.getLineOut(n, n2, f, 16);
    }

    public AudioOutput getLineOut(int n, int n2, float f, int n3) {
        AudioOut audioOut = this.mimp.getAudioOutput(n, n2, f, n3);
        if (audioOut != null) {
            AudioOutput audioOutput = new AudioOutput(audioOut);
            this.addSource(audioOutput);
            return audioOutput;
        }
        Minim.error("Minim.getLineOut: attempt failed, could not secure a LineOut.");
        return null;
    }
}

