

// Fruits by Karate Ink Sirup, Graffathon 2015


import moonlander.library.*;
import ddf.minim.*;

PImage bg;
PImage fruitstitle;
PImage spacefruits;
PImage mangotitle;
PImage melontitle;
PImage bananatitle;
PImage clementitle;
PImage appletitle;
PImage avocadotitle;
PImage tomatotitle;
PImage donuttitle;
PImage wegottitle;
PImage juiciesttitle;
PImage greetsitle;
PImage thankstitle;
PImage creditstitle;

PImage bigspace;

PShape mango;
PShape apple;
PShape melon;
PShape banana;
PShape donut;
PShape avocado;
PShape clementine;
PShape tomato;

float ry;
float counter;

int currentScreen;
int width = 1280;
int height = 720;

double rystep;
int a;
int b;
double c;
double d;

Moonlander moonlander;
  
public void setup() {
  size(1280, 720, P3D); 
  frameRate(50);
  bg = loadImage("space_720.jpg");
  apple = loadShape("apple/apple.obj");
  appletitle = loadImage("titles/TEXTS-19.png");
  
  mango = loadShape("mango/mangoo.obj");
  mangotitle = loadImage("titles/TEXTS-06.png");
  melon = loadShape("melon/melon.obj");
  melontitle = loadImage("titles/TEXTS-07.png");
  banana = loadShape("banana/bananacomp2t.obj");
  bananatitle = loadImage("titles/TEXTS-05.png");
  bigspace = loadImage("bigspace.jpg");
  donut = loadShape("donut/donut.obj");
  avocado = loadShape("avocado/avocado.obj");
  clementine = loadShape("clementine/clementine.obj");
  tomato = loadShape ("tomato/tomato mobile.obj");
  
  fruitstitle = loadImage("titles/TEXTS-01.png");
  spacefruits = loadImage("titles/TEXTS-18.png");
  clementitle = loadImage("titles/TEXTS-10.png");
  tomatotitle = loadImage("titles/TEXTS-11.png");
  avocadotitle = loadImage("titles/TEXTS-12.png");
  donuttitle = loadImage("titles/TEXTS-20.png");
  wegottitle = loadImage("titles/TEXTS-13.png");
  juiciesttitle = loadImage("titles/TEXTS-14.png");
  greetsitle = loadImage("titles/TEXTS-16.png");
  thankstitle = loadImage("titles/TEXTS-21.png");
  creditstitle = loadImage("titles/TEXTS-17.png");
  
 
  currentScreen = 1; 
  apple.scale(3.0);
  mango.scale(3.0);
  melon.scale(3.0);
  banana.scale(3.0);
  donut.scale(5.0);
  avocado.scale(3.0);
  clementine.scale(2.0);
  tomato.scale(3.0);
  moonlander = Moonlander.initWithSoundtrack(this, "model.mp3", 140, 1); 
  moonlander.start();
}

public void draw() {
  background(bg); 
  moonlander.update();
  currentScreen = moonlander.getIntValue("currentScreen"); 
  a = moonlander.getIntValue("a");
  b = moonlander.getIntValue("b");
  c = moonlander.getValue("c");
  d = moonlander.getValue("d");
  rystep = moonlander.getValue("rystep");

  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, 127);
  //rotate(ry/10);
  image(bigspace, -width/2, -height/2-ry*5);  
  hint(ENABLE_DEPTH_TEST);

  switch(a) {
    case 0: directionalLight(204, 204, 204, 0, -1, 1); break;
    case 1: directionalLight(204, 204, 204, 0, -1, -0.5); break;
    default: lights(); break;
  }    

  translate(width/2, height/2, 500);
  rotateZ(-ry/1.618*2); //PI
  rotateY(ry);
  rotateX(ry/1.618);
  switch(currentScreen) {
    case 0: dS0(); break;
    case 1: dS1(); break;
    case 2: dS2(); break;
    case 3: dS3(); break;
    case 4: dS4(); break;
    case 5: dS5(); break;
    case 6: dS6(); break;
    case 7: dS7(); break;
    case 8: dS8(); break;
    case 9: dS9(); break;
    case 10: dS10(); break;
    case 11: dS11(); break;
    case 12: dS12(); break;
    case 13: dS13(); break;
    case 14: dS14(); break;
    case 15: dS15(); break;
    default: background(0); break;
  }

  ry += rystep; // 0.02   

}

void dS0() {                // Fruits
  shape(mango);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(fruitstitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}

void dS1() {                // We have space fruits
  shape(apple);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(spacefruits, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}

void dS2() {                // We have mangos
  shape(mango);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(mangotitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}

void dS3() {                // Melons
  shape(melon);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(melontitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}

void dS4() {                // Bananas
  shape(banana);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(bananatitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS5() {                // Clementines
  shape(clementine);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(clementitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS6() {                // Apples
  shape(apple);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(appletitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS7() {                // Tomatoes
  shape(tomato);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(tomatotitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS8() {                // Avocados
  shape(avocado);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(avocadotitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS9() {                // Donuts
  shape(donut);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(donuttitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS10() {                // Fruits -- we got them
  shape(banana);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(wegottitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS11() {                // Juiciest fruits
  shape(mango);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(juiciesttitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS12() {                // Greetings
  //shape(banana);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(greetsitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS13() {                // Thanks
  //shape(banana);
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(thankstitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS14() {                // Credits
  //shape(banana);             
  hint(DISABLE_DEPTH_TEST);
  camera();
  noLights();
  tint(255, b);
  image(creditstitle, 0, 0); 
  hint(ENABLE_DEPTH_TEST);
}
void dS15() {                // No text
  shape(mango);             // same shapes here as in 11! -----------------------
  
}

