/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Field;

public class AndroidVersion {
    public static final boolean isAvailable;
    public static final String CPU_ABI;
    public static final Platform.CPUType CPU_TYPE;
    public static final Platform.ABIType ABI_TYPE;
    public static final String CPU_ABI2;
    public static final Platform.CPUType CPU_TYPE2;
    public static final Platform.ABIType ABI_TYPE2;
    public static final String CODENAME;
    public static final String INCREMENTAL;
    public static final String RELEASE;
    public static final int SDK_INT;
    public static final String SDK_NAME;
    private static final String androidBuild = "android.os.Build";
    private static final String androidBuildVersion = "android.os.Build$VERSION";
    private static final String androidBuildVersionCodes = "android.os.Build$VERSION_CODES";

    private static final Platform.CPUType getCPUTypeImpl(String string) {
        if (null == string) {
            return null;
        }
        if (string.equals("armeabi-v7a")) {
            return Platform.CPUType.ARMv7;
        }
        if (string.equals("armeabi") || string.startsWith("arm")) {
            return Platform.CPUType.ARM;
        }
        if (string.equals("x86")) {
            return Platform.CPUType.X86_32;
        }
        if (string.equals("mips")) {
            return Platform.CPUType.MIPS_32;
        }
        return null;
    }

    private static final Platform.ABIType getABITypeImpl(Platform.CPUType cPUType, String string) {
        if (null == cPUType || null == string) {
            return null;
        }
        if (Platform.CPUFamily.ARM != cPUType.family) {
            return Platform.ABIType.GENERIC_ABI;
        }
        return Platform.ABIType.EABI_GNU_ARMEL;
    }

    private static final IntObjectHashMap getVersionCodes(Class<?> clazz, Object object) {
        Field[] fieldArray = clazz.getFields();
        IntObjectHashMap intObjectHashMap = new IntObjectHashMap(3 * fieldArray.length / 2, 0.75f);
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                int n = fieldArray[i].getInt(object);
                String string = fieldArray[i].getName();
                intObjectHashMap.put(new Integer(n), string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return intObjectHashMap;
    }

    private static final String getString(Class<?> clazz, Object object, String string, boolean bl) {
        try {
            Field field = clazz.getField(string);
            String string2 = (String)field.get(object);
            if (bl && null != string2) {
                return string2.toLowerCase();
            }
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static final int getInt(Class<?> clazz, Object object, String string) {
        try {
            Field field = clazz.getField(string);
            return field.getInt(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    static {
        ClassLoader classLoader = AndroidVersion.class.getClassLoader();
        Class<?> clazz = null;
        Object var2_2 = null;
        Class<?> clazz2 = null;
        Object var4_4 = null;
        Class<?> clazz3 = null;
        Object var6_6 = null;
        try {
            clazz = ReflectionUtil.getClass(androidBuild, true, classLoader);
            var2_2 = clazz.newInstance();
            clazz2 = ReflectionUtil.getClass(androidBuildVersion, true, classLoader);
            var4_4 = clazz2.newInstance();
            clazz3 = ReflectionUtil.getClass(androidBuildVersionCodes, true, classLoader);
            var6_6 = clazz3.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = isAvailable = null != var2_2 && null != var4_4 && null != var6_6;
        if (isAvailable) {
            CPU_ABI = AndroidVersion.getString(clazz, var2_2, "CPU_ABI", true);
            CPU_ABI2 = AndroidVersion.getString(clazz, var2_2, "CPU_ABI2", true);
            CODENAME = AndroidVersion.getString(clazz2, var4_4, "CODENAME", false);
            INCREMENTAL = AndroidVersion.getString(clazz2, var4_4, "INCREMENTAL", false);
            RELEASE = AndroidVersion.getString(clazz2, var4_4, "RELEASE", false);
            SDK_INT = AndroidVersion.getInt(clazz2, var4_4, "SDK_INT");
            IntObjectHashMap intObjectHashMap = AndroidVersion.getVersionCodes(clazz3, var6_6);
            String string = (String)intObjectHashMap.get(SDK_INT);
            SDK_NAME = null != string ? string : "SDK_" + SDK_INT;
        } else {
            CPU_ABI = null;
            CPU_ABI2 = null;
            CODENAME = null;
            INCREMENTAL = null;
            RELEASE = null;
            SDK_INT = -1;
            SDK_NAME = null;
        }
        CPU_TYPE = AndroidVersion.getCPUTypeImpl(CPU_ABI);
        ABI_TYPE = AndroidVersion.getABITypeImpl(CPU_TYPE, CPU_ABI);
        CPU_TYPE2 = AndroidVersion.getCPUTypeImpl(CPU_ABI2);
        ABI_TYPE2 = AndroidVersion.getABITypeImpl(CPU_TYPE2, CPU_ABI2);
    }
}

