
procedure Poke(a: word; value: byte);
begin

asm
{	mwa a ztmp
	ldy #0
	mva value (ztmp),y
};

end;


procedure DPoke(a: word; value: word);
begin

asm
{	mwa a ztmp
	ldy #0
	mva value (ztmp),y
	iny
	mva value+1 (ztmp),y
};

end;



function Peek(a: word): byte;
begin

asm
{	mwa a ztmp
	ldy #0
	mva (ztmp),y Result
};

end;


function DPeek(a: word): word;
begin

asm
{	mwa a ztmp
	ldy #0
	mva (ztmp),y Result
	iny
	mva (ztmp),y Result+1
};

end;


function Random(range: byte): byte;
begin

 result:=Peek($d20a) mod range;

end;


procedure Fillchar(a: pointer; count: word; value: byte);
//----------------------------------------------------------------------------------------------
// Fills the memory starting at A with Count bytes or characters with value equal to Value
//----------------------------------------------------------------------------------------------
begin

asm
{	stx @sp

	mwa a dst

	ldx #0
	ldy #0
	lda value

loop	cpy count
	bne @+
	cpx count+1
	beq stop

@	sta $ffff,y
dst	equ *-2

	iny
	bne @+
	inc dst+1
	inx
@
	bne loop

stop	ldx @sp
};

end;



procedure Move(source, dest: pointer; count: word);
//----------------------------------------------------------------------------------------------
// Moves Count bytes from Source to Dest
//----------------------------------------------------------------------------------------------
begin

asm
{	stx @sp

	mwa source src
	mwa dest dst

	ldx #0
	ldy #0

loop	cpy count
	bne @+
	cpx count+1
	beq stop

@	lda $ffff,y
src	equ *-2
	sta $ffff,y
dst	equ *-2
	
	iny
	bne @+
	inc src+1
	inc dst+1
	inx
@
	bne loop

stop	ldx @sp
};

end;




