class RemoteGameScene extends Scene {
  
  int lastFrame = 0;
  boolean accleration = false, turnRight = false, turnLeft = false, shooting = false;
  Blur blur = null;
  RemoteGameClient client;
  Universe universe;
  
  public RemoteGameScene(PApplet applet, Client networkClient) {
    super(applet);
  
    this.universe = new Universe();
    this.client = new RemoteGameClient(this.universe, networkClient);
  }
  
  public void clean() {
  }
  
  public void setup() {
    background(0);
    
    blur = new Blur();
    blur.init();
    
    lastFrame = millis();
  }
  
  public void draw() {  
    int currentFrame = millis();
    float elapsed = (float)(currentFrame - lastFrame) / 1000.0f;
    lastFrame = currentFrame;
    
    client.update(elapsed);
    
    universe.update(elapsed);
    universe.draw();
    
    blur.applyEffect();
  }
  
  public void keyReleased() {
    if (keyCode == 0x20) {
      if (shooting) {
        shooting = false;
        client.shoot(shooting);
      }
    }
    
    if (key == CODED) {
      if (keyCode == UP) {
        if (accleration) {
          accleration = false;
          client.accleration(accleration);
        }
      }
      
      if (keyCode == LEFT) {
        if (turnLeft) {
          turnLeft = false;
          client.turnLeft(turnLeft);
        }
      }
      
      if (keyCode == RIGHT) {
        if (turnRight) {
          turnRight = false;
          client.turnRight(turnRight);
        }
      }
    }
  }
    
  public void keyPressed() {
    if (keyCode == 0x20) {
      if (!shooting) {
        shooting = true;
        client.shoot(shooting);
      }
    }
    
    if (key == CODED) {
      if (keyCode == UP) {
        if (!accleration) {
          accleration = true;
          client.accleration(accleration);
        }
      }
      if (keyCode == LEFT) {
        if (!turnLeft) {
          turnLeft = true;
          client.turnLeft(turnLeft);
        }
      }
      if (keyCode == RIGHT) {
        if (!turnRight) {
          turnRight = true;
          client.turnRight(turnRight);
        }
      }
    }
  }
  
  public void disconnectEvent(Client client) {
    currentScene.clean();
    currentScene = new GameModeScene(this.applet);
    currentScene.setup();
  }
}

class RemoteGameClient {
  
  Client remoteClient;
  Universe universe;
  
  public RemoteGameClient(Universe universe, Client remoteClient) {
    this.universe = universe;
    this.remoteClient = remoteClient;
  }
  
  public void accleration(boolean value) {
    if (value) {
      remoteClient.write('a');
    } else {      
      remoteClient.write('e');
    }
  }
  
  public void turnLeft(boolean value) {
    if (value) {
      remoteClient.write('b');
    } else {      
      remoteClient.write('f');
    }
  }
  
  public void turnRight(boolean value) {
    if (value) {
      remoteClient.write('c');
    } else {      
      remoteClient.write('g');
    }
  }
  
  public void shoot(boolean value) {
    if (value) {
      remoteClient.write('d');
    } else {      
      remoteClient.write('h');
    }
  }
  
  public void update(float elapsed) {
    if (!remoteClient.active()) {
      return;
    }
    
    if (remoteClient.available() > 0) {
      parseMessage();
    } 
  }
  
  void parseMessage() {
    String t = remoteClient.readStringUntil((int)'|');

    if (t == null) return;
    
    String[] tokens = split(t.substring(0, t.length() - 1), ':');  
    int c = 0;
    
    String command = tokens[c++]; 
    if ("x".equals(command)) {
      int type = int(tokens[c++]);
      int id = int(tokens[c++]);
      
      universe.destroy(type, id);
    } else if ("y".equals(command)) {      
      while(c < tokens.length) {
        command = tokens[c++];
        if ("a".equals(command)) {
          universe.asteroid(
            int(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            boolean(tokens[c++]),
            boolean(tokens[c++]),
            boolean(tokens[c++]),
            int(tokens[c++])
          );
        } else if ("s".equals(command)) {
          universe.ship(
            int(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            boolean(tokens[c++]),
            boolean(tokens[c++]),
            boolean(tokens[c++]),
            int(tokens[c++])
          );
        } else if ("b".equals(command)) {
          universe.bullet(
            int(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            int(tokens[c++]),
            int(tokens[c++])
          );
        } else if ("e".equals(command)) {
          universe.explosion(
            int(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++])
          );
        }
      }
    } else if ("a".equals(command)) {       
      universe.asteroid(
          int(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          boolean(tokens[c++]),
          boolean(tokens[c++]),
          boolean(tokens[c++]),
          int(tokens[c++])
        );
    } else if ("s".equals(command)) {
        universe.ship(
          int(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          boolean(tokens[c++]),
          boolean(tokens[c++]),
          boolean(tokens[c++]),
          int(tokens[c++])
        );
      } else if ("b".equals(command)) {
        universe.bullet(
          int(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          float(tokens[c++]),
          int(tokens[c++]),
          int(tokens[c++])
        );
      } else if ("e".equals(command)) {
          universe.explosion(
            int(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++]),
            float(tokens[c++])
          );
        }
  } 
}