class LocalUniverse extends Universe {
  
  GameClient[] clients = new GameClient[MAX_SHIP];
  GameServer server = null;  
  color[] colors = new color[] {
    color(255, 255, 255),
    color(255, 0, 0),
    color(255, 255, 0),
    color(0, 255, 255)
  };
  
  public LocalUniverse(PApplet applet, boolean acceptRemote) {
    if (acceptRemote) {
      this.server = new GameServer(applet, this, PORT);
    }
  }
  
  public void destroy(int type, int id) {
    super.destroy(type, id);
    
    if (server != null) {
      server.destroy(type, id);
    }
  }
  
  public void updateObject(GameObject go) {
    if (server != null) {
      server.write(go.serialize());
    }
  }
  
  public void reset() {
    for( int b = 0; b < bullets.length; ++b) {
      bullets[b].visible = false;
    }
    for( int a = 0; a < asteroids.length; ++a) {
      asteroids[a].visible = false;
    }
    for( int s = 0; s < ships.length; ++s) {
      ships[s].visible = false;
    }
    for( int e = 0; e < explosions.length; ++e) {
      explosions[e].visible = false;
    }
    for( int c = 0; c < clients.length; ++c) {
      if (clients[c] == null) continue;      
      shipReset(clients[c].ship);
    }
  }
  
  void shipReset(Ship s) {
    s.sync(width / 2, height / 2, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, false, false, false, s.entityColor);
    s.visible = true;
    updateObject(s);
  }
  
  void onDamage(int indexOfShip, Ship s) {
    --clients[indexOfShip].life;    
    if (clients[indexOfShip].life > 0) {
      shipReset(s);
    } else {
      destroy(s.type, s.id);
    }
  }
  
  public void update(float elapsed) {
    super.update(elapsed);
    
    // check bullet -> asteroid, ship, life
    for(int b = 0; b < bullets.length; ++b) {
      if (bullets[b].visible) {
        
        if (bullets[b].life <= 0.0f) {
          destroy(bullets[b].type, bullets[b].id);
          continue;
        }
        
        for (int a = 0; a < asteroids.length; ++a) {
          if (asteroids[a].visible) {
            if (bullets[b].collide(asteroids[a].modelTranslated)) {
              
              clients[bullets[b].shipId].points += 1;
              updateObject(explosion(asteroids[a].position[0], asteroids[a].position[1], 10.0f));
              
              destroy(bullets[b].type, bullets[b].id);
              destroy(asteroids[a].type, asteroids[a].id);
              break;
            }
          }
        }
        
        for (int s = 0; s < ships.length; ++s) {
          if (ships[s].visible && ships[s].entityColor != bullets[b].entityColor) {
            if (bullets[b].collide(ships[s].model1Translated)) {
              
              clients[bullets[b].shipId].points += 10;
              updateObject(explosion(ships[s].position[0], ships[s].position[1], 10.0f));
              
              destroy(bullets[b].type, bullets[b].id);
              onDamage(s, ships[s]);
              break;
            }
          }
        }
      }
    }
  
    // check asteroids -> ship
    for (int a = 0; a < asteroids.length; ++a) {
      if (asteroids[a].visible) {
        for (int s = 0; s < ships.length; ++s) {
          if (asteroids[a].collide(ships[s].model1Translated)) {
            
              clients[s].points += 2;
              updateObject(explosion(asteroids[a].position[0], asteroids[a].position[1], 10.0f));
              destroy(asteroids[a].type, asteroids[a].id);
              onDamage(s, ships[s]);
              break;
          }
        }
      }
    }
    
    // shooting
    for(int c = 0; c < clients.length; ++c) {
      if (clients[c] != null) {
        clients[c].update(elapsed);
      }
    }
    
    if (this.server != null) {
      this.server.update(elapsed);
    }
    
    // asteroids respawn
    for (int a = 0; a < asteroids.length; ++a) {
      if (!asteroids[a].visible) {
        asteroids[a].sync(random(width), random(height), 10.5f, 0.2f, 2.0f, 0.0f, 1.0f, false, false, false, color(130)); 
        asteroids[a].visible = true;
        updateObject(asteroids[a]);
        
        break;
      }
    }
  }
  
  public GameClient getGameClient(Client remoteClient) {
    if (remoteClient == null) return null;
    
    for(int c = 0; c < clients.length; ++c) {
      if (clients[c] != null && clients[c].remoteClient == remoteClient) {
        return clients[c];
      }
    }
    
    return null;
  }
  
  public GameClient connect(Client remoteClient) {
    
    int i = 0;
    for (int s = 0; s < ships.length; ++s) {
      if (!ships[s].visible) {
        i = s;
        break;
      }
    }
    
    Ship s = ship(width / 2, height / 2, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, false, false, false, colors[i]);
    if (s != null) {
      clients[s.id] = new GameClient(this, s, remoteClient);
      
      if (remoteClient != null) {
        server.sync(remoteClient, this);
      }
      
      return clients[s.id]; 
    }
    return null;
  }
  
  public void disconnect(Client remoteClient) {
    for(int c = 0; c < clients.length; ++c) {
      if (clients[c] != null && clients[c].remoteClient == remoteClient) {
        disconnect(clients[c]);
        break;
      }
    }
  }
  
  public void disconnect(GameClient client) {    
    destroy(client.ship.type, client.ship.id);
    clients[client.ship.id] = null;
  }
}