#include <stdio.h>
#include <allegro5/allegro.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_acodec.h>
#include <math.h>

#define LIFE 3101
const float FPS = 60;
const int SCREEN_W = 1366;
const int SCREEN_H = 768;
const int BOUNCER_SIZE = 32;

bool timer_is(ALLEGRO_TIMER *timer, int from, int to) {
	bool return_value;
	if(al_get_timer_count(timer) <= to && al_get_timer_count(timer) >= from)
		return_value = true;
	else
		return_value = false;
	return return_value;
}

void draw_scroller(ALLEGRO_FONT *font, int x, int y, ALLEGRO_COLOR colour, char *message) {
	al_draw_text(font, colour, 
			y, x, ALLEGRO_ALIGN_CENTRE, message);
}

ALLEGRO_COLOR random_colour(void) {
	ALLEGRO_COLOR colour = al_map_rgba(rand(),rand(),rand(),rand());
	return colour;
}

void strobe(ALLEGRO_COLOR colour){
	al_clear_to_color(colour);
}
int main(int argc, char **argv){
	ALLEGRO_DISPLAY *display = NULL;
	ALLEGRO_EVENT_QUEUE *event_queue = NULL;
	ALLEGRO_TIMER *timer = NULL;
	ALLEGRO_FONT *greetfont = NULL;
	ALLEGRO_SAMPLE *music = NULL;
	/* {{{ Init stuff */
	bool redraw = true;

	if(!al_init()) {
		fprintf(stderr, "failed to initialize allegro!\n");
		return -1;
	}

	al_init_font_addon();
	al_init_ttf_addon();

	if (!al_install_audio()) {
		fprintf(stderr, "failed to initialize audio!\n");
		return -1;
	}
	if (!al_init_acodec_addon()) {
		fprintf(stderr, "failed to initialize audio codecs!\n");
		return -1;
	}
	if (!al_install_keyboard()) {
		fprintf(stderr, "failed to init keyboard!\n");
		return -1;
	}
	ALLEGRO_KEYBOARD_STATE key;
	if (!al_reserve_samples(1)) {
		fprintf(stderr, "failed to reserve samples!\n");
		return -1;
	}
	music = al_load_sample("Untitled.wav");
	if (!music) {
		fprintf(stderr, "failed to load music!\n");
		return -1;
	}


	timer = al_create_timer(1.0 / FPS);
	if(!timer) {
		fprintf(stderr, "failed to create timer!\n");
		return -1;
	}

	display = al_create_display(SCREEN_W, SCREEN_H);
	al_set_new_display_option(ALLEGRO_VSYNC, 1, ALLEGRO_REQUIRE);
	if(!display) {
		fprintf(stderr, "failed to create display!\n");
		al_destroy_timer(timer);
		return -1;
	}

	greetfont = al_load_ttf_font("greetfont.ttf", 48,0);
	if(!greetfont)
	{
		fprintf(stderr, "failed to load font");
		return -1;
	}
	if (!al_init_image_addon()) {
		fprintf(stderr, "failed to init image addon");
		return -1;
	}

	event_queue = al_create_event_queue();
	if(!event_queue) {
		fprintf(stderr, "failed to create event_queue!\n");
		al_destroy_display(display);
		al_destroy_timer(timer);
		return -1;
	}
	/* }}} */

	al_register_event_source(event_queue, al_get_display_event_source(display));
	al_register_event_source(event_queue, al_get_timer_event_source(timer));
	al_clear_to_color(al_map_rgb(0,0,0));
	al_flip_display();
	al_start_timer(timer);
	/*{{{ bitmaps*/
	ALLEGRO_BITMAP *s_sagan = NULL;
	s_sagan = al_load_bitmap("pics/sagan.png");

	ALLEGRO_BITMAP *s_sagan2 = NULL;
	s_sagan2 = al_load_bitmap("pics/sagan2.png");

	ALLEGRO_BITMAP *s_spoiler = NULL;
	s_spoiler = al_load_bitmap("pics/facerape.png");

	ALLEGRO_BITMAP *s_face = NULL;
	s_face = al_load_bitmap("pics/face.png");

	ALLEGRO_BITMAP *s_face_inv = NULL;
	s_face_inv = al_load_bitmap("pics/face_inv.png");

	ALLEGRO_BITMAP *s_aids = NULL;
	s_aids = al_load_bitmap("pics/aids.png");

	ALLEGRO_BITMAP *s_overlay = NULL;
	s_overlay = al_load_bitmap("pics/overlay.png");

	ALLEGRO_BITMAP *s_bong = NULL;
	s_bong = al_load_bitmap("pics/bong.png");

	ALLEGRO_BITMAP *s_bilk = NULL;
	s_bilk = al_load_bitmap("pics/bilk.png");

	ALLEGRO_BITMAP *s_spin1 = NULL;
	s_spin1 = al_load_bitmap("pics/spin_bg1.png");

	ALLEGRO_BITMAP *s_oel = NULL;
	s_oel = al_load_bitmap("pics/oel.png");

	ALLEGRO_BITMAP *s_flash = NULL;
	s_flash = al_load_bitmap("pics/flash.png");

	ALLEGRO_BITMAP *s_banana = NULL;
	s_banana = al_load_bitmap("pics/banana.png");
	/*}}}*/
	/*}}}*/
	float bouncer_x = SCREEN_W / 2.0 - BOUNCER_SIZE / 1.0;
	float bouncer_y = SCREEN_H / 2.0 - BOUNCER_SIZE / 1.0;
	float bouncer_dx = -16.0, bouncer_dy = 16.0;

	int strobe_timer;
	int font_y = 0;
	int font_y2 = 0;
	bool reverse_text = false;
	bool reverse_sagan = false;
	int sagan_pos = 1;
	float sagan_angle = 1.0f;
	int face_fade = 1;
	float scale_face_inv = 1.0f;
	float scale_aids = 1.0f;
	bool reverse_aids = false;

	const ALLEGRO_COLOR WHITE = al_map_rgb(255,255,255);
	const ALLEGRO_COLOR RED = al_map_rgb(255,0,0);
	const ALLEGRO_COLOR GREEN = al_map_rgb(0,255,0);
	const ALLEGRO_COLOR BLUE = al_map_rgb(0,0,255);
	const ALLEGRO_COLOR BLACK = al_map_rgb(0,0,0);

while(1)
{
	ALLEGRO_EVENT ev;
	al_wait_for_event(event_queue, &ev);
	al_get_keyboard_state(&key);
	al_play_sample(music,1.0,0.0,1.0,ALLEGRO_PLAYMODE_LOOP,NULL);
	if(ev.type == ALLEGRO_EVENT_TIMER) {

		/*
		 * computations goes here
		 */
		face_fade++;
		sagan_angle += 0.2f;
		scale_face_inv += 0.1f;
		if(scale_face_inv > 2.0f)
			scale_face_inv = 1.0f;

		if(strobe_timer > 6)
			strobe_timer = 0;
		strobe_timer++;
		if(timer_is(timer, 401, 800))
			sagan_angle +=0.1f;
		if(timer_is(timer, 1201, 1900)) {
			if(reverse_aids)
				scale_aids -= 0.05f;
			else
				scale_aids += 0.051f;
			if(scale_aids < 0)
				reverse_aids = false;
			if(scale_aids > 2.0f)
				reverse_aids = true;
		}
		if(bouncer_x < 0 || bouncer_x > SCREEN_W - BOUNCER_SIZE)
			bouncer_dx = -bouncer_dx;

		if(bouncer_y < 0 || bouncer_y > SCREEN_H - BOUNCER_SIZE)
			bouncer_dy = -bouncer_dy;

		bouncer_x += bouncer_dx;
		bouncer_y += bouncer_dy;
		if(al_key_down(&key, ALLEGRO_KEY_ESCAPE))
			break;
		redraw = true;
	}
	else if(ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {
		break;
	}

	if(redraw && al_is_event_queue_empty(event_queue)) {
		redraw = false;

		al_clear_to_color(al_map_rgb(0,0,0));


		// Scene 0
		// Scene 1
		if(timer_is(timer, 2, 600)){
			if((reverse_text == false))
				font_y += 4;
			else font_y -= 4;
			if(font_y < 0)
				reverse_text = false;
			if(font_y > SCREEN_W)
				reverse_text = true;
			al_draw_bitmap(s_spoiler, font_y, 200, 0);
			face_fade = 0;
			al_draw_bitmap(s_spoiler, bouncer_y, bouncer_x, 0);
		}
		// Scene 2:0

		// Scene 2:1
		if(timer_is(timer, 601, 1200)){
			if(reverse_text == false)
				font_y += 4;
			else font_y -= 4;
			if(font_y < 0)
				reverse_text = false;
			if(font_y > SCREEN_W)
				reverse_text = true;
			if(strobe_timer > 3) {
				al_clear_to_color(WHITE);
				//al_draw_scaled_bitmap(s_face, 
				//			  0, 0,
				//			  al_get_bitmap_width(s_face), al_get_bitmap_height(s_face),
				//			  0, 0,
				//			  (al_get_bitmap_width(s_face)), 
				//			  (al_get_bitmap_height(s_face)), 0);
				al_draw_bitmap(s_face_inv, 
						SCREEN_W/2, SCREEN_H/2, 0);
				draw_scroller(greetfont, 
						(SCREEN_H/2)-200, font_y, RED, "This is your brain on DEMOS");
			}
			else {
				al_draw_scaled_bitmap(s_aids, 
						0, 0,
						al_get_bitmap_width(s_aids), al_get_bitmap_height(s_face_inv),
						0, 0,
						(al_get_bitmap_width(s_face_inv)) * scale_face_inv, 
						(al_get_bitmap_height(s_face_inv))* scale_face_inv, 0);
			}
		}
		// Scene 2:2
		if(timer_is(timer, 1201, 1500)){
			if((reverse_text == false))
				font_y += 4;
			else font_y -= 4;
			if(font_y < 0)
				reverse_text = false;
			if(font_y > SCREEN_W)
				reverse_text = true;

			if(reverse_sagan == false)
				sagan_pos += 6;
			else sagan_pos -= 6;
			// 420 draw sagan every day
			if(sagan_pos < -420)
				reverse_sagan = false;
			if(sagan_pos > 0)
				reverse_sagan = true;
			al_draw_rotated_bitmap(s_sagan2, al_get_bitmap_width(s_sagan2)/2, 
					al_get_bitmap_height(s_sagan2)/2, SCREEN_W/2, SCREEN_H/2, 
					sagan_angle, 0);
			al_draw_tinted_bitmap(s_sagan, random_colour(), sagan_pos, sagan_pos, 
					ALLEGRO_FLIP_VERTICAL);
			al_draw_tinted_bitmap(s_sagan, random_colour(), 0, sagan_pos, 0);
			al_draw_scaled_bitmap(s_aids,
					20, 20,
					al_get_bitmap_width(s_aids), al_get_bitmap_height(s_aids),
					20, 20,
					al_get_bitmap_width(s_face_inv)* scale_aids, 
					al_get_bitmap_height(s_face_inv)* scale_aids, 
					ALLEGRO_FLIP_HORIZONTAL);
			al_draw_scaled_bitmap(s_aids,
					0, 0,
					al_get_bitmap_width(s_aids), al_get_bitmap_height(s_aids),
					0, 0,
					al_get_bitmap_width(s_face_inv)* scale_aids, 
					al_get_bitmap_height(s_face_inv)* scale_aids, 0);

			draw_scroller(greetfont, 
					font_y, font_y, RED, "100% reused code, dunz0r is quite drunk");
			//al_draw_scaled_bitmap(s_face, 
			//	0, 0,
			//	al_get_bitmap_width(s_face_inv), al_get_bitmap_height(s_face_inv),
			//	0, 0,
			//	(al_get_bitmap_width(s_face_inv)) * scale_face_inv, 
			//	(al_get_bitmap_height(s_face_inv))* scale_face_inv, 0);

		}

		if(timer_is(timer, 1501, 1900)){
			if((reverse_text == false))
				font_y += 4;
			else font_y -= 4;
			if(font_y < 0)
				reverse_text = false;
			else if(font_y > SCREEN_W)
				reverse_text = true;
			al_draw_scaled_rotated_bitmap(s_spin1,
					al_get_bitmap_width(s_spin1)/2,al_get_bitmap_height(s_spin1)/2,
					al_get_bitmap_width(s_spin1)/2,al_get_bitmap_height(s_spin1)/2,
					2, 2,
					sagan_angle, 0);
			draw_scroller(greetfont, 100, font_y, random_colour(), 
					"code, music: dunz0r");
			draw_scroller(greetfont, 150, font_y, random_colour(), 
					"gfx:");
			draw_scroller(greetfont, 200, font_y, random_colour(), 
					"dunz0r, topatisen(not here, homogay), marmite(not here, homogay)");
		}
		if(timer_is(timer, 1901, 2500)){

			if((reverse_text == true))
				font_y2 += 2;
			else font_y2 -= 2;
			if(font_y2 < 50)
				reverse_text = false;
			if(font_y2 > SCREEN_W-50)
				reverse_text = true;


			al_draw_scaled_rotated_bitmap(s_spin1,
					al_get_bitmap_width(s_spin1)/2,al_get_bitmap_height(s_spin1)/2,
					al_get_bitmap_width(s_spin1)/2,al_get_bitmap_height(s_spin1)/2,
					2, 2,
					sagan_angle, 0);
			draw_scroller(greetfont, 200, 500, al_map_rgb(255,255,255), 
					"Greets to");
			draw_scroller(greetfont, 300, 500, random_colour(), 
					"malmen, such, pandadesign, husvagn crew, nissoc");
			draw_scroller(greetfont, 400, 500, random_colour(), 
					"memory l8ek, somalian pirate party");
			draw_scroller(greetfont, 500, 500, random_colour(), 
					"pew^2, topatisen, marmite, #faf, fastbom");
		}
		if(timer_is(timer, 2501, 2501))
			return 23943849;


		al_flip_display();
	}
}
al_destroy_bitmap(s_spoiler);
al_destroy_sample(music);
al_destroy_timer(timer);
al_destroy_display(display);
al_destroy_event_queue(event_queue);

return 0;
}
