#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_rotozoom.h>
#include <SDL/SDL_mixer.h>
#include <stdio.h>

#define SCREEN_H 900
#define SCREEN_W 1600

const float g_grav = 0.1f;
float g_speed = 0.0f;
const float g_bouncy = -0.85f;
int g_heading = 2;

int g_scene = 0;

char g_scenes[][15] = {
	"dunz.png\0",
	"iwin.png\0",
	"bybkc.png\0",
	"greets.png\0",
	"facerape.png\0",
	"husvagn.png\0",
	"spp.png\0"
};

Mix_Chunk *g_bounce = NULL;

int calc_xy(const SDL_Rect constraint, SDL_Rect *ball, int t) {
	// update y-pos
	float temp_t = t / 5.0f;
	g_speed = g_speed + (g_grav * temp_t);
	float temp_y = ball->y + (g_speed * temp_t);
	float temp_x = ball->x + (g_heading * 1.0);

	short max_y = (SCREEN_H - ball->h);
	short max_x = (SCREEN_W - ball->w);
	printf("max_x: %i\n", max_x);
	int ret = 0;
	if(temp_y >= max_y) {
		g_speed *= g_bouncy;
		Mix_PlayChannel(-1, g_bounce, 0);
	}
	ball->y = temp_y;
	ball->x = temp_x;
	if(ball->x >= (SCREEN_W - ball->w)) {
		g_heading = 0 - g_heading;
		Mix_PlayChannel(0, g_bounce, 0);
	}
	if(ball->x < 0) {
		g_heading = 0 - g_heading;
		g_speed = 0.0f;
		return 1;
	}
	printf("x: %i\n", ball->x);
	printf("y: %i\n", ball->y);

	return ret;
}

int main(int argc, char* args[]) {
	SDL_Surface* dunz = NULL;
	SDL_Surface* dunz_orig = NULL;
	SDL_Surface* screen = NULL;
	SDL_Event event;

	SDL_Init(SDL_INIT_EVERYTHING|SDL_INIT_AUDIO);
	screen = SDL_SetVideoMode(SCREEN_W, SCREEN_H, 32, SDL_HWACCEL);


	// Initialize Audio
	int flags=0;
	int initted=Mix_Init(flags);
	if((initted&flags) != flags) {
		    printf("Mix_Init: Failed to init required ogg and mod support!\n");
		        printf("Mix_Init: %s\n", Mix_GetError());
		            // handle error
	}
	// open 44.1KHz, signed 16bit, system byte order,
	//      stereo audio, using 1024 byte chunks
	if(Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 1024)==-1) {
		    printf("Mix_OpenAudio: %s\n", Mix_GetError());
		        exit(2);
	}
	g_bounce = Mix_LoadWAV("bounce.wav");
	
	if(!g_bounce) {
		printf("ERROR CANT LOAD WAV!\n");
		printf("Mix_LoadWAV: %s\n", Mix_GetError());
		exit(1);
	}

	// Load Image
	//dunz_orig = IMG_Load("dunz.png");
	dunz_orig = IMG_Load(g_scenes[g_scene]);
	int startTick = SDL_GetTicks();
	int prevTick = SDL_GetTicks();
	int curTick = SDL_GetTicks();

	SDL_Rect position, screen_rect;
	position.x = 0;
	position.y = 0;
	position.h = dunz_orig->h;
	position.w = dunz_orig->w;
	screen_rect.w = SCREEN_W;
	screen_rect.h = SCREEN_H;

	int running = 1;
	while(running) {
		curTick = SDL_GetTicks();
		if(prevTick > curTick) { // we OOBd
			prevTick = 0;
			curTick = 0;
		}
		if(SDL_PollEvent(&event)) {
			if(event.type == SDL_QUIT) {
				running = 0;
			}
			if(event.type == SDL_KEYDOWN) {
				if(event.key.keysym.sym == SDLK_ESCAPE) {
					running = 0;
				}
			}
		}
		if(calc_xy(screen_rect, &position, (curTick - prevTick)) == 1) {
			g_scene++;
			SDL_FreeSurface(dunz_orig);
			dunz_orig = IMG_Load(g_scenes[g_scene]);
			position.x = 0;
			position.y = 0;
			position.h = dunz_orig->h;
			position.w = dunz_orig->w;

		}

		// Clear Screen
		SDL_FillRect(screen, &screen->clip_rect, SDL_MapRGB(screen->format, 0xFF, 0xFF, 0xFF));

		// Copy dunz
		dunz = dunz_orig;
		dunz->refcount++;
#if 0
		// Calc rotation
		int rot = (SDL_GetTicks() - startTick)*360/1000;
		rotozoomSurface(dunz, rot, 1.0, 1);
#endif
		// flip x-pos
//		position.x = 0 - position.x;
		// Render Biatch
		SDL_BlitSurface(dunz, NULL, screen, &position);
//		position.x = 0 - position.x;

		// Update Screen
		SDL_Flip(screen);

		// Destroy dunz copy
		SDL_FreeSurface(dunz);
		dunz = NULL;
//		printf("shit is happening biatch... %d\n", SDL_GetTicks() - startTick);

		// Update Ticks :)
		prevTick = curTick;
	}

	// Cleanup
	Mix_FreeChunk(g_bounce);
	g_bounce=NULL; // to be safe...
	Mix_Quit();
	if(dunz != NULL) SDL_FreeSurface(dunz);
	SDL_FreeSurface(dunz_orig);
	SDL_Quit();

	return 0;
}
